/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FilteredFormProcessor;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.action.ActionFormResult;
import org.alfresco.repo.forms.processor.action.ActionNonParameterField;
import org.alfresco.repo.forms.processor.action.ActionParameterField;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class ActionFormProcessor
extends FilteredFormProcessor<ActionDefinition, ActionFormResult> {
    public static final String ITEM_KIND = "action";
    protected static final String EXECUTE_ASYNCHRONOUSLY = "executeAsynchronously";
    private static Log logger = LogFactory.getLog(ActionFormProcessor.class);
    private ActionService actionService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected ActionDefinition getTypedItem(Item item) {
        String actionDefId = item.getId();
        ActionDefinition actionDef = null;
        try {
            actionDef = this.actionService.getActionDefinition(actionDefId);
        }
        catch (NoSuchBeanDefinitionException nsbdx) {
            // empty catch block
        }
        if (actionDef == null) {
            throw new FormNotFoundException(item);
        }
        return actionDef;
    }

    @Override
    protected String getItemType(ActionDefinition item) {
        return item.getName();
    }

    @Override
    protected String getItemURI(ActionDefinition item) {
        return "";
    }

    @Override
    protected ActionFormResult internalPersist(ActionDefinition item, FormData data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Persisting form for: " + item));
        }
        Action actionToExecute = this.createActionAndParams(item, data);
        NodeRef actionedUponNodeRef = this.getActionedUponNodeRef(item, data);
        boolean isAsync = this.isAsynchronousActionRequest(item, data);
        this.actionService.executeAction(actionToExecute, actionedUponNodeRef, true, isAsync);
        Serializable result = actionToExecute.getParameterValue("result");
        return new ActionFormResult(actionToExecute, result);
    }

    private Action createActionAndParams(ActionDefinition item, FormData data) {
        Action action = null;
        try {
            action = this.actionService.createAction(item.getName());
        }
        catch (NoSuchBeanDefinitionException nsbdx) {
            throw new FormException("Unrecognised action name " + item.getName(), nsbdx);
        }
        HashMap<String, Serializable> actionParameters = new HashMap<String, Serializable>();
        List<ParameterDefinition> actionParamDefs = item.getParameterDefinitions();
        for (ParameterDefinition actionParamDef : actionParamDefs) {
            String paramDefinitionName = actionParamDef.getName();
            FormData.FieldData fieldData = data.getFieldData("prop_" + paramDefinitionName);
            if (fieldData == null) {
                fieldData = data.getFieldData("assoc_" + paramDefinitionName + "_added");
            }
            if (fieldData == null) continue;
            Object fieldValueObj = fieldData.getValue();
            QName expectedParamType = actionParamDef.getType();
            DataTypeDefinition typeDef = this.dictionaryService.getDataType(expectedParamType);
            Object convertedObj = null;
            convertedObj = DataTypeDefinition.QNAME.equals((Object)expectedParamType) ? (((String)fieldValueObj).charAt(0) == '{' ? QName.createQName((String)((String)fieldValueObj)) : QName.createQName((String)((String)fieldValueObj), (NamespacePrefixResolver)this.namespaceService)) : DefaultTypeConverter.INSTANCE.convert(typeDef, fieldValueObj);
            actionParameters.put(paramDefinitionName, (Serializable)convertedObj);
        }
        action.setParameterValues(actionParameters);
        return action;
    }

    private NodeRef getActionedUponNodeRef(ActionDefinition item, FormData data) {
        FormData.FieldData actionedUponNodeRef = data.getFieldData("alf_destination");
        NodeRef result = null;
        if (actionedUponNodeRef != null) {
            String nodeRefString = (String)actionedUponNodeRef.getValue();
            if (NodeRef.isNodeRef((String)nodeRefString)) {
                result = new NodeRef(nodeRefString);
            } else {
                throw new FormException("Illegal actionedUponNodeRef: " + nodeRefString);
            }
        }
        return result;
    }

    private boolean isAsynchronousActionRequest(ActionDefinition item, FormData data) {
        FormData.FieldData executeAsynchronously = data.getFieldData(EXECUTE_ASYNCHRONOUSLY);
        boolean result = false;
        if (executeAsynchronously != null) {
            result = Boolean.valueOf((String)executeAsynchronously.getValue());
        }
        return result;
    }

    @Override
    protected List<Field> generateDefaultFields(FormCreationData data, List<String> fieldsToIgnore) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ActionItemData itemData = (ActionItemData)data.getItemData();
        for (ParameterDefinition paramDef : itemData.getActionDefinition().getParameterDefinitions()) {
            if (fieldsToIgnore.contains(paramDef.getName())) continue;
            ActionParameterField actionParameterField = new ActionParameterField(paramDef, this.actionService);
            fields.add(actionParameterField);
        }
        fields.add(new ActionNonParameterField(EXECUTE_ASYNCHRONOUSLY, DataTypeDefinition.BOOLEAN));
        return fields;
    }

    @Override
    protected List<Field> generateSelectedFields(List<String> requestedFields, FormCreationData data) {
        List<String> fieldsToIgnore = Collections.emptyList();
        List<Field> fields = this.generateDefaultFields(data, fieldsToIgnore);
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : fields) {
            if (!requestedFields.contains(f.getFieldName())) continue;
            results.add(f);
        }
        return results;
    }

    @Override
    protected List<String> getDefaultIgnoredFields() {
        return Collections.emptyList();
    }

    @Override
    protected Object makeItemData(ActionDefinition item) {
        ActionItemData actionItemData = null;
        try {
            Action action = this.actionService.createAction(item.getName());
            actionItemData = new ActionItemData(item, action);
        }
        catch (NoSuchBeanDefinitionException nsbdx) {
            throw new FormException("Failed to create action '" + item.getName() + "'", nsbdx);
        }
        return actionItemData;
    }

    class ActionItemData {
        private ActionDefinition actionDefinition;
        private Action action;

        public ActionItemData(ActionDefinition actionDef, Action action) {
            this.actionDefinition = actionDef;
            this.action = action;
        }

        public ActionDefinition getActionDefinition() {
            return this.actionDefinition;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

