/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;

public class ContentModelField
implements Field {
    private final FieldDefinition fieldDefinition;
    private final ClassAttributeDefinition classDefinition;
    private final Object value;

    public ContentModelField(PropertyDefinition propertyDefinition, PropertyFieldDefinition fieldDef, Object value) {
        this.classDefinition = propertyDefinition;
        this.fieldDefinition = fieldDef;
        this.value = value;
    }

    public ContentModelField(AssociationDefinition assocDefinition, AssociationFieldDefinition fieldDef, Object value) {
        this.classDefinition = assocDefinition;
        this.fieldDefinition = fieldDef;
        this.value = value;
    }

    public ContentModelField(FieldDefinition fieldDef, Object value) {
        this.classDefinition = null;
        this.fieldDefinition = fieldDef;
        this.value = value;
    }

    public boolean isTransient() {
        return this.classDefinition == null;
    }

    public boolean isProperty() {
        return this.fieldDefinition instanceof PropertyFieldDefinition;
    }

    @Override
    public FieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public QName getFullName() {
        if (this.classDefinition == null) {
            return null;
        }
        return this.classDefinition.getName();
    }

    @Override
    public String getFieldName() {
        return this.fieldDefinition.getName();
    }

    public String toString() {
        String type = this.isTransient() ? "Transient " : "";
        type = type + (this.isProperty() ? "Property" : "Association");
        return "Field: " + this.getFieldName() + " Type: " + type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }
}

