/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.FormCreationDataImpl;
import org.alfresco.repo.forms.processor.node.AssociationFieldProcessor;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.MockClassAttributeDefinition;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.NamespaceServiceMemoryImpl;
import org.alfresco.service.namespace.QName;

public class FieldProcessorTest
extends TestCase {
    private static final String PREFIX = "test";
    private static final String URI = "http://test/";
    private static final String NAME1 = "Name1";
    private static final String NAME2 = "Name2";
    private static final String DESCRIPTION1 = "Description";
    private static final String DESCRIPTION2 = "Another Description";
    private static final String TITLE = "Title";
    private static final QName qName1 = QName.createQName((String)"http://test/", (String)"Name1");
    private static final QName qName2 = QName.createQName((String)"http://test/", (String)"Name2");
    private NamespaceService namespaceService;
    private FormCreationData data;

    public void testMakeAssociationFieldDefinition() throws Exception {
        AssociationFieldProcessor processor = new AssociationFieldProcessor();
        processor.setNamespaceService(this.namespaceService);
        String name1 = "assoc:test:Name1";
        Field field = processor.generateField(name1, this.data);
        AssociationFieldDefinition assocFieldDef = (AssociationFieldDefinition)field.getFieldDefinition();
        FieldProcessorTest.assertNotNull((Object)assocFieldDef);
        FieldProcessorTest.assertEquals((String)"assoc_test_Name1", (String)assocFieldDef.getDataKeyName());
        FieldProcessorTest.assertEquals((String)"test:Name1", (String)assocFieldDef.getName());
        FieldProcessorTest.assertEquals((String)"test:Name1", (String)assocFieldDef.getLabel());
        FieldProcessorTest.assertEquals((Object)((Object)AssociationFieldDefinition.Direction.TARGET), (Object)((Object)assocFieldDef.getEndpointDirection()));
        FieldProcessorTest.assertEquals((String)"test:Target", (String)assocFieldDef.getEndpointType());
        FieldProcessorTest.assertEquals((String)DESCRIPTION1, (String)assocFieldDef.getDescription());
        FieldProcessorTest.assertFalse((boolean)assocFieldDef.isProtectedField());
        FieldProcessorTest.assertFalse((boolean)assocFieldDef.isEndpointMandatory());
        FieldProcessorTest.assertFalse((boolean)assocFieldDef.isEndpointMany());
        String name2 = "assoc:test:Name2";
        field = processor.generateField(name2, this.data);
        assocFieldDef = (AssociationFieldDefinition)field.getFieldDefinition();
        FieldProcessorTest.assertEquals((String)TITLE, (String)assocFieldDef.getLabel());
        FieldProcessorTest.assertEquals((String)DESCRIPTION2, (String)assocFieldDef.getDescription());
        FieldProcessorTest.assertTrue((boolean)assocFieldDef.isProtectedField());
        FieldProcessorTest.assertTrue((boolean)assocFieldDef.isEndpointMandatory());
        FieldProcessorTest.assertTrue((boolean)assocFieldDef.isEndpointMany());
    }

    public void testMakePropertyFieldDefinition() throws Exception {
        PropertyFieldProcessor processor = new PropertyFieldProcessor();
        processor.setNamespaceService(this.namespaceService);
        String name1 = "prop:test:Name1";
        Field field = processor.generateField(name1, this.data);
        PropertyFieldDefinition propFieldDef = (PropertyFieldDefinition)field.getFieldDefinition();
        FieldProcessorTest.assertNotNull((Object)propFieldDef);
        FieldProcessorTest.assertEquals((String)"prop_test_Name1", (String)propFieldDef.getDataKeyName());
        FieldProcessorTest.assertEquals((String)"test:Name1", (String)propFieldDef.getName());
        FieldProcessorTest.assertEquals((String)"test:Name1", (String)propFieldDef.getLabel());
        FieldProcessorTest.assertEquals((String)"Default1", (String)propFieldDef.getDefaultValue());
        FieldProcessorTest.assertEquals((String)DESCRIPTION1, (String)propFieldDef.getDescription());
        FieldProcessorTest.assertFalse((boolean)propFieldDef.isProtectedField());
        FieldProcessorTest.assertFalse((boolean)propFieldDef.isMandatory());
        FieldProcessorTest.assertFalse((boolean)propFieldDef.isRepeating());
        String name2 = "prop:test:Name2";
        field = processor.generateField(name2, this.data);
        propFieldDef = (PropertyFieldDefinition)field.getFieldDefinition();
        FieldProcessorTest.assertEquals((String)TITLE, (String)propFieldDef.getLabel());
        FieldProcessorTest.assertEquals((String)DESCRIPTION2, (String)propFieldDef.getDescription());
        FieldProcessorTest.assertEquals((String)"Default2", (String)propFieldDef.getDefaultValue());
        FieldProcessorTest.assertTrue((boolean)propFieldDef.isProtectedField());
        FieldProcessorTest.assertTrue((boolean)propFieldDef.isMandatory());
        FieldProcessorTest.assertTrue((boolean)propFieldDef.isRepeating());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.namespaceService = this.makeNamespaceService();
        this.data = new FormCreationDataImpl(this.makeItemData(), null, null);
    }

    private ContentModelItemData<Void> makeItemData() {
        Map<QName, PropertyDefinition> propDefs = this.makePropertyDefs();
        Map<QName, AssociationDefinition> assocDefs = this.makeAssociationDefs();
        HashMap<QName, Serializable> propValues = new HashMap<QName, Serializable>();
        HashMap<QName, Serializable> assocValues = new HashMap<QName, Serializable>();
        HashMap<String, Object> transientValues = new HashMap<String, Object>();
        return new ContentModelItemData<Object>(null, propDefs, assocDefs, propValues, assocValues, transientValues);
    }

    private Map<QName, AssociationDefinition> makeAssociationDefs() {
        QName targetClass = QName.createQName((String)URI, (String)"Target");
        MockClassAttributeDefinition assocDef1 = MockClassAttributeDefinition.mockAssociationDefinition(qName1, targetClass, null, DESCRIPTION1, false, false, false);
        MockClassAttributeDefinition assocDef2 = MockClassAttributeDefinition.mockAssociationDefinition(qName2, targetClass, TITLE, DESCRIPTION2, true, true, true);
        HashMap<QName, AssociationDefinition> assocDefs = new HashMap<QName, AssociationDefinition>();
        assocDefs.put(qName1, assocDef1);
        assocDefs.put(qName2, assocDef2);
        return assocDefs;
    }

    private Map<QName, PropertyDefinition> makePropertyDefs() {
        QName dataTypeName = QName.createQName((String)URI, (String)"Type");
        MockClassAttributeDefinition propDef1 = MockClassAttributeDefinition.mockPropertyDefinition(qName1, dataTypeName, null, DESCRIPTION1, false, "Default1", false, false);
        MockClassAttributeDefinition propDef2 = MockClassAttributeDefinition.mockPropertyDefinition(qName2, dataTypeName, TITLE, DESCRIPTION2, true, "Default2", true, true);
        HashMap<QName, PropertyDefinition> propDefs = new HashMap<QName, PropertyDefinition>();
        propDefs.put(qName1, propDef1);
        propDefs.put(qName2, propDef2);
        return propDefs;
    }

    private NamespaceService makeNamespaceService() {
        NamespaceServiceMemoryImpl nsService = new NamespaceServiceMemoryImpl();
        nsService.registerNamespace(PREFIX, URI);
        return nsService;
    }
}

