/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.processor.AbstractFieldProcessor;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public abstract class QNameFieldProcessor<Type extends ClassAttributeDefinition>
extends AbstractFieldProcessor<ContentModelItemData<?>> {
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;

    public QNameFieldProcessor() {
    }

    public QNameFieldProcessor(NamespaceService namespaceService, DictionaryService dictionaryService) {
        this.namespaceService = namespaceService;
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected Field generateTypedField(String fieldName, FormCreationData formData, ContentModelItemData<?> typedData) {
        QName fullName = this.getFullName(fieldName);
        boolean isForcedField = formData.isForcedField(fieldName);
        Field field = this.generateField(fullName, typedData, isForcedField);
        return field;
    }

    protected QName getFullName(String name) {
        String[] parts = name.split(":");
        String prefix = parts[1];
        String localName = parts[2];
        return QName.createQName((String)prefix, (String)localName, (NamespacePrefixResolver)this.namespaceService);
    }

    protected String getPrefixedName(ClassAttributeDefinition attribDef) {
        return attribDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
    }

    public Field generateField(QName fullName, ContentModelItemData<?> itemData, boolean isForcedField) {
        Type propDef = this.getTypeDefinition(fullName, itemData, isForcedField);
        Field field = null;
        if (propDef != null) {
            Object value = this.getValue(fullName, itemData);
            FieldGroup group = this.getGroup(propDef);
            field = this.makeField(propDef, value, group);
        }
        return field;
    }

    protected void populateFieldDefinition(Type attribDef, FieldDefinition fieldDef, FieldGroup group, String dataKeyPrefix) {
        String attribName = fieldDef.getName();
        fieldDef.setGroup(group);
        String title = attribDef.getTitle();
        title = title == null ? attribName : title;
        fieldDef.setLabel(title);
        fieldDef.setDescription(attribDef.getDescription());
        fieldDef.setProtectedField(attribDef.isProtected());
        String dataKeyName = this.makeDataKeyForName(attribName, dataKeyPrefix);
        fieldDef.setDataKeyName(dataKeyName);
    }

    protected String makeDataKeyForName(String propName, String prefix) {
        String[] nameParts = QName.splitPrefixedQName((String)propName);
        String firstPart = nameParts[0];
        StringBuilder builder = new StringBuilder(prefix);
        if (firstPart.length() > 0) {
            builder.append(firstPart);
            builder.append("_");
        }
        builder.append(nameParts[1]);
        return builder.toString();
    }

    @Override
    protected Class<ContentModelItemData<?>> getExpectedDataType() {
        Class<ContentModelItemData> clazz = ContentModelItemData.class;
        return clazz;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected abstract Field makeField(Type var1, Object var2, FieldGroup var3);

    protected abstract FieldGroup getGroup(Type var1);

    protected abstract Object getValue(QName var1, ContentModelItemData<?> var2);

    protected abstract Type getTypeDefinition(QName var1, ContentModelItemData<?> var2, boolean var3);
}

