/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class CommentsTest {
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static BehaviourFilter behaviourFilter;
    private static ContentService contentService;
    private static NodeService nodeService;
    private static Repository repositoryHelper;
    private static RetryingTransactionHelper transactionHelper;
    private NodeRef testFolder;
    private List<NodeRef> testDocs;

    @BeforeClass
    public static void initTestsContext() throws Exception {
        behaviourFilter = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        contentService = (ContentService)testContext.getBean("ContentService");
        nodeService = (NodeService)testContext.getBean("NodeService");
        repositoryHelper = (Repository)testContext.getBean("repositoryHelper");
        transactionHelper = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    @Before
    public void initIndividualTestContext() throws Exception {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef companyHome = repositoryHelper.getCompanyHome();
                CommentsTest.this.testFolder = CommentsTest.this.createNode(companyHome, "testFolder", ContentModel.TYPE_FOLDER);
                CommentsTest.this.testDocs = new ArrayList(3);
                for (int i = 0; i < 3; ++i) {
                    NodeRef testNode = CommentsTest.this.createNode(CommentsTest.this.testFolder, "testDocInFolder", ContentModel.TYPE_CONTENT);
                    CommentsTest.this.testDocs.add(testNode);
                }
                return null;
            }
        });
    }

    @After
    public void tidyUpTestNodes() throws Exception {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                for (NodeRef nr : CommentsTest.this.testDocs) {
                    if (!nodeService.exists(nr)) continue;
                    nodeService.deleteNode(nr);
                }
                return null;
            }
        });
    }

    private NodeRef createNode(NodeRef parentNode, String name, QName type) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        String fullName = name + "-" + GUID.generate();
        props.put(ContentModel.PROP_NAME, fullName);
        QName docContentQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)fullName);
        NodeRef node = nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, docContentQName, type, props).getChildRef();
        return node;
    }

    @Test
    public void commentOnDocsCheckingCommentCountRollup() throws Exception {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (NodeRef nr : CommentsTest.this.testDocs) {
                    CommentsTest.this.assertCommentCountIs(nr, 0);
                }
                HashMap mapDiscussableToComments = new HashMap();
                for (NodeRef nodeRef : CommentsTest.this.testDocs) {
                    ArrayList<NodeRef> comments = new ArrayList<NodeRef>();
                    mapDiscussableToComments.put(nodeRef, comments);
                    comments.add(CommentsTest.this.applyComment(nodeRef, "Test comment 1 " + System.currentTimeMillis()));
                    Thread.sleep(50L);
                    comments.add(CommentsTest.this.applyComment(nodeRef, "Test comment 2 " + System.currentTimeMillis()));
                    Thread.sleep(50L);
                }
                for (NodeRef nodeRef : CommentsTest.this.testDocs) {
                    CommentsTest.this.assertCommentCountIs(nodeRef, 2);
                }
                for (Map.Entry entry : mapDiscussableToComments.entrySet()) {
                    for (NodeRef commentNode : (List)entry.getValue()) {
                        nodeService.deleteNode(commentNode);
                    }
                }
                for (NodeRef nodeRef : CommentsTest.this.testDocs) {
                    CommentsTest.this.assertCommentCountIs(nodeRef, 0);
                }
                return null;
            }
        });
    }

    @Test
    public void testRollupOfPreSwiftNodes() throws Exception {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((String)"Not enough test docs for this test case", (CommentsTest.this.testDocs.size() >= 2 ? 1 : 0) != 0);
                NodeRef node1 = (NodeRef)CommentsTest.this.testDocs.get(0);
                NodeRef node2 = (NodeRef)CommentsTest.this.testDocs.get(1);
                behaviourFilter.disableBehaviour(ForumModel.TYPE_POST);
                for (NodeRef nr : new NodeRef[]{node1, node2}) {
                    Assert.assertFalse((String)"Test node had comments rollup aspect.", (boolean)nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP));
                }
                NodeRef commentOnNode1 = CommentsTest.this.applyComment(node1, "Hello", true);
                CommentsTest.this.applyComment(node1, "Bonjour", true);
                CommentsTest.this.applyComment(node2, "Hola", true);
                CommentsTest.this.applyComment(node2, "Bout ye?", true);
                for (NodeRef nr : new NodeRef[]{node1, node2}) {
                    Assert.assertFalse((String)"Test node had comments rollup aspect.", (boolean)nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP));
                }
                behaviourFilter.enableBehaviour(ForumModel.TYPE_POST);
                CommentsTest.this.applyComment(node2, "hello again");
                nodeService.deleteNode(commentOnNode1);
                CommentsTest.this.assertCommentCountIs(node2, 3);
                CommentsTest.this.assertCommentCountIs(node1, 1);
                return null;
            }
        });
    }

    @Test
    public void testTriggerCommentRecount() throws Exception {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef testDoc = (NodeRef)CommentsTest.this.testDocs.get(0);
                CommentsTest.this.applyComment(testDoc, "Hello 1");
                CommentsTest.this.applyComment(testDoc, "Hello 2");
                CommentsTest.this.applyComment(testDoc, "Hello 3");
                CommentsTest.this.assertCommentCountIs(testDoc, 3);
                nodeService.setProperty(testDoc, ForumModel.PROP_COMMENT_COUNT, (Serializable)Integer.valueOf(42));
                CommentsTest.this.assertCommentCountIs(testDoc, 42);
                nodeService.setProperty(testDoc, ForumModel.PROP_COMMENT_COUNT, (Serializable)Integer.valueOf(-1));
                CommentsTest.this.assertCommentCountIs(testDoc, 3);
                return null;
            }
        });
    }

    private void assertCommentCountIs(NodeRef discussableNode, int expectedCount) {
        Serializable commentCount = nodeService.getProperty(discussableNode, ForumModel.PROP_COMMENT_COUNT);
        if (expectedCount == 0) {
            Assert.assertTrue((String)"Uncommented node should have EITHER no commentsRollup aspect OR commentCount of zero.", (!nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP) || commentCount != null && commentCount.equals(new Integer(0)) ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"Commented node should have discussable aspect.", (boolean)nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP));
            Assert.assertEquals((String)"Wrong comment count", (Object)expectedCount, (Object)commentCount);
        }
    }

    private NodeRef applyComment(NodeRef nr, String comment) {
        return this.applyComment(nr, comment, false);
    }

    private NodeRef applyComment(NodeRef nr, String comment, boolean suppressRollups) {
        if (!nodeService.hasAspect(nr, ForumModel.ASPECT_DISCUSSABLE)) {
            nodeService.addAspect(nr, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        if (!nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP) && !suppressRollups) {
            nodeService.addAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
        }
        NodeRef forumNode = ((ChildAssociationRef)nodeService.getChildAssocs(nr, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"));
        NodeRef topicNode = null;
        topicNode = existingTopics.isEmpty() ? nodeService.createNode(forumNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"), ForumModel.TYPE_TOPIC).getChildRef() : ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        NodeRef postNode = nodeService.createNode(topicNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)("comment" + System.currentTimeMillis())), ForumModel.TYPE_POST).getChildRef();
        nodeService.setProperty(postNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        ContentWriter writer = contentService.getWriter(postNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(comment);
        return postNode;
    }
}

