/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMimeMessage
extends MimeMessage {
    protected static final String DEFAULT_SUFFIX = "@alfresco.org";
    protected static int MAX_RETRIES = 1;
    private Log logger = LogFactory.getLog(AbstractMimeMessage.class);
    protected boolean generateBody = true;
    protected ServiceRegistry serviceRegistry;
    protected ImapService imapService;
    protected FileInfo messageFileInfo;
    protected MimeMessage wrappedMessage;
    protected boolean isMessageInSitesLibrary;

    protected AbstractMimeMessage(Session session) {
        super(session);
    }

    protected AbstractMimeMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry, boolean generateBody) throws MessagingException {
        super(Session.getDefaultInstance((Properties)new Properties()));
        this.generateBody = generateBody;
        this.buildMessage(fileInfo, serviceRegistry);
    }

    protected void buildMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry) throws MessagingException {
        this.checkParameter(serviceRegistry, "ServiceRegistry");
        this.content = null;
        this.serviceRegistry = serviceRegistry;
        this.imapService = serviceRegistry.getImapService();
        this.messageFileInfo = fileInfo;
        this.isMessageInSitesLibrary = this.imapService.isNodeInSitesLibrary(this.messageFileInfo.getNodeRef());
        RetryingTransactionHelper txHelper = serviceRegistry.getTransactionService().getRetryingTransactionHelper();
        txHelper.setMaxRetries(MAX_RETRIES);
        txHelper.setReadOnly(false);
        txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                AbstractMimeMessage.this.buildMessageInternal();
                return null;
            }
        }, false);
    }

    public abstract void buildMessageInternal() throws MessagingException;

    protected void checkParameter(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " parameter is null.");
        }
    }

    protected void setMessageHeaders() throws MessagingException {
        this.setHeader("MIME-Version", "1.0");
        this.setHeader("X-Alfresco-NodeRef-ID", this.messageFileInfo.getNodeRef().getId());
    }

    public FileInfo getMessageInfo() {
        return this.messageFileInfo;
    }

    public Flags getFlags() {
        return this.imapService.getFlags(this.messageFileInfo);
    }

    public void setFlags(Flags flags, boolean value) throws MessagingException {
        this.imapService.setFlags(this.messageFileInfo, flags, value);
    }

    public String getEmailBodyText(ImapService.EmailBodyFormat type) {
        return this.serviceRegistry.getTemplateService().processTemplate(this.imapService.getDefaultEmailBodyTemplate(type), this.createEmailTemplateModel(this.messageFileInfo.getNodeRef()));
    }

    private Map<String, Object> createEmailTemplateModel(NodeRef ref) {
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        TemplateNode tn = new TemplateNode(ref, this.serviceRegistry, null);
        model.put("document", tn);
        NodeRef parent = this.serviceRegistry.getNodeService().getPrimaryParent(ref).getParentRef();
        model.put("space", new TemplateNode(parent, this.serviceRegistry, null));
        model.put("date", new Date());
        model.put("contextUrl", new String(this.imapService.getWebApplicationContextUrl()));
        model.put("alfTicket", new String(this.serviceRegistry.getAuthenticationService().getCurrentTicket()));
        if (this.isMessageInSitesLibrary) {
            String pathFromSites = this.getPathFromSites(parent);
            StringBuilder parsedPath = new StringBuilder();
            String[] pathParts = pathFromSites.split("/");
            if (pathParts.length > 2) {
                parsedPath.append(pathParts[0]).append("/").append(pathParts[1]);
                parsedPath.append("?filter=path|");
                for (int i = 2; i < pathParts.length; ++i) {
                    parsedPath.append("/").append(pathParts[i]);
                }
            } else {
                parsedPath.append(pathFromSites);
            }
            model.put("shareContextUrl", new String(this.imapService.getShareApplicationContextUrl()));
            model.put("parentPathFromSites", parsedPath.toString());
        }
        return model;
    }

    private String getPathFromSites(NodeRef ref) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        String name = ((String)((Object)nodeService.getProperty(ref, ContentModel.PROP_NAME))).toLowerCase();
        if (nodeService.getType(ref).equals((Object)SiteModel.TYPE_SITE)) {
            return name;
        }
        NodeRef parent = nodeService.getPrimaryParent(ref).getParentRef();
        return this.getPathFromSites(parent) + "/" + name;
    }

    protected void updateMessageID() throws MessagingException {
        this.setHeader("Message-ID", "<" + this.messageFileInfo.getNodeRef().getId() + DEFAULT_SUFFIX + ">");
    }
}

