/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ACPImportPackageHandler
implements ImportPackageHandler {
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected File file;
    protected ZipFile zipFile;
    protected String dataFileEncoding;

    public ACPImportPackageHandler(File zipFile, String dataFileEncoding) {
        this.file = zipFile;
        this.dataFileEncoding = dataFileEncoding;
    }

    @Override
    public void startImport() {
        this.log("Importing from zip file " + this.file.getAbsolutePath());
        try {
            this.zipFile = new ZipFile(this.file, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            throw new ImporterException("Failed to read zip file due to " + e.getMessage(), e);
        }
    }

    @Override
    public Reader getDataStream() {
        try {
            ZipArchiveEntry xmlMetaDataEntry = null;
            Enumeration entries = this.zipFile.getEntries();
            while (entries.hasMoreElements()) {
                String entryName;
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".xml") || entryName.indexOf(47) != -1 || entryName.indexOf(92) != -1) continue;
                if (xmlMetaDataEntry != null) {
                    throw new ImporterException("Failed to find unique xml meta-data file within .acp package - multiple xml meta-data files exist.");
                }
                xmlMetaDataEntry = entry;
            }
            if (xmlMetaDataEntry == null) {
                throw new ImporterException("Failed to find xml meta-data file within .acp package");
            }
            InputStream dataStream = this.zipFile.getInputStream(xmlMetaDataEntry);
            InputStreamReader inputReader = this.dataFileEncoding == null ? new InputStreamReader(dataStream, DEFAULT_ENCODING) : new InputStreamReader(dataStream, this.dataFileEncoding);
            return new BufferedReader(inputReader);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImporterException("Encoding " + this.dataFileEncoding + " is not supported");
        }
        catch (IOException e) {
            throw new ImporterException("Failed to open xml meta-data file within .acp package due to " + e.getMessage());
        }
    }

    @Override
    public InputStream importStream(String content) {
        ZipArchiveEntry zipEntry = this.zipFile.getEntry(content);
        if (zipEntry == null && (zipEntry = this.zipFile.getEntry(content = content.replace('\\', '/'))) == null) {
            throw new ImporterException("Failed to find content " + content + " within zip package");
        }
        try {
            return this.zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new ImporterException("Failed to open content " + content + " within zip package due to " + e.getMessage(), e);
        }
    }

    @Override
    public void endImport() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                throw new ImporterException("Failed to close zip package " + this.file.getAbsolutePath(), e);
            }
        }
    }

    protected void log(String message) {
    }
}

