/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ExecuteScriptJob
implements Job {
    private static final String PARAM_SCRIPT_LOCATION = "scriptLocation";
    private static final String PARAM_SCRIPT_SERVICE = "scriptService";
    private static final String PARAM_AUTHENTICATION_COMPONENT = "authenticationComponent";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        Object scriptServiceObj = jobData.get((Object)PARAM_SCRIPT_SERVICE);
        if (scriptServiceObj == null || !(scriptServiceObj instanceof ScriptService)) {
            throw new AlfrescoRuntimeException("ExecuteScriptJob data must contain valid script service");
        }
        Object scriptLocationObj = jobData.get((Object)PARAM_SCRIPT_LOCATION);
        if (scriptLocationObj == null || !(scriptLocationObj instanceof ScriptLocation)) {
            throw new AlfrescoRuntimeException("ExecuteScriptJob data must contain valid script location");
        }
        Object authenticationComponentObj = jobData.get((Object)PARAM_AUTHENTICATION_COMPONENT);
        if (authenticationComponentObj == null || !(authenticationComponentObj instanceof AuthenticationComponent)) {
            throw new AlfrescoRuntimeException("ExecuteScriptJob data must contain valid authentication component");
        }
        ((AuthenticationComponent)authenticationComponentObj).setSystemUserAsCurrentUser();
        try {
            ((ScriptService)scriptServiceObj).executeScript((ScriptLocation)scriptLocationObj, null);
        }
        finally {
            ((AuthenticationComponent)authenticationComponentObj).clearCurrentSecurityContext();
        }
    }
}

