/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.person.PersonServiceImpl;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.tenant.TenantDomainMismatchException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.ValueDerivingMapFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public final class People
extends BaseScopableProcessorExtension
implements InitializingBean {
    private static Log logger = LogFactory.getLog(People.class);
    private ServiceRegistry services;
    private AuthorityDAO authorityDAO;
    private AuthorityService authorityService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private ContentUsageService contentUsageService;
    private TenantService tenantService;
    private UserNameGenerator usernameGenerator;
    private UserRegistrySynchronizer userRegistrySynchronizer;
    private StoreRef storeRef;
    private ValueDerivingMapFactory<ScriptNode, String, Boolean> valueDerivingMapFactory;
    private int numRetries = 10;
    private int defaultListMaxResults = 5000;
    private static final String HINT_CQ_SUFFIX = " [hint:useCQ]";

    public void afterPropertiesSet() throws Exception {
        HashMap<String, ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>> capabilityTesters = new HashMap<String, ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>>(5);
        capabilityTesters.put("isAdmin", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                return People.this.isAdmin(source);
            }
        });
        capabilityTesters.put("isGuest", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                return People.this.isGuest(source);
            }
        });
        capabilityTesters.put("isMutable", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                String sourceUser = (String)source.getProperties().get(ContentModel.PROP_USERNAME);
                if (!People.this.authenticationService.isAuthenticationMutable(sourceUser)) {
                    return false;
                }
                String currentUser = People.this.authenticationService.getCurrentUserName();
                if (currentUser.equals(sourceUser) || People.this.authorityService.isAdminAuthority(currentUser)) {
                    return true;
                }
                return false;
            }
        });
        this.valueDerivingMapFactory = new ValueDerivingMapFactory(capabilityTesters);
    }

    public void setStoreUrl(String storeRef) {
        if (this.storeRef != null) {
            throw new IllegalStateException("Default store URL can only be set once.");
        }
        this.storeRef = new StoreRef(storeRef);
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setUserNameGenerator(UserNameGenerator userNameGenerator) {
        this.usernameGenerator = userNameGenerator;
    }

    public void setUserRegistrySynchronizer(UserRegistrySynchronizer userRegistrySynchronizer) {
        this.userRegistrySynchronizer = userRegistrySynchronizer;
    }

    public void setDefaultListMaxResults(int defaultListMaxResults) {
        this.defaultListMaxResults = defaultListMaxResults;
    }

    public void deletePerson(String username) {
        this.personService.deletePerson(username);
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress, String password, boolean setAccountEnabled) {
        return this.createPerson(userName, firstName, lastName, emailAddress, password, setAccountEnabled, false);
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress, String password, boolean setAccountEnabled, boolean notifyByEmail) {
        ParameterCheck.mandatory((String)"firstName", (Object)firstName);
        ParameterCheck.mandatory((String)"emailAddress", (Object)emailAddress);
        ScriptNode person = null;
        if (userName == null) {
            for (int i = 0; i < this.numRetries && this.personService.personExists(userName = this.usernameGenerator.generateUserName(firstName, lastName, emailAddress, i)); ++i) {
            }
        }
        if (userName != null) {
            try {
                userName = PersonServiceImpl.updateUsernameForTenancy(userName, this.tenantService);
            }
            catch (TenantDomainMismatchException re) {
                throw new AuthenticationException("User must belong to same domain as admin: " + re.getTenantA());
            }
            person = this.createPerson(userName, firstName, lastName, emailAddress);
            if (person != null && password != null) {
                this.authenticationService.createAuthentication(userName, password.toCharArray());
                this.authenticationService.setAuthenticationEnabled(userName, setAccountEnabled);
                person.save();
                if (notifyByEmail) {
                    this.personService.notifyPerson(userName, password);
                }
            }
        }
        return person;
    }

    public void enableAccount(String userName) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.authenticationService.setAuthenticationEnabled(userName, true);
        }
    }

    public void disableAccount(String userName) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.authenticationService.setAuthenticationEnabled(userName, false);
        }
    }

    public boolean isAccountEnabled(String userName) {
        return this.authenticationService.getAuthenticationEnabled(userName);
    }

    public void changePassword(String oldPassword, String newPassword) {
        ParameterCheck.mandatoryString((String)"oldPassword", (String)oldPassword);
        ParameterCheck.mandatoryString((String)"newPassword", (String)newPassword);
        this.services.getAuthenticationService().updateAuthentication(AuthenticationUtil.getFullyAuthenticatedUser(), oldPassword.toCharArray(), newPassword.toCharArray());
    }

    public void setPassword(String userName, String password) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ParameterCheck.mandatoryString((String)"password", (String)password);
        MutableAuthenticationService authService = this.services.getAuthenticationService();
        if (this.authorityService.hasAdminAuthority() && !userName.equalsIgnoreCase(authService.getCurrentUserName())) {
            authService.setAuthentication(userName, password.toCharArray());
        }
    }

    public ScriptNode createPerson(String userName) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ScriptNode person = null;
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_USERNAME, userName);
        if (!this.personService.personExists(userName)) {
            NodeRef personRef = this.personService.createPerson(properties);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ParameterCheck.mandatoryString((String)"firstName", (String)firstName);
        ParameterCheck.mandatoryString((String)"emailAddress", (String)emailAddress);
        ScriptNode person = null;
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_USERNAME, userName);
        properties.put(ContentModel.PROP_FIRSTNAME, firstName);
        properties.put(ContentModel.PROP_LASTNAME, lastName);
        properties.put(ContentModel.PROP_EMAIL, emailAddress);
        if (!this.personService.personExists(userName)) {
            NodeRef personRef = this.personService.createPerson(properties);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public void setQuota(ScriptNode person, String quota) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.contentUsageService.setUserQuota((String)person.getProperties().get(ContentModel.PROP_USERNAME), Long.parseLong(quota));
        }
    }

    public Scriptable getPeople(String filter) {
        return this.getPeople(filter, 0);
    }

    public Scriptable getPeople(String filter, int maxResults) {
        Object[] people;
        block8: {
            boolean useCQ = false;
            if (filter != null && filter.endsWith(HINT_CQ_SUFFIX)) {
                useCQ = true;
                filter = filter.substring(0, filter.length() - HINT_CQ_SUFFIX.length());
            }
            people = null;
            if (maxResults <= 0 || maxResults > this.defaultListMaxResults) {
                maxResults = this.defaultListMaxResults;
            }
            if (filter == null || filter.length() == 0 || useCQ) {
                people = this.getPeopleImplDB(filter, maxResults);
            } else if ((filter = filter.trim()).length() != 0) {
                String term = filter.replace("\\", "").replace("\"", "");
                StringTokenizer t = new StringTokenizer(term, " ");
                int propIndex = term.lastIndexOf(58);
                int wildPosition = term.indexOf(42);
                useCQ = t.countTokens() == 1 && propIndex == -1 && (wildPosition == -1 || wildPosition == term.length() - 1);
                try {
                    people = this.getPeopleImplSearch(term, t, propIndex, maxResults);
                }
                catch (Throwable err) {
                    if (!useCQ) break block8;
                    people = this.getPeopleImplDB(term, maxResults);
                }
            }
        }
        if (people == null) {
            people = new Object[]{};
        }
        return Context.getCurrentContext().newArray(this.getScope(), people);
    }

    private Object[] getPeopleImplDB(String term, int maxResults) {
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object[] people = null;
        ArrayList<QName> filterProps = new ArrayList<QName>(3);
        filterProps.add(ContentModel.PROP_FIRSTNAME);
        filterProps.add(ContentModel.PROP_LASTNAME);
        filterProps.add(ContentModel.PROP_USERNAME);
        ArrayList<Pair<QName, Boolean>> sortProps = new ArrayList<Pair<QName, Boolean>>(1);
        sortProps.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        PagingRequest pagingRequest = new PagingRequest(maxResults, null);
        List persons = this.personService.getPeople(term, filterProps, sortProps, pagingRequest).getPage();
        people = new Object[persons.size()];
        for (int i = 0; i < people.length; ++i) {
            people[i] = ((PersonService.PersonInfo)persons.get(i)).getNodeRef();
        }
        if (start != null) {
            logger.debug((Object)("getPeople: cq - " + people.length + " items (in " + (System.currentTimeMillis() - start) + " msecs)"));
        }
        return people;
    }

    private Object[] getPeopleImplSearch(String term, StringTokenizer t, int propIndex, int maxResults) throws Throwable {
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object[] people = null;
        SearchParameters params = new SearchParameters();
        params.addQueryTemplate("_PERSON", "|%firstName OR |%lastName OR |%userName");
        params.setDefaultFieldName("_PERSON");
        StringBuilder query = new StringBuilder(256);
        query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\" AND (");
        if (t.countTokens() == 1) {
            query.append(term.substring(0, propIndex + 1)).append('\"').append(term.substring(propIndex + 1));
            if (propIndex > 0) {
                query.append('\"');
            } else {
                query.append("*\"");
            }
        } else {
            int nonFtsTokens = 0;
            while (t.hasMoreTokens()) {
                if (t.nextToken().indexOf(58) != -1) continue;
                ++nonFtsTokens;
            }
            t = new StringTokenizer(term, " ");
            params.setDefaultOperator(SearchParameters.Operator.AND);
            boolean firstToken = true;
            boolean tokenSurname = false;
            boolean propertySearch = false;
            while (t.hasMoreTokens()) {
                term = t.nextToken();
                if (!propertySearch && term.indexOf(58) == -1) {
                    if (nonFtsTokens == 1) {
                        query.append("_PERSON:\"");
                        query.append(term);
                        query.append("*\" ");
                        continue;
                    }
                    if (firstToken) {
                        query.append("firstName:\"");
                        query.append(term);
                        query.append("*\" ");
                        firstToken = false;
                        continue;
                    }
                    if (tokenSurname) {
                        query.append("OR ");
                    }
                    query.append("lastName:\"");
                    query.append(term);
                    query.append("*\" ");
                    tokenSurname = true;
                    continue;
                }
                propIndex = term.lastIndexOf(58);
                query.append(term.substring(0, propIndex + 1)).append('\"').append(term.substring(propIndex + 1)).append('\"');
                propertySearch = true;
            }
        }
        query.append(")");
        params.setLanguage("fts-alfresco");
        params.addStore(this.storeRef);
        params.setQuery(query.toString());
        if (maxResults > 0) {
            params.setLimitBy(LimitBy.FINAL_SIZE);
            params.setLimit(maxResults);
        }
        ResultSet results = null;
        try {
            results = this.services.getSearchService().query(params);
            people = results.getNodeRefs().toArray();
            if (start != null) {
                logger.debug((Object)("getPeople: search - " + people.length + " items (in " + (System.currentTimeMillis() - start) + " msecs)"));
            }
        }
        catch (Throwable err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to execute people search: " + query.toString()), err);
            }
            throw err;
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return people;
    }

    public ScriptNode getPerson(String username) {
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        ScriptNode person = null;
        if (this.personService.personExists(username)) {
            NodeRef personRef = this.personService.getPerson(username);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public ScriptNode getGroup(String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        ScriptNode group = null;
        NodeRef groupRef = this.authorityDAO.getAuthorityNodeRefOrNull(groupName);
        if (groupRef != null) {
            group = new ScriptNode(groupRef, this.services, this.getScope());
        }
        return group;
    }

    public void deleteGroup(ScriptNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        if (group.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)group.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            this.authorityService.deleteAuthority(groupName);
        }
    }

    public ScriptNode createGroup(String groupName) {
        return this.createGroup(null, groupName);
    }

    public ScriptNode createGroup(ScriptNode parentGroup, String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        ScriptNode group = null;
        String actualName = this.services.getAuthorityService().getName(AuthorityType.GROUP, groupName);
        if (!this.authorityService.authorityExists(actualName)) {
            String parentGroupName;
            String result = this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
            if (parentGroup != null && (parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME)) != null) {
                this.authorityService.addAuthority(parentGroupName, actualName);
            }
            group = this.getGroup(result);
        }
        return group;
    }

    public void addAuthority(ScriptNode parentGroup, ScriptNode authority) {
        ParameterCheck.mandatory((String)"Authority", (Object)authority);
        ParameterCheck.mandatory((String)"ParentGroup", (Object)parentGroup);
        if (parentGroup.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            String authorityName = authority.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER) ? (String)authority.getProperties().get(ContentModel.PROP_AUTHORITY_NAME) : (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
            this.authorityService.addAuthority(parentGroupName, authorityName);
        }
    }

    public void removeAuthority(ScriptNode parentGroup, ScriptNode authority) {
        ParameterCheck.mandatory((String)"Authority", (Object)authority);
        ParameterCheck.mandatory((String)"ParentGroup", (Object)parentGroup);
        if (parentGroup.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            String authorityName = authority.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER) ? (String)authority.getProperties().get(ContentModel.PROP_AUTHORITY_NAME) : (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
            this.authorityService.removeAuthority(parentGroupName, authorityName);
        }
    }

    public Scriptable getMembers(ScriptNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        Object[] members = this.getContainedAuthorities(group, AuthorityType.USER, true);
        return Context.getCurrentContext().newArray(this.getScope(), members);
    }

    public Scriptable getMembers(ScriptNode group, boolean recurse) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        Object[] members = this.getContainedAuthorities(group, AuthorityType.USER, recurse);
        return Context.getCurrentContext().newArray(this.getScope(), members);
    }

    public Scriptable getContainerGroups(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        Object[] parents = null;
        Set<String> authorities = this.authorityService.getContainingAuthoritiesInZone(AuthorityType.GROUP, (String)person.getProperties().get(ContentModel.PROP_USERNAME), "APP.DEFAULT", null, 1000);
        parents = new Object[authorities.size()];
        int i = 0;
        for (String authority : authorities) {
            ScriptNode group = this.getGroup(authority);
            if (group == null) continue;
            parents[i++] = group;
        }
        return Context.getCurrentContext().newArray(this.getScope(), parents);
    }

    public boolean isAdmin(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isAdminAuthority((String)person.getProperties().get(ContentModel.PROP_USERNAME));
    }

    public boolean isGuest(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isGuestAuthority((String)person.getProperties().get(ContentModel.PROP_USERNAME));
    }

    public Map<String, Boolean> getCapabilities(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        ScriptableHashMap<String, Boolean> retVal = new ScriptableHashMap<String, Boolean>();
        retVal.putAll(this.valueDerivingMapFactory.getMap(person));
        return retVal;
    }

    public ScriptableHashMap getImmutableProperties(String username) {
        Set<QName> props = this.userRegistrySynchronizer.getPersonMappedProperties(username);
        ScriptableHashMap<String, Boolean> propMap = new ScriptableHashMap<String, Boolean>();
        for (QName prop : props) {
            propMap.put(prop.toString(), Boolean.TRUE);
        }
        return propMap;
    }

    private Object[] getContainedAuthorities(ScriptNode container, AuthorityType type, boolean recurse) {
        Object[] members = null;
        if (container.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)container.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            Set<String> authorities = this.authorityService.getContainedAuthorities(type, groupName, !recurse);
            members = new Object[authorities.size()];
            int i = 0;
            for (String authority : authorities) {
                ScriptNode person;
                AuthorityType authorityType = AuthorityType.getAuthorityType((String)authority);
                if (authorityType.equals((Object)AuthorityType.GROUP)) {
                    ScriptNode group = this.getGroup(authority);
                    if (group == null) continue;
                    members[i++] = group;
                    continue;
                }
                if (!authorityType.equals((Object)AuthorityType.USER) || (person = this.getPerson(authority)) == null) continue;
                members[i++] = person;
            }
        }
        return members != null ? members : new Object[]{};
    }
}

