/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.alfresco.repo.googledocs.GoogleDocsService;
import org.alfresco.repo.jscript.app.CustomResponse;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class GoogleDocsCustomResponse
implements CustomResponse,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(GoogleDocsCustomResponse.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Serializable populate() {
        try {
            ApplicationContextFactory subsystem = (ApplicationContextFactory)this.applicationContext.getBean("googledocs");
            ConfigurableApplicationContext childContext = (ConfigurableApplicationContext)subsystem.getApplicationContext();
            GoogleDocsService googleDocsService = (GoogleDocsService)childContext.getBean("googleDocsService");
            LinkedHashMap<String, Boolean> jsonObj = new LinkedHashMap<String, Boolean>(4);
            jsonObj.put("enabled", googleDocsService.isEnabled());
            return jsonObj;
        }
        catch (Exception e) {
            logger.warn((Object)"Could not add custom Google Docs status response to DocLib webscript");
            return null;
        }
    }
}

