/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.app.BasePropertyDecorator;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class UsernamePropertyDecorator
extends BasePropertyDecorator {
    private PersonService personService = null;

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public JSONAware decorate(QName propertyName, NodeRef nodeRef, Serializable value) {
        String username = value.toString();
        String firstName = null;
        String lastName = null;
        JSONObject map = new JSONObject();
        map.put((Object)"userName", (Object)username);
        if (this.personService.personExists(username)) {
            NodeRef personRef = this.personService.getPerson(username);
            Map properties = this.nodeService.getProperties(personRef);
            firstName = (String)properties.get(ContentModel.PROP_FIRSTNAME);
            lastName = (String)properties.get(ContentModel.PROP_LASTNAME);
        } else if (username.equals("System") || username.startsWith("System@")) {
            firstName = "System";
            lastName = "User";
        } else {
            map.put((Object)"isDeleted", (Object)true);
            return map;
        }
        map.put((Object)"firstName", (Object)firstName);
        map.put((Object)"lastName", (Object)lastName);
        map.put((Object)"displayName", (Object)((firstName != null ? firstName + " " : "") + (lastName != null ? lastName : "")).replaceAll("^\\s+|\\s+$", ""));
        return map;
    }
}

