/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;

public class LockServiceImpl
implements LockService,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.BeforeUpdateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.OnCopyNodePolicy,
VersionServicePolicies.BeforeCreateVersionPolicy,
VersionServicePolicies.OnCreateVersionPolicy {
    private static final String KEY_IGNORE_NODES = "lockService.ignoreNodes";
    private NodeService nodeService;
    private TenantService tenantService;
    private AuthenticationService authenticationService;
    private SearchService searchService;
    private BehaviourFilter behaviourFilter;
    private PolicyComponent policyComponent;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeUpdateNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeUpdateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeCreateVersion"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnCreateVersionPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateVersion"));
    }

    private void addToIgnoreSet(NodeRef nodeRef) {
        HashSet<NodeRef> ignoreNodeRefs = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_IGNORE_NODES);
        if (ignoreNodeRefs == null) {
            ignoreNodeRefs = new HashSet<NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_IGNORE_NODES, ignoreNodeRefs);
        }
        ignoreNodeRefs.add(nodeRef);
    }

    private void removeFromIgnoreSet(NodeRef nodeRef) {
        Set ignoreNodeRefs = (Set)AlfrescoTransactionSupport.getResource(KEY_IGNORE_NODES);
        if (ignoreNodeRefs != null) {
            ignoreNodeRefs.remove(nodeRef);
        }
    }

    private boolean ignore(NodeRef nodeRef) {
        Set ignoreNodeRefs = (Set)AlfrescoTransactionSupport.getResource(KEY_IGNORE_NODES);
        if (ignoreNodeRefs != null) {
            return ignoreNodeRefs.contains(nodeRef);
        }
        return false;
    }

    @Override
    public void lock(NodeRef nodeRef, LockType lockType) {
        this.lock(nodeRef, lockType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire) {
        LockStatus currentLockStatus;
        nodeRef = this.tenantService.getName(nodeRef);
        this.checkForLockApsect(nodeRef);
        String userName = this.getUserName();
        if (lockType == null) {
            lockType = LockType.WRITE_LOCK;
        }
        if (LockStatus.LOCKED.equals((Object)(currentLockStatus = this.getLockStatus(nodeRef, userName)))) {
            throw new UnableToAquireLockException(nodeRef);
        }
        if (LockStatus.NO_LOCK.equals((Object)currentLockStatus) || LockStatus.LOCK_EXPIRED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus)) {
            this.addToIgnoreSet(nodeRef);
            try {
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_OWNER, (Serializable)((Object)userName));
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_TYPE, (Serializable)((Object)lockType.toString()));
                this.setExpiryDate(nodeRef, timeToExpire);
            }
            finally {
                this.removeFromIgnoreSet(nodeRef);
            }
        }
    }

    private void setExpiryDate(NodeRef nodeRef, int timeToExpire) {
        Date expiryDate = null;
        if (timeToExpire > 0) {
            expiryDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expiryDate);
            calendar.add(13, timeToExpire);
            expiryDate = calendar.getTime();
        }
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE, (Serializable)expiryDate);
    }

    @Override
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, boolean lockChildren) throws UnableToAquireLockException {
        this.lock(nodeRef, lockType, timeToExpire);
        if (lockChildren) {
            List childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                this.lock(childAssocRef.getChildRef(), lockType, timeToExpire, lockChildren);
            }
        }
    }

    @Override
    public void lock(Collection<NodeRef> nodeRefs, LockType lockType, int timeToExpire) throws UnableToAquireLockException {
        for (NodeRef nodeRef : nodeRefs) {
            this.lock(nodeRef, lockType, timeToExpire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(NodeRef nodeRef) throws UnableToReleaseLockException {
        if (this.nodeService.hasAspect(nodeRef = this.tenantService.getName(nodeRef), ContentModel.ASPECT_LOCKABLE)) {
            this.checkForLockApsect(nodeRef);
            this.addToIgnoreSet(nodeRef);
            try {
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
            }
            finally {
                this.removeFromIgnoreSet(nodeRef);
            }
        }
    }

    @Override
    public void unlock(NodeRef nodeRef, boolean unlockChildren) throws UnableToReleaseLockException {
        this.unlock(nodeRef);
        if (unlockChildren) {
            List childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                this.unlock(childAssocRef.getChildRef(), unlockChildren);
            }
        }
    }

    @Override
    public void unlock(Collection<NodeRef> nodeRefs) throws UnableToReleaseLockException {
        for (NodeRef nodeRef : nodeRefs) {
            this.unlock(nodeRef);
        }
    }

    @Override
    public LockStatus getLockStatus(NodeRef nodeRef) {
        nodeRef = this.tenantService.getName(nodeRef);
        return this.getLockStatus(nodeRef, this.getUserName());
    }

    @Override
    public LockStatus getLockStatus(NodeRef nodeRef, String userName) {
        String currentUserRef;
        LockStatus result = LockStatus.NO_LOCK;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (currentUserRef = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER))) != null) {
            Date expiryDate = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE);
            result = expiryDate != null && expiryDate.before(new Date()) ? LockStatus.LOCK_EXPIRED : (currentUserRef.equals(userName) ? LockStatus.LOCK_OWNER : LockStatus.LOCKED);
        }
        return result;
    }

    @Override
    public LockType getLockType(NodeRef nodeRef) {
        String lockTypeString;
        LockType result = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeString = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
            result = LockType.valueOf(lockTypeString);
        }
        return result;
    }

    private void checkForLockApsect(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
    }

    @Override
    public void checkForLock(NodeRef nodeRef) throws NodeLockedException {
        String userName = this.getUserName();
        if ((nodeRef = this.tenantService.getName(nodeRef)) != null && userName != null) {
            String effectiveUserName = AuthenticationUtil.getRunAsUser();
            if (!this.ignore(nodeRef) && !this.tenantService.getBaseNameUser(effectiveUserName).equals(AuthenticationUtil.getSystemUserName())) {
                try {
                    LockStatus currentLockStatus = this.getLockStatus(nodeRef, userName);
                    LockType lockType = this.getLockType(nodeRef);
                    if (LockType.WRITE_LOCK.equals((Object)lockType) && LockStatus.LOCKED.equals((Object)currentLockStatus)) {
                        throw new NodeLockedException(nodeRef);
                    }
                    if (LockType.READ_ONLY_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                        throw new NodeLockedException(nodeRef);
                    }
                    if (LockType.NODE_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                        throw new NodeLockedException(nodeRef);
                    }
                }
                catch (AspectMissingException exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        LockType lockType = this.getLockType(childAssocRef.getParentRef());
        if (lockType != null) {
            switch (lockType) {
                case WRITE_LOCK: 
                case READ_ONLY_LOCK: {
                    this.checkForLock(childAssocRef.getParentRef());
                    break;
                }
            }
        }
    }

    @Override
    public void beforeUpdateNode(NodeRef nodeRef) {
        this.checkForLock(nodeRef);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.checkForLock(nodeRef);
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return LockableAspectCopyBehaviourCallback.INSTANCE;
    }

    @Override
    public void beforeCreateVersion(NodeRef versionableNode) {
        this.checkForLock(versionableNode);
    }

    @Override
    public void onCreateVersion(QName classRef, NodeRef versionableNode, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        nodeDetails.addAspect(ContentModel.ASPECT_LOCKABLE);
    }

    private String getUserName() {
        return this.authenticationService.getCurrentUserName();
    }

    @Override
    public List<NodeRef> getLocks(StoreRef storeRef) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeRef> getLocks(StoreRef storeRef, String query) {
        ArrayList<NodeRef> result = new ArrayList();
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(storeRef, "lucene", query);
            result = resultSet.getNodeRefs();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return result;
    }

    @Override
    public List<NodeRef> getLocks(StoreRef storeRef, LockType lockType) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"" + " +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_TYPE.getLocalName() + ":\"" + lockType.toString() + "\"");
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef nodeRef = oldChildAssocRef.getChildRef();
        this.checkForLock(nodeRef);
    }

    @Override
    public void suspendLocks() {
        this.getBehaviourFilter().disableBehaviour(ContentModel.ASPECT_LOCKABLE);
    }

    @Override
    public void enableLocks() {
        this.getBehaviourFilter().enableBehaviour(ContentModel.ASPECT_LOCKABLE);
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    private static class LockableAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new LockableAspectCopyBehaviourCallback();

        private LockableAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }
    }
}

