/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;

public class LockUtils {
    public static boolean isLockedAndReadOnly(NodeRef nodeRef, LockService lockService) {
        LockStatus lockStatus = lockService.getLockStatus(nodeRef);
        switch (lockStatus) {
            case NO_LOCK: 
            case LOCK_EXPIRED: {
                return false;
            }
            case LOCK_OWNER: {
                return lockService.getLockType(nodeRef) != LockType.WRITE_LOCK;
            }
        }
        return true;
    }
}

