/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class ChainingSubsystemProxyFactory
extends ProxyFactoryBean {
    private static final long serialVersionUID = -2646392556551369220L;
    private ChildApplicationContextManager applicationContextManager;
    private String sourceBeanName;
    private Object defaultTarget;

    public ChainingSubsystemProxyFactory() {
        this.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation mi) throws Throwable {
                Method method = mi.getMethod();
                try {
                    for (String instance : ChainingSubsystemProxyFactory.this.applicationContextManager.getInstanceIds()) {
                        if (ChainingSubsystemProxyFactory.this.sourceBeanName == null) {
                            Map beans = ChainingSubsystemProxyFactory.this.applicationContextManager.getApplicationContext(instance).getBeansOfType(method.getDeclaringClass());
                            Object activeBean = null;
                            for (Object bean : beans.values()) {
                                if (bean instanceof ActivateableBean && !((ActivateableBean)bean).isActive()) continue;
                                if (activeBean == null) {
                                    activeBean = bean;
                                    continue;
                                }
                                throw new RuntimeException("Don't know where to route call to method " + method + ": multiple active beans in context " + instance);
                            }
                            if (activeBean == null) continue;
                            return method.invoke(activeBean, mi.getArguments());
                        }
                        try {
                            Object bean = ChainingSubsystemProxyFactory.this.applicationContextManager.getApplicationContext(instance).getBean(ChainingSubsystemProxyFactory.this.sourceBeanName);
                            if (bean instanceof ActivateableBean && !((ActivateableBean)bean).isActive()) continue;
                            return method.invoke(bean, mi.getArguments());
                        }
                        catch (NoSuchBeanDefinitionException e) {
                        }
                    }
                    if (ChainingSubsystemProxyFactory.this.defaultTarget != null && method.getDeclaringClass().isAssignableFrom(ChainingSubsystemProxyFactory.this.defaultTarget.getClass())) {
                        return method.invoke(ChainingSubsystemProxyFactory.this.defaultTarget, mi.getArguments());
                    }
                    if (method.equals(ActivateableBean.class.getMethod("isActive", new Class[0]))) {
                        return Boolean.FALSE;
                    }
                    throw new RuntimeException("Don't know where to route call to method " + method);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        }));
    }

    public void setInterfaces(Class[] interfaces) {
        super.setInterfaces(interfaces);
        this.setTargetClass(this.getObjectType());
    }

    public void setApplicationContextManager(ChildApplicationContextManager applicationContextManager) {
        this.applicationContextManager = applicationContextManager;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    public void setDefaultTarget(Object defaultTarget) {
        this.defaultTarget = defaultTarget;
    }
}

