/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ArgumentHelper;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class FileFolderPerformanceTester
extends TestCase {
    private static Log logger = LogFactory.getLog(FileFolderPerformanceTester.class);
    protected static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private NodeRef rootFolderRef;
    private File dataFile;
    private String USERNAME = AuthenticationUtil.getAdminUserName();

    protected NodeService getNodeService() {
        return (NodeService)ctx.getBean("NodeService");
    }

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.searchService = serviceRegistry.getSearchService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.nodeService = this.getNodeService();
        this.authenticate(this.USERNAME);
        this.rootFolderRef = this.getOrCreateRootFolder();
        this.dataFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
    }

    private void authenticate(String userName) {
        if (AuthenticationUtil.getSystemUserName().equals(userName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
        } else {
            this.authenticationComponent.setCurrentUser(userName);
        }
    }

    public void testSetUp() throws Exception {
        FileFolderPerformanceTester.assertNotNull((Object)this.dataFile);
    }

    protected NodeRef getOrCreateRootFolder() {
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List results = this.searchService.selectNodes(storeRootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)this.namespaceService, false, "xpath");
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Didn't find Company Home");
        }
        NodeRef companyHomeNodeRef = (NodeRef)results.get(0);
        return this.fileFolderService.create(companyHomeNodeRef, this.getName() + "_" + System.currentTimeMillis(), ContentModel.TYPE_FOLDER).getNodeRef();
    }

    private void buildStructure(final NodeRef parentNodeRef, int threadCount, final boolean randomOrder, final int folderCount, final int batchCount, final int filesPerBatch, final double[] dumpPoints) {
        int i;
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]> createFoldersCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]>(){

            @Override
            public NodeRef[] execute() throws Exception {
                NodeRef[] folders = new NodeRef[folderCount];
                for (int i = 0; i < folderCount; ++i) {
                    FileInfo folderInfo = FileFolderPerformanceTester.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                    folders[i] = folderInfo.getNodeRef();
                }
                return folders;
            }
        };
        final NodeRef[] folders = this.retryingTransactionHelper.doInTransaction(createFoldersCallback);
        Runnable runnable = new Runnable(){
            private long start;

            @Override
            public void run() {
                FileFolderPerformanceTester.this.authenticate(FileFolderPerformanceTester.this.USERNAME);
                this.start = System.currentTimeMillis();
                int nextDumpNumber = 0;
                for (int i = 0; i < batchCount; ++i) {
                    double nextDumpCount;
                    double completedCount = i;
                    double d = nextDumpCount = dumpPoints == null || dumpPoints.length == 0 || nextDumpNumber >= dumpPoints.length ? -1.0 : (double)batchCount * dumpPoints[nextDumpNumber];
                    if (nextDumpCount - 0.5 < completedCount && completedCount < nextDumpCount + 0.5) {
                        this.dumpResults(i);
                        ++nextDumpNumber;
                    }
                    List<NodeRef> foldersList = Arrays.asList(folders);
                    if (randomOrder) {
                        Collections.shuffle(foldersList);
                    }
                    for (int j = 0; j < folders.length; ++j) {
                        final NodeRef folderRef = folders[j];
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            @Override
                            public Void execute() throws Exception {
                                for (int i = 0; i < filesPerBatch; ++i) {
                                    FileInfo fileInfo = FileFolderPerformanceTester.this.fileFolderService.create(folderRef, GUID.generate(), ContentModel.TYPE_CONTENT);
                                    NodeRef nodeRef = fileInfo.getNodeRef();
                                    ContentWriter writer = FileFolderPerformanceTester.this.fileFolderService.getWriter(nodeRef);
                                    writer.setEncoding("UTF-8");
                                    writer.setMimetype("text/plain");
                                    writer.putContent(FileFolderPerformanceTester.this.dataFile);
                                }
                                return null;
                            }
                        };
                        FileFolderPerformanceTester.this.retryingTransactionHelper.doInTransaction(createFileCallback);
                    }
                }
                this.dumpResults(batchCount);
            }

            private void dumpResults(int currentBatchCount) {
                long end = System.currentTimeMillis();
                long time = end - this.start;
                double average = (double)time / (double)(folderCount * currentBatchCount * filesPerBatch);
                double percentComplete = (double)currentBatchCount / (double)batchCount * 100.0;
                if (percentComplete > 0.0) {
                    logger.debug((Object)("\n[" + Thread.currentThread().getName() + "] \n" + "   Created " + currentBatchCount * filesPerBatch + " files in each of " + folderCount + " folders (" + (randomOrder ? "shuffled" : "in order") + "): \n" + "   Progress: " + String.format("%9.2f", percentComplete) + " percent complete \n" + "   Average: " + String.format("%10.2f", average) + " ms per file \n" + "   Average: " + String.format("%10.2f", 1000.0 / average) + " files per second"));
                }
            }
        };
        logger.debug((Object)("\nStarting " + threadCount + " threads loading " + batchCount * filesPerBatch + " files in each of " + folderCount + " folders (" + (randomOrder ? "shuffled" : "in order") + (filesPerBatch > 1 ? " and " + filesPerBatch + " files per txn" : "") + ")."));
        ThreadGroup threadGroup = new ThreadGroup(this.getName());
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(threadGroup, runnable, String.format("FileLoader-%02d", i));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private void readStructure(NodeRef parentNodeRef, int threadCount, final int repetitions, double[] dumpPoints) {
        int i;
        final List<FileInfo> children = this.fileFolderService.list(parentNodeRef);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileFolderPerformanceTester.this.authenticate(FileFolderPerformanceTester.this.USERNAME);
                for (int i = 0; i < repetitions; ++i) {
                    for (final FileInfo fileInfo : children) {
                        final NodeRef folderRef = fileInfo.getNodeRef();
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Exception {
                                List<FileInfo> tmp = null;
                                if (!fileInfo.isFolder()) {
                                    throw new AlfrescoRuntimeException("Not a folder: " + folderRef);
                                }
                                long start = System.currentTimeMillis();
                                tmp = FileFolderPerformanceTester.this.fileFolderService.list(folderRef);
                                logger.debug((Object)("List " + tmp.size() + " items in " + (System.currentTimeMillis() - start) + " msecs"));
                                return null;
                            }
                        };
                        FileFolderPerformanceTester.this.retryingTransactionHelper.doInTransaction(readCallback, true);
                    }
                }
            }
        };
        logger.debug((Object)("\nStarting " + threadCount + " threads reading properties and children of " + children.size() + " folders " + repetitions + " times."));
        long start = System.currentTimeMillis();
        ThreadGroup threadGroup = new ThreadGroup(this.getName());
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(threadGroup, runnable, String.format("FileReader-%02d", i));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        logger.debug((Object)("\nFinished reading in " + (System.currentTimeMillis() - start) + " msecs"));
    }

    public void test_4_ordered_3_2_100() throws Exception {
        this.buildStructure(this.rootFolderRef, 4, false, 3, 2, 100, new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        System.out.println("rootFolderRef: " + this.rootFolderRef);
        this.readStructure(this.rootFolderRef, 4, 5, new double[]{0.25, 0.5, 0.75});
    }

    public void test_4_shuffled_3_2_100() throws Exception {
        this.buildStructure(this.rootFolderRef, 4, true, 3, 2, 100, new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        System.out.println("rootFolderRef: " + this.rootFolderRef);
        this.readStructure(this.rootFolderRef, 4, 5, new double[]{0.25, 0.5, 0.75});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
        try {
            FileFolderPerformanceTester.run((ApplicationContext)ctx, args);
        }
        catch (Throwable e) {
            System.out.println("Failed to run FileFolder performance test");
            e.printStackTrace();
        }
        finally {
            ctx.close();
        }
    }

    private static void run(final ApplicationContext ctx, String ... args) throws Throwable {
        int i;
        ArgumentHelper argHelper = new ArgumentHelper(FileFolderPerformanceTester.getUsage(), args);
        final int fileCount = argHelper.getIntegerValue("files", true, 1, 10000);
        String folderRefStr = argHelper.getStringValue("folder", false, true);
        int threadCount = argHelper.getIntegerValue("threads", false, 1, 100);
        final NodeRef selectedFolderNodeRef = folderRefStr == null ? null : new NodeRef(folderRefStr);
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        final MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
        final PermissionService permissionService = serviceRegistry.getPermissionService();
        final NodeService nodeService = serviceRegistry.getNodeService();
        final SearchService searchService = serviceRegistry.getSearchService();
        final TransactionService transactionService = serviceRegistry.getTransactionService();
        final FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
        AuthenticationUtil.RunAsWork<String> createUserRunAs = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                String user = GUID.generate();
                authenticationService.createAuthentication(user, user.toCharArray());
                return user;
            }
        };
        final String user = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createUserRunAs, (String)AuthenticationUtil.getSystemUserName());
        final RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NodeRef execute() throws Throwable {
                NodeRef folderNodeRef;
                block14: {
                    AuthenticationUtil.pushAuthentication();
                    DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
                    M2Model model = M2Model.createModel((String)"tempModel");
                    model.createNamespace("test", "t");
                    model.createNamespace("testx", "");
                    for (int m = 0; m < 30; ++m) {
                        model.createAspect("t:aspect_" + m);
                    }
                    dictionaryDao.putModel(model);
                    folderNodeRef = null;
                    try {
                        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                        if (selectedFolderNodeRef == null) {
                            StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
                            ResultSet rs = searchService.query(storeRef, "xpath", "/app:company_home");
                            try {
                                if (rs.length() == 0) {
                                    throw new AlfrescoRuntimeException("Didn't find Company Home");
                                }
                                NodeRef companyHomeNodeRef = rs.getNodeRef(0);
                                folderNodeRef = fileFolderService.create(companyHomeNodeRef, "TOP_FOLDER_" + System.currentTimeMillis(), ContentModel.TYPE_FOLDER).getNodeRef();
                                System.out.println("Created folder " + folderNodeRef + " with user " + user);
                            }
                            finally {
                                rs.close();
                            }
                            permissionService.setPermission(folderNodeRef, user, "All", true);
                            break block14;
                        }
                        folderNodeRef = selectedFolderNodeRef;
                        permissionService.setPermission(folderNodeRef, user, "All", true);
                        System.out.println("Reusing folder " + folderNodeRef + " with user " + user);
                    }
                    finally {
                        AuthenticationUtil.popAuthentication();
                    }
                }
                if (selectedFolderNodeRef == null) {
                    int i;
                    ArrayList<String> largeCollection = new ArrayList<String>(1000);
                    for (i = 0; i < 50; ++i) {
                        largeCollection.add(String.format("Large-collection-value-%05d", i));
                    }
                    for (i = 0; i < fileCount; ++i) {
                        FileInfo fileInfo = fileFolderService.create(folderNodeRef, String.format("FILE-%4d", i), ContentModel.TYPE_CONTENT);
                        NodeRef nodeRef = fileInfo.getNodeRef();
                        nodeService.setProperty(nodeRef, QName.createQName((String)"{test}mv"), (Serializable)largeCollection);
                        for (int m = 0; m < 30; ++m) {
                            nodeService.addAspect(nodeRef, QName.createQName((String)("{test}aspect_" + m)), null);
                        }
                        ContentWriter writer = fileFolderService.getWriter(nodeRef);
                        writer.setEncoding("UTF-8");
                        writer.setMimetype("text/plain");
                        writer.putContent("Some small text data");
                    }
                    System.out.println("Created " + fileCount + " files in folder " + folderNodeRef);
                }
                return folderNodeRef;
            }
        };
        AuthenticationUtil.RunAsWork<NodeRef> createRunAs = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return (NodeRef)transactionService.getRetryingTransactionHelper().doInTransaction(createCallback);
            }
        };
        final NodeRef folderNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createRunAs, (String)user);
        System.out.print("Hit any key to commence directory listing ...");
        System.in.read();
        AuthenticationUtil.RunAsWork<List<FileInfo>> readRunAs = new AuthenticationUtil.RunAsWork<List<FileInfo>>(){

            public List<FileInfo> doWork() throws Exception {
                return fileFolderService.list(folderNodeRef);
            }
        };
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            Thread readThread = new Thread("FolderList-" + i, (AuthenticationUtil.RunAsWork)readRunAs, user, fileCount, folderRefStr){
                int iteration;
                final /* synthetic */ AuthenticationUtil.RunAsWork val$readRunAs;
                final /* synthetic */ String val$user;
                final /* synthetic */ int val$fileCount;
                final /* synthetic */ String val$folderRefStr;
                {
                    this.val$readRunAs = runAsWork;
                    this.val$user = string;
                    this.val$fileCount = n;
                    this.val$folderRefStr = string2;
                    super(x0);
                    this.iteration = 0;
                }

                @Override
                public void run() {
                    while (++this.iteration <= 2) {
                        this.runImpl();
                    }
                }

                private void runImpl() {
                    String threadName = Thread.currentThread().getName();
                    long start = System.currentTimeMillis();
                    List nodeRefs = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)this.val$readRunAs, (String)this.val$user);
                    long time = System.currentTimeMillis() - start;
                    double average = (double)time / (double)this.val$fileCount;
                    if (this.val$folderRefStr != null && nodeRefs.size() != this.val$fileCount) {
                        System.err.println("WARNING: Thread " + threadName + " got " + nodeRefs.size() + " but expected " + this.val$fileCount);
                    }
                    System.out.print("\nThread " + threadName + ": \n" + "   Read " + String.format("%4d", this.val$fileCount) + " files \n" + "   Average: " + String.format("%10.2f", average) + " ms per file \n" + "   Average: " + String.format("%10.2f", 1000.0 / average) + " files per second");
                }
            };
            readThread.start();
            threads[i] = readThread;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
    }

    private static String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileFolderPerformanceTester usage: ").append("\n");
        sb.append("   FileFolderPerformanceTester --files=<filecount> --threads=<threadcount> --folder=<folderref>").append("\n");
        sb.append("      filecount: number of files in the folder").append("\n");
        sb.append("      threadcount: number of threads to do the directory listing").append("\n");
        return sb.toString();
    }
}

