/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class FileFolderServiceImplTest
extends TestCase {
    private static final String IMPORT_VIEW = "filefolder/filefolder-test-import.xml";
    private static final String NAME_L0_FILE_A = "L0- File A";
    private static final String NAME_L0_FILE_B = "L0- File B";
    private static final String NAME_L0_FOLDER_A = "L0- Folder A";
    private static final String NAME_L0_FOLDER_B = "L0- Folder B";
    private static final String NAME_L0_FOLDER_C = "L0- Folder C";
    private static final String NAME_L1_FOLDER_A = "L1- Folder A";
    private static final String NAME_L1_FOLDER_B = "L1- Folder B";
    private static final String NAME_L1_FILE_A = "L1- File A";
    private static final String NAME_L1_FILE_B = "L1- File B";
    private static final String NAME_L1_FILE_C = "L1- File C (%_)";
    private static final String NAME_CHECK_FILE = "CHECK_FILE";
    private static final String NAME_CHECK_FOLDER = "CHECK_FOLDER";
    private static final String NAME_DISCUSSION_FOLDER = "CHECK_DISCUSSION_RENAME";
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;
    private TenantService tenantService;
    private MutableAuthenticationService authenticationService;
    private DictionaryDAO dictionaryDAO;
    private UserTransaction txn;
    private NodeRef rootNodeRef;
    private NodeRef workingRootNodeRef;
    private NodeRef workingRootNodeRef1;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        IntegrityChecker.setWarnInTransaction();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        StoreRef storeRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingRootNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
        ImporterService importerService = serviceRegistry.getImporterService();
        Location importLocation = new Location(this.workingRootNodeRef);
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(IMPORT_VIEW);
        if (is == null) {
            throw new NullPointerException("Test resource not found: filefolder/filefolder-test-import.xml");
        }
        InputStreamReader reader = new InputStreamReader(is);
        importerService.importView(reader, importLocation, null, null);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("org/alfresco/repo/model/filefolder/testModel.xml");
        ArrayList labels = new ArrayList();
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.setTenantService(this.tenantService);
        bootstrap.bootstrap();
        this.workingRootNodeRef1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root1"), QName.createQName((String)"http://www.alfresco.org/test/filefoldertest/1.0", (String)"folder")).getChildRef();
        this.nodeService.createNode(this.workingRootNodeRef1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org", (String)"node1"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.createNode(this.workingRootNodeRef1, QName.createQName((String)"http://www.alfresco.org/test/filefoldertest/1.0", (String)"contains1"), QName.createQName((String)"http://www.alfresco.org", (String)"node2"), ContentModel.TYPE_CONTENT).getChildRef();
    }

    public void tearDown() throws Exception {
        try {
            if (this.txn.getStatus() != 4 && this.txn.getStatus() != 3) {
                this.txn.rollback();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void checkFileList(List<FileInfo> files, int expectedFileCount, int expectedFolderCount, String[] expectedNames) {
        int fileCount = 0;
        int folderCount = 0;
        ArrayList<String> check = new ArrayList<String>(8);
        for (String filename : expectedNames) {
            check.add(filename);
        }
        for (FileInfo file : files) {
            if (file.isFolder()) {
                ++folderCount;
            } else {
                ++fileCount;
            }
            check.remove(file.getName());
        }
        FileFolderServiceImplTest.assertTrue((String)("Name list was not exact - remaining: " + check), (check.size() == 0 ? 1 : 0) != 0);
        FileFolderServiceImplTest.assertEquals((String)"Incorrect number of files", (int)expectedFileCount, (int)fileCount);
        FileFolderServiceImplTest.assertEquals((String)"Incorrect number of folders", (int)expectedFolderCount, (int)folderCount);
    }

    public void testShallowFilesAndFoldersList() throws Exception {
        List<FileInfo> files = this.fileFolderService.list(this.workingRootNodeRef);
        String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B, NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
        this.checkFileList(files, 2, 3, expectedNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShallowFilesAndFoldersListWithLocale() throws Exception {
        Locale savedLocale = I18NUtil.getContentLocaleOrNull();
        try {
            I18NUtil.setContentLocale((Locale)Locale.CANADA);
            List<FileInfo> files = this.fileFolderService.list(this.workingRootNodeRef);
            String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B, NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
            this.checkFileList(files, 2, 3, expectedNames);
        }
        finally {
            I18NUtil.setContentLocale((Locale)savedLocale);
        }
    }

    public void testListPage() throws Exception {
        PagingRequest pagingRequest = new PagingRequest(100, null);
        PagingResults<FileInfo> pagingResults = this.fileFolderService.list(this.workingRootNodeRef, true, true, null, null, null, pagingRequest);
        FileFolderServiceImplTest.assertNotNull(pagingResults);
        FileFolderServiceImplTest.assertFalse((boolean)pagingResults.hasMoreItems());
        FileFolderServiceImplTest.assertTrue((pagingResults.getQueryExecutionId() != null && pagingResults.getQueryExecutionId().length() > 0 ? 1 : 0) != 0);
        FileFolderServiceImplTest.assertNull((Object)pagingResults.getTotalResultCount());
        List files = pagingResults.getPage();
        String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B, NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
        this.checkFileList(files, 2, 3, expectedNames);
        pagingRequest = new PagingRequest(1000, 3, null);
        pagingResults = this.fileFolderService.list(this.workingRootNodeRef, true, true, null, null, null, pagingRequest);
        FileFolderServiceImplTest.assertNotNull(pagingResults);
        FileFolderServiceImplTest.assertFalse((boolean)pagingResults.hasMoreItems());
        FileFolderServiceImplTest.assertEquals((int)0, (int)pagingResults.getPage().size());
    }

    public void testShallowFilesOnlyList() throws Exception {
        List<FileInfo> files = this.fileFolderService.listFiles(this.workingRootNodeRef);
        String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B};
        this.checkFileList(files, 2, 0, expectedNames);
    }

    public void testShallowFoldersOnlyList() throws Exception {
        List<FileInfo> files = this.fileFolderService.listFolders(this.workingRootNodeRef);
        String[] expectedNames = new String[]{NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
        this.checkFileList(files, 0, 3, expectedNames);
    }

    public void testShallowFileSearch() throws Exception {
        List<FileInfo> files = this.fileFolderService.search(this.workingRootNodeRef, NAME_L0_FILE_B, true, false, false);
        String[] expectedNames = new String[]{NAME_L0_FILE_B};
        this.checkFileList(files, 1, 0, expectedNames);
    }

    public void testDeepFilesAndFoldersSearch() throws Exception {
        List<FileInfo> files = this.fileFolderService.search(this.workingRootNodeRef, "?1-*", true, true, true);
        String[] expectedNames = new String[]{NAME_L1_FOLDER_A, NAME_L1_FOLDER_B, NAME_L1_FILE_A, NAME_L1_FILE_B, NAME_L1_FILE_C};
        this.checkFileList(files, 3, 2, expectedNames);
        files = this.fileFolderService.search(this.workingRootNodeRef, NAME_L1_FILE_B, true, true, true);
        expectedNames = new String[]{NAME_L1_FILE_B};
        this.checkFileList(files, 1, 0, expectedNames);
        files = this.fileFolderService.search(this.workingRootNodeRef, "*", true, true, true);
        expectedNames = new String[]{NAME_CHECK_FOLDER, NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C, NAME_L1_FOLDER_A, NAME_L1_FOLDER_B, NAME_CHECK_FILE, NAME_L0_FILE_A, NAME_L0_FILE_B, NAME_L1_FILE_A, NAME_L1_FILE_B, NAME_L1_FILE_C};
        this.checkFileList(files, 6, 6, expectedNames);
    }

    public void testDeepFilesOnlySearch() throws Exception {
        List<FileInfo> files = this.fileFolderService.search(this.workingRootNodeRef, "?1-*", true, false, true);
        String[] expectedNames = new String[]{NAME_L1_FILE_A, NAME_L1_FILE_B, NAME_L1_FILE_C};
        this.checkFileList(files, 3, 0, expectedNames);
    }

    private FileInfo getByName(String name, boolean isFolder) throws Exception {
        List<FileInfo> results = this.fileFolderService.search(this.workingRootNodeRef, name, !isFolder, isFolder, true);
        if (results.size() > 1) {
            throw new AlfrescoRuntimeException("Name is not unique in hierarchy: \n   name: " + name + "\n" + "   is folder: " + isFolder);
        }
        if (results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public void testGetByName() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_CHECK_FOLDER, true);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        FileFolderServiceImplTest.assertTrue((boolean)fileInfo.isFolder());
        fileInfo = this.getByName(NAME_CHECK_FILE, false);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        FileFolderServiceImplTest.assertFalse((boolean)fileInfo.isFolder());
    }

    public void testRenameNormal() throws Exception {
        FileInfo folderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderInfo);
        String newName = "DUPLICATE - renamed";
        folderInfo = this.fileFolderService.rename(folderInfo.getNodeRef(), newName);
        FileInfo checkInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNull((String)"Folder info should have been renamed away", (Object)checkInfo);
        checkInfo = this.getByName(newName, true);
        FileFolderServiceImplTest.assertNotNull((String)"Folder info for new name is not present", (Object)checkInfo);
    }

    public void testRenameWithoutAssocQNameChange() throws Exception {
        FileInfo folderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderInfo);
        NodeRef folderNodeRef = folderInfo.getNodeRef();
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"abc");
        NodeRef newFileNodeRef = this.fileFolderService.create(folderNodeRef, "AnotherFile.txt", ContentModel.TYPE_CONTENT, assocQName).getNodeRef();
        QName checkQName = this.nodeService.getPrimaryParent(newFileNodeRef).getQName();
        FileFolderServiceImplTest.assertEquals((String)"The given assoc QName was not used for the path", (Object)assocQName, (Object)checkQName);
        String newName = "AnotherFile-new.txt";
        folderInfo = this.fileFolderService.rename(newFileNodeRef, newName);
        checkQName = this.nodeService.getPrimaryParent(newFileNodeRef).getQName();
        FileFolderServiceImplTest.assertEquals((String)"The given assoc QName was not used for the path after a rename", (Object)assocQName, (Object)this.nodeService.getPrimaryParent(newFileNodeRef).getQName());
    }

    public void testRenameDuplicate() throws Exception {
        FileInfo folderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderInfo);
        String newName = NAME_L0_FILE_A;
        try {
            folderInfo = this.fileFolderService.rename(folderInfo.getNodeRef(), newName);
            FileFolderServiceImplTest.fail((String)"Existing file not detected");
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
    }

    public void testRenameDiscussionALF5569() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_L0_FILE_A, false);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        this.nodeService.addAspect(fileInfo.getNodeRef(), ForumModel.ASPECT_DISCUSSABLE, null);
        List destChildren = this.nodeService.getChildAssocs(fileInfo.getNodeRef(), (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
        FileFolderServiceImplTest.assertEquals((int)1, (int)destChildren.size());
        NodeRef discussionNodeRef = ((ChildAssociationRef)destChildren.get(0)).getChildRef();
        String currentName = (String)((Object)this.nodeService.getProperty(discussionNodeRef, ContentModel.PROP_NAME));
        FileFolderServiceImplTest.assertFalse((boolean)NAME_DISCUSSION_FOLDER.equals(currentName));
        FileInfo newFileInfo = this.fileFolderService.rename(discussionNodeRef, NAME_DISCUSSION_FOLDER);
        String newName = (String)((Object)this.nodeService.getProperty(newFileInfo.getNodeRef(), ContentModel.PROP_NAME));
        FileFolderServiceImplTest.assertEquals((String)NAME_DISCUSSION_FOLDER, (String)newName);
    }

    public void testMove() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getNonPropagatingUserTransaction();
        this.txn.begin();
        FileInfo folderToMoveInfo = this.getByName(NAME_L1_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderToMoveInfo);
        NodeRef folderToMoveRef = folderToMoveInfo.getNodeRef();
        this.fileFolderService.move(folderToMoveRef, this.workingRootNodeRef, null);
        List<FileInfo> checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, NAME_L1_FOLDER_A, false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not moved to root", (int)1, (int)checkFileInfos.size());
        FileInfo checkFileInfo = this.fileFolderService.move(folderToMoveRef, null, "new name");
        checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, checkFileInfo.getName(), false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not renamed in root", (int)1, (int)checkFileInfos.size());
        try {
            this.fileFolderService.move(folderToMoveRef, null, NAME_L0_FOLDER_A);
            FileFolderServiceImplTest.fail((String)"Existing folder not detected");
        }
        catch (FileExistsException e) {
            // empty catch block
        }
        this.txn.rollback();
        this.txn = this.transactionService.getNonPropagatingUserTransaction();
        this.txn.begin();
        FileInfo fileA = this.getByName(NAME_L1_FILE_A, false);
        FileInfo folderB = this.getByName(NAME_L0_FOLDER_B, true);
        this.fileFolderService.copy(fileA.getNodeRef(), folderB.getNodeRef(), null);
        try {
            this.fileFolderService.move(fileA.getNodeRef(), folderB.getNodeRef(), null);
            FileFolderServiceImplTest.fail((String)"Duplicately-named file in target folder was not detected");
        }
        catch (FileExistsException e) {
            // empty catch block
        }
        this.txn.rollback();
        this.txn = this.transactionService.getNonPropagatingUserTransaction();
        this.txn.begin();
        this.fileFolderService.move(fileA.getNodeRef(), folderB.getNodeRef(), NAME_L1_FILE_B);
    }

    public void testMovePermissions() throws Exception {
        this.txn.commit();
        AuthenticationUtil.RunAsWork<NodeRef> createTargetWork = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return FileFolderServiceImplTest.this.fileFolderService.create(FileFolderServiceImplTest.this.workingRootNodeRef, "TARGET", ContentModel.TYPE_FOLDER).getNodeRef();
            }
        };
        final NodeRef targetNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createTargetWork, (String)AuthenticationUtil.getSystemUserName());
        String username = "Mover-" + GUID.generate();
        char[] password = "mover".toCharArray();
        this.authenticationService.createAuthentication(username, password);
        this.permissionService.setPermission(this.rootNodeRef, username, "All", true);
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.setFullyAuthenticatedUser((String)username);
        this.fileFolderService.create(targetNodeRef, "SOURCE ONE", ContentModel.TYPE_CONTENT).getNodeRef();
        AuthenticationUtil.RunAsWork<Void> setPermissionsWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FileFolderServiceImplTest.this.permissionService.setInheritParentPermissions(targetNodeRef, false);
                FileFolderServiceImplTest.this.permissionService.setPermission(targetNodeRef, "GROUP_EVERYONE", "All", false);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)setPermissionsWork, (String)AuthenticationUtil.getSystemUserName());
        try {
            this.fileFolderService.create(targetNodeRef, "SOURCE TWO", ContentModel.TYPE_CONTENT).getNodeRef();
            FileFolderServiceImplTest.fail((String)"Expected permissions to deny a write");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        NodeRef movingNodeRef = this.fileFolderService.create(this.workingRootNodeRef, "SOURCE THREE", ContentModel.TYPE_CONTENT).getNodeRef();
        try {
            this.fileFolderService.moveFrom(movingNodeRef, this.workingRootNodeRef, targetNodeRef, "SOURCE THREE");
            FileFolderServiceImplTest.fail((String)"Expected permissions to deny the move");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        try {
            this.fileFolderService.move(movingNodeRef, targetNodeRef, "SOURCE FOUR");
            FileFolderServiceImplTest.fail((String)"Expected permissions to deny the move");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        try {
            this.fileFolderService.copy(movingNodeRef, targetNodeRef, "SOURCE FIVE");
            FileFolderServiceImplTest.fail((String)"Expected permissions to deny the copy");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
    }

    public void testCopy() throws Exception {
        FileInfo folderToCopyInfo = this.getByName(NAME_L1_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderToCopyInfo);
        NodeRef folderToCopyRef = folderToCopyInfo.getNodeRef();
        folderToCopyInfo = this.fileFolderService.copy(folderToCopyRef, this.workingRootNodeRef, null);
        folderToCopyRef = folderToCopyInfo.getNodeRef();
        List<FileInfo> checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, NAME_L1_FOLDER_A, false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not copied to root", (int)1, (int)checkFileInfos.size());
        FileInfo checkFileInfo = this.fileFolderService.copy(folderToCopyRef, null, "new name");
        checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, checkFileInfo.getName(), false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not renamed in root", (int)1, (int)checkFileInfos.size());
        try {
            this.fileFolderService.copy(folderToCopyRef, null, NAME_L0_FOLDER_A);
            FileFolderServiceImplTest.fail((String)"Existing folder not detected");
        }
        catch (FileExistsException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateFolder() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getNonPropagatingUserTransaction();
        this.txn.begin();
        FileInfo parentFolderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)parentFolderInfo);
        NodeRef parentFolderRef = parentFolderInfo.getNodeRef();
        UserTransaction rollbackTxn = null;
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            this.fileFolderService.create(parentFolderRef, NAME_L1_FILE_A, ContentModel.TYPE_CONTENT);
            FileFolderServiceImplTest.fail((String)"Failed to detect duplicate filename");
        }
        catch (FileExistsException e) {
        }
        finally {
            rollbackTxn.rollback();
        }
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            this.fileFolderService.create(parentFolderRef, "illegal folder", ContentModel.TYPE_SYSTEM_FOLDER);
            FileFolderServiceImplTest.fail((String)"Illegal type not detected");
        }
        catch (RuntimeException e) {
        }
        finally {
            rollbackTxn.rollback();
        }
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            String testNs = "http://www.alfresco.org/model/test111/1.0";
            M2Model testModel = M2Model.createModel((String)"t111:filefolderserviceimpltest");
            testModel.createNamespace(testNs, "t111");
            testModel.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
            testModel.createImport("http://www.alfresco.org/model/system/1.0", "sys");
            testModel.createImport("http://www.alfresco.org/model/content/1.0", "cm");
            M2Type testType = testModel.createType("t111:subfolder");
            testType.setParentName("cm:" + ContentModel.TYPE_FOLDER.getLocalName());
            this.dictionaryDAO.putModel(testModel);
            this.fileFolderService.create(parentFolderRef, "Legal subtype of folder", QName.createQName((String)testNs, (String)"subfolder"));
        }
        catch (Throwable e) {
            throw new Exception("Legal subtype of cm:folder not allowed.", e);
        }
        finally {
            rollbackTxn.rollback();
        }
        FileInfo fileInfo = this.fileFolderService.create(parentFolderRef, "newFile", ContentModel.TYPE_CONTENT);
        FileFolderServiceImplTest.assertTrue((String)"Node not created", (boolean)this.nodeService.exists(fileInfo.getNodeRef()));
        FileFolderServiceImplTest.assertFalse((String)"File type expected", (boolean)fileInfo.isFolder());
    }

    public void testCreateFile() throws Exception {
    }

    public void testCreateInRoot() throws Exception {
        this.fileFolderService.create(this.rootNodeRef, "New Folder", ContentModel.TYPE_FOLDER);
    }

    public void testMakeFolders() throws Exception {
        ArrayList<String> namePath = new ArrayList<String>(4);
        namePath.add("AAA");
        namePath.add("BBB");
        namePath.add("CCC");
        namePath.add("DDD");
        FileInfo lastFileInfo = FileFolderServiceImpl.makeFolders(this.fileFolderService, this.rootNodeRef, namePath, ContentModel.TYPE_FOLDER);
        FileFolderServiceImplTest.assertNotNull((String)"First makeFolder failed", (Object)lastFileInfo);
        FileInfo lastFileInfoAgain = FileFolderServiceImpl.makeFolders(this.fileFolderService, this.rootNodeRef, namePath, ContentModel.TYPE_FOLDER);
        FileFolderServiceImplTest.assertNotNull((String)"Repeat makeFolders failed", (Object)lastFileInfoAgain);
        FileFolderServiceImplTest.assertEquals((String)"Repeat created new leaf", (Object)lastFileInfo.getNodeRef(), (Object)lastFileInfoAgain.getNodeRef());
        List<FileInfo> checkInfos = this.fileFolderService.search(this.rootNodeRef, "DDD", false, true, true);
        FileFolderServiceImplTest.assertEquals((String)"Expected to find a result", (int)1, (int)checkInfos.size());
        List<FileInfo> checkPathInfos = this.fileFolderService.getNamePath(this.rootNodeRef, checkInfos.get(0).getNodeRef());
        FileFolderServiceImplTest.assertEquals((String)"Path created is incorrect", (int)namePath.size(), (int)checkPathInfos.size());
        int i = 0;
        for (FileInfo checkInfo : checkPathInfos) {
            FileFolderServiceImplTest.assertEquals((String)"Path mismatch", (String)((String)namePath.get(i)), (String)checkInfo.getName());
            ++i;
        }
    }

    public void testMakeFoldersShortNames() throws Exception {
        ArrayList<String> namePath = new ArrayList<String>(4);
        namePath.add("A");
        namePath.add("B");
        namePath.add("C");
        namePath.add("D");
        FileInfo lastFileInfo = FileFolderServiceImpl.makeFolders(this.fileFolderService, this.rootNodeRef, namePath, ContentModel.TYPE_FOLDER);
        FileFolderServiceImplTest.assertNotNull((String)"First makeFolder failed", (Object)lastFileInfo);
        FileInfo lastFileInfoAgain = FileFolderServiceImpl.makeFolders(this.fileFolderService, this.rootNodeRef, namePath, ContentModel.TYPE_FOLDER);
        FileFolderServiceImplTest.assertNotNull((String)"Repeat makeFolders failed", (Object)lastFileInfoAgain);
        FileFolderServiceImplTest.assertEquals((String)"Repeat created new leaf", (Object)lastFileInfo.getNodeRef(), (Object)lastFileInfoAgain.getNodeRef());
    }

    public void testGetNamePath() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_L1_FILE_A, false);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        NodeRef nodeRef = fileInfo.getNodeRef();
        List<FileInfo> infoPaths = this.fileFolderService.getNamePath(this.workingRootNodeRef, nodeRef);
        FileFolderServiceImplTest.assertEquals((String)"Not enough elements", (int)2, (int)infoPaths.size());
        FileFolderServiceImplTest.assertEquals((String)"First level incorrent", (String)NAME_L0_FOLDER_A, (String)infoPaths.get(0).getName());
        FileFolderServiceImplTest.assertEquals((String)"Second level incorrent", (String)NAME_L1_FILE_A, (String)infoPaths.get(1).getName());
        infoPaths = this.fileFolderService.getNamePath(null, nodeRef);
        FileFolderServiceImplTest.assertEquals((String)"Not enough elements", (int)3, (int)infoPaths.size());
        FileFolderServiceImplTest.assertEquals((String)"First level incorrent", (String)this.workingRootNodeRef.getId(), (String)infoPaths.get(0).getName());
        FileFolderServiceImplTest.assertEquals((String)"Second level incorrent", (String)NAME_L0_FOLDER_A, (String)infoPaths.get(1).getName());
        FileFolderServiceImplTest.assertEquals((String)"Third level incorrent", (String)NAME_L1_FILE_A, (String)infoPaths.get(2).getName());
        NodeRef startRef = this.getByName(NAME_L0_FOLDER_B, true).getNodeRef();
        try {
            this.fileFolderService.getNamePath(startRef, nodeRef);
            FileFolderServiceImplTest.fail((String)"Failed to detect non-aligned path from root to target node");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    public void testGetNamePathDoesNotReturnPathContainingNonLeafFileNode() throws Exception {
        FileInfo parentFolderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)parentFolderInfo);
        NodeRef parentFolderRef = parentFolderInfo.getNodeRef();
        FileInfo dirInfo = this.fileFolderService.create(parentFolderRef, "newDir", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo = this.fileFolderService.create(dirInfo.getNodeRef(), "newFile", ContentModel.TYPE_CONTENT);
        List<FileInfo> path = this.fileFolderService.getNamePath(parentFolderRef, fileInfo.getNodeRef());
        FileFolderServiceImplTest.assertEquals((int)2, (int)path.size());
        FileInfo fileInfo2 = this.fileFolderService.create(fileInfo.getNodeRef(), "newFile2", ContentModel.TYPE_CONTENT);
        try {
            this.fileFolderService.getNamePath(parentFolderRef, fileInfo2.getNodeRef());
            FileFolderServiceImplTest.fail((String)"Shouldn't create path for non-leaf file.");
        }
        catch (FileFolderServiceImpl.InvalidTypeException e) {
            // empty catch block
        }
    }

    public void testGetNamePathDoesNotCrossIntoNonFileFolderHierarchy() throws Exception {
        FileInfo parentFolderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)parentFolderInfo);
        NodeRef parentFolderRef = parentFolderInfo.getNodeRef();
        FileInfo dirInfo = this.fileFolderService.create(parentFolderRef, "newDir", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo = this.fileFolderService.create(dirInfo.getNodeRef(), "newFile", ContentModel.TYPE_CONTENT);
        List<FileInfo> path = this.fileFolderService.getNamePath(parentFolderRef, fileInfo.getNodeRef());
        FileFolderServiceImplTest.assertEquals((int)2, (int)path.size());
        NodeRef cmContainer = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"container"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef cmChild = this.nodeService.moveNode(fileInfo.getNodeRef(), cmContainer, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org", (String)"contains")).getChildRef();
        List<FileInfo> path2 = this.fileFolderService.getNamePath(cmContainer, cmChild);
        FileFolderServiceImplTest.assertEquals((int)1, (int)path2.size());
        FileFolderServiceImplTest.assertEquals((String)"newFile", (String)path2.get(0).getName());
    }

    public void testSearchSimple() throws Exception {
        FileInfo folderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderInfo);
        NodeRef folderNodeRef = folderInfo.getNodeRef();
        NodeRef phantomNodeRef = this.fileFolderService.searchSimple(folderNodeRef, "aaaaaaa");
        FileFolderServiceImplTest.assertNull((String)"Found non-existent node by name", (Object)phantomNodeRef);
        NodeRef fileNodeRef = this.fileFolderService.searchSimple(folderNodeRef, NAME_L1_FILE_A);
        FileFolderServiceImplTest.assertNotNull((String)"Didn't find file", (Object)fileNodeRef);
        FileInfo checkInfo = this.getByName(NAME_L1_FILE_A, false);
        FileFolderServiceImplTest.assertEquals((String)"Incorrect node found", (Object)checkInfo.getNodeRef(), (Object)fileNodeRef);
    }

    public void testResolveNamePath() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_L1_FILE_A, false);
        ArrayList<String> pathElements = new ArrayList<String>(3);
        pathElements.add(NAME_L0_FOLDER_A);
        pathElements.add(NAME_L1_FILE_A);
        FileInfo fileInfoCheck = this.fileFolderService.resolveNamePath(this.workingRootNodeRef, pathElements);
        FileFolderServiceImplTest.assertNotNull((String)"File info not found", (Object)fileInfoCheck);
        FileFolderServiceImplTest.assertEquals((String)"Path not resolved to correct node", (Object)fileInfo.getNodeRef(), (Object)fileInfoCheck.getNodeRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetReaderWriter() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        FileInfo dirInfo = this.getByName(NAME_L0_FOLDER_A, true);
        UserTransaction rollbackTxn = null;
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            this.fileFolderService.getWriter(dirInfo.getNodeRef());
            FileFolderServiceImplTest.fail((String)"Failed to detect content write to folder");
        }
        catch (RuntimeException e) {
        }
        finally {
            rollbackTxn.rollback();
        }
        FileInfo fileInfo = this.getByName(NAME_L1_FILE_A, false);
        ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
        FileFolderServiceImplTest.assertNotNull((String)"Writer is null", (Object)writer);
        String content = "ABC";
        writer.putContent(content);
        ContentReader reader = this.fileFolderService.getReader(fileInfo.getNodeRef());
        FileFolderServiceImplTest.assertNotNull((String)"Reader is null", (Object)reader);
        String checkContent = reader.getContentString();
        FileFolderServiceImplTest.assertEquals((String)"Content mismatch", (String)content, (String)checkContent);
    }

    public void testLongFileNames() throws Exception {
        String fileName = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        FileInfo fileInfo = this.fileFolderService.create(this.workingRootNodeRef, fileName, ContentModel.TYPE_CONTENT);
        NodeRef fileNodeRef = this.fileFolderService.searchSimple(this.workingRootNodeRef, fileName);
        FileFolderServiceImplTest.assertNotNull((String)"Long filename not found", (Object)fileNodeRef);
        FileFolderServiceImplTest.assertEquals((Object)fileInfo.getNodeRef(), (Object)fileNodeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetType() throws Exception {
        Locale savedLocale = I18NUtil.getContentLocaleOrNull();
        try {
            I18NUtil.setContentLocale((Locale)Locale.CANADA);
            FileFolderServiceType type = this.fileFolderService.getType(ContentModel.TYPE_FOLDER);
            FileFolderServiceImplTest.assertEquals((String)"Type incorrect for folder", (Object)((Object)FileFolderServiceType.FOLDER), (Object)((Object)type));
        }
        finally {
            I18NUtil.setContentLocale((Locale)savedLocale);
        }
    }

    public void testETHREEOH_3088_MoveIntoSelf() throws Exception {
        FileInfo folderInfo = this.fileFolderService.create(this.workingRootNodeRef, "NotGood.txt", ContentModel.TYPE_FOLDER);
        NodeRef folderNodeRef = folderInfo.getNodeRef();
        try {
            this.fileFolderService.move(folderNodeRef, folderNodeRef, null);
            FileFolderServiceImplTest.fail((String)"Failed to detect cyclic relationship");
        }
        catch (CyclicChildRelationshipException cyclicChildRelationshipException) {
            // empty catch block
        }
    }

    public void testAlf6560MimetypeSetting() throws Exception {
        FileInfo fileInfo = this.fileFolderService.create(this.workingRootNodeRef, "Something.html", ContentModel.TYPE_CONTENT);
        NodeRef fileNodeRef = fileInfo.getNodeRef();
        ContentWriter writer = this.fileFolderService.getWriter(fileNodeRef);
        writer.putContent("CONTENT");
        ContentReader reader = this.fileFolderService.getReader(fileNodeRef);
        FileFolderServiceImplTest.assertEquals((String)"Mimetype was not automatically set", (String)"text/html", (String)reader.getMimetype());
        writer = this.fileFolderService.getWriter(fileNodeRef);
        writer.guessEncoding();
        OutputStream out = writer.getContentOutputStream();
        out.write("<html><body>hall\u00e5 v\u00e4rlden</body></html>".getBytes("UnicodeBig"));
        out.close();
        reader = this.fileFolderService.getReader(fileNodeRef);
        FileFolderServiceImplTest.assertEquals((String)"Mimetype was not automatically set", (String)"text/html", (String)reader.getMimetype());
        FileFolderServiceImplTest.assertEquals((String)"Encoding was not automatically set", (String)"UTF-16BE", (String)reader.getEncoding());
    }

    public void testGetLocalizedSibling() throws Exception {
        FileInfo base = this.fileFolderService.create(this.workingRootNodeRef, "Something.ftl", ContentModel.TYPE_CONTENT);
        NodeRef node = base.getNodeRef();
        NodeRef nodeFr = this.fileFolderService.create(this.workingRootNodeRef, "Something_fr.ftl", ContentModel.TYPE_CONTENT).getNodeRef();
        NodeRef nodeFrFr = this.fileFolderService.create(this.workingRootNodeRef, "Something_fr_FR..ftl", ContentModel.TYPE_CONTENT).getNodeRef();
        NodeRef nodeEn = this.fileFolderService.create(this.workingRootNodeRef, "Something_en.ftl", ContentModel.TYPE_CONTENT).getNodeRef();
        NodeRef nodeEnUs = this.fileFolderService.create(this.workingRootNodeRef, "Something_en_US.ftl", ContentModel.TYPE_CONTENT).getNodeRef();
        I18NUtil.setLocale((Locale)Locale.US);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)nodeEnUs, (Object)this.fileFolderService.getLocalizedSibling(node));
        I18NUtil.setLocale((Locale)Locale.UK);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)nodeEn, (Object)this.fileFolderService.getLocalizedSibling(node));
        I18NUtil.setLocale((Locale)Locale.CHINESE);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)node, (Object)this.fileFolderService.getLocalizedSibling(node));
        I18NUtil.setLocale((Locale)Locale.US);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)nodeFr, (Object)this.fileFolderService.getLocalizedSibling(nodeFr));
        I18NUtil.setLocale((Locale)Locale.UK);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)nodeFr, (Object)this.fileFolderService.getLocalizedSibling(nodeFr));
        I18NUtil.setLocale((Locale)Locale.CHINESE);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)nodeFr, (Object)this.fileFolderService.getLocalizedSibling(nodeFr));
        FileInfo mbase = this.fileFolderService.create(this.workingRootNodeRef, "Another.get.html.ftl", ContentModel.TYPE_CONTENT);
        NodeRef mnode = mbase.getNodeRef();
        NodeRef mnodeFr = this.fileFolderService.create(this.workingRootNodeRef, "Another_fr.get.html.ftl", ContentModel.TYPE_CONTENT).getNodeRef();
        I18NUtil.setLocale((Locale)Locale.UK);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)mnode, (Object)this.fileFolderService.getLocalizedSibling(mnode));
        I18NUtil.setLocale((Locale)Locale.FRENCH);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)mnodeFr, (Object)this.fileFolderService.getLocalizedSibling(mnode));
        I18NUtil.setLocale((Locale)Locale.CHINESE);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)mnode, (Object)this.fileFolderService.getLocalizedSibling(mnode));
        I18NUtil.setLocale((Locale)Locale.US);
        FileFolderServiceImplTest.assertEquals((String)("Match fail for " + I18NUtil.getLocale()), (Object)mnode, (Object)this.fileFolderService.getLocalizedSibling(mnode));
    }

    public synchronized void testAlf7421TimestampPropagation() throws Exception {
        this.txn.commit();
        this.nodeService.addAspect(this.workingRootNodeRef, ContentModel.ASPECT_AUDITABLE, null);
        FileInfo folderInfo = this.fileFolderService.create(this.workingRootNodeRef, "SomeFolder", ContentModel.TYPE_FOLDER);
        NodeRef folderNodeRef = folderInfo.getNodeRef();
        String creatorExpected = (String)((Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATOR));
        Date createdExpected = (Date)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATED);
        String modifierExpected = (String)((Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIER));
        Date modifiedExpected = (Date)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED);
        String creatorTooHigh = (String)((Object)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_CREATOR));
        Date createdTooHigh = (Date)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_CREATED);
        String modifierTooHigh = (String)((Object)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_MODIFIER));
        Date modifiedTooHigh = (Date)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_MODIFIED);
        Date beforeSleep = new Date();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        FileInfo fileInfo = this.fileFolderService.create(folderNodeRef, "Something.html", ContentModel.TYPE_CONTENT);
        NodeRef fileNodeRef = fileInfo.getNodeRef();
        this.nodeService.addAspect(fileNodeRef, ContentModel.ASPECT_AUDITABLE, null);
        FileFolderServiceImplTest.assertEquals((String)"cm:creator should not have changed", (Object)creatorExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created should not have changed", (Object)createdExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier should have changed", (Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_MODIFIER), (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertTrue((String)"cm:modified should have changed", (beforeSleep.compareTo((Date)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED)) < 0 ? 1 : 0) != 0);
        modifiedExpected = (Date)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED);
        beforeSleep = new Date();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.nodeService.setProperty(fileNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Hippo"));
        FileFolderServiceImplTest.assertEquals((String)"cm:creator should not have changed", (Object)creatorExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created should not have changed", (Object)createdExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier should not have changed", (Object)modifierExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertTrue((String)"cm:modified should not have changed", (boolean)modifiedExpected.equals(this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED)));
        modifiedExpected = (Date)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.nodeService.setProperty(fileNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Something-new.html"));
        FileFolderServiceImplTest.assertEquals((String)"cm:creator should not have changed", (Object)creatorExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created should not have changed", (Object)createdExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier should not have changed", (Object)modifierExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertEquals((String)"cm:modified should not have changed", (Object)modifiedExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED));
        beforeSleep = new Date();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.fileFolderService.delete(fileNodeRef);
        FileFolderServiceImplTest.assertEquals((String)"cm:creator should not have changed", (Object)creatorExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created should not have changed", (Object)createdExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier should have changed", (Object)modifierExpected, (Object)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertTrue((String)"cm:modified should have changed", (beforeSleep.compareTo((Date)this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_MODIFIED)) < 0 ? 1 : 0) != 0);
        FileFolderServiceImplTest.assertEquals((String)"cm:creator should not have changed (level too high)", (Object)creatorTooHigh, (Object)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created should not have changed (level too high)", (Object)createdTooHigh, (Object)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier should not have changed (level too high)", (Object)modifierTooHigh, (Object)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertEquals((String)"cm:modified should not have changed (level too high)", (Object)modifiedTooHigh, (Object)this.nodeService.getProperty(this.workingRootNodeRef, ContentModel.PROP_MODIFIED));
        FileInfo sourceFolderInfo = this.fileFolderService.create(this.workingRootNodeRef, "SourceFolder", ContentModel.TYPE_FOLDER);
        NodeRef sourceFolderNodeRef = sourceFolderInfo.getNodeRef();
        FileInfo destinationFolderInfo = this.fileFolderService.create(this.workingRootNodeRef, "DestinationFolder", ContentModel.TYPE_FOLDER);
        NodeRef destinationFolderNodeRef = destinationFolderInfo.getNodeRef();
        String sourceFolderCreatorExpected = (String)((Object)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_CREATOR));
        Date sourceFolderCreatedExpected = (Date)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_CREATED);
        String destinationFolderCreatorExpected = (String)((Object)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_CREATOR));
        Date destinationFolderCreatedExpected = (Date)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_CREATED);
        FileInfo relocatableFileInfo = this.fileFolderService.create(sourceFolderNodeRef, "MoveMePlease.html", ContentModel.TYPE_CONTENT);
        NodeRef relocatableFileNodeRef = relocatableFileInfo.getNodeRef();
        this.nodeService.addAspect(relocatableFileNodeRef, ContentModel.ASPECT_AUDITABLE, null);
        String sourceFolderModifierExpected = (String)((Object)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_MODIFIER));
        String destinationFolderModifierExpected = (String)((Object)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_MODIFIER));
        beforeSleep = new Date();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.fileFolderService.moveFrom(relocatableFileNodeRef, sourceFolderNodeRef, destinationFolderNodeRef, "MoveMePlease.html");
        FileFolderServiceImplTest.assertEquals((String)"cm:creator for source folder should not have changed", (Object)sourceFolderCreatorExpected, (Object)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created for source folder should not have changed", (Object)sourceFolderCreatedExpected, (Object)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier for source folder should not have changed", (Object)sourceFolderModifierExpected, (Object)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertTrue((String)"cm:modified for source folder should have changed", (beforeSleep.compareTo((Date)this.nodeService.getProperty(sourceFolderNodeRef, ContentModel.PROP_MODIFIED)) < 0 ? 1 : 0) != 0);
        FileFolderServiceImplTest.assertEquals((String)"cm:creator for destination folder should not have changed", (Object)destinationFolderCreatorExpected, (Object)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_CREATOR));
        FileFolderServiceImplTest.assertEquals((String)"cm:created for destination folder should not have changed", (Object)destinationFolderCreatedExpected, (Object)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_CREATED));
        FileFolderServiceImplTest.assertEquals((String)"cm:modifier for destination folder should not have changed", (Object)destinationFolderModifierExpected, (Object)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_MODIFIER));
        FileFolderServiceImplTest.assertTrue((String)"cm:modified for destination folder should have changed", (beforeSleep.compareTo((Date)this.nodeService.getProperty(destinationFolderNodeRef, ContentModel.PROP_MODIFIED)) < 0 ? 1 : 0) != 0);
    }

    public void testPatterns() {
        I18NUtil.setContentLocale((Locale)Locale.CANADA);
        PagingRequest pagingRequest = new PagingRequest(100, null);
        PagingResults<FileInfo> pagingResults = this.fileFolderService.list(this.workingRootNodeRef, true, true, "L0*", null, null, pagingRequest);
        FileFolderServiceImplTest.assertNotNull(pagingResults);
        FileFolderServiceImplTest.assertFalse((boolean)pagingResults.hasMoreItems());
        FileFolderServiceImplTest.assertNull((Object)pagingResults.getTotalResultCount());
        List files = pagingResults.getPage();
        String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B, NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
        this.checkFileList(files, 2, 3, expectedNames);
        pagingResults = this.fileFolderService.list(this.workingRootNodeRef, true, true, "L1*", null, null, pagingRequest);
        FileFolderServiceImplTest.assertNotNull(pagingResults);
        FileFolderServiceImplTest.assertFalse((boolean)pagingResults.hasMoreItems());
        FileFolderServiceImplTest.assertNull((Object)pagingResults.getTotalResultCount());
        files = pagingResults.getPage();
        expectedNames = new String[]{};
        this.checkFileList(files, 0, 0, expectedNames);
        pagingResults = this.fileFolderService.list(this.workingRootNodeRef, true, true, "L0*File*", null, null, pagingRequest);
        FileFolderServiceImplTest.assertNotNull(pagingResults);
        FileFolderServiceImplTest.assertFalse((boolean)pagingResults.hasMoreItems());
        FileFolderServiceImplTest.assertNull((Object)pagingResults.getTotalResultCount());
        files = pagingResults.getPage();
        expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B};
        this.checkFileList(files, 2, 0, expectedNames);
    }

    public void testALF12758() {
        PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE);
        PagingResults<FileInfo> pagingResults = this.fileFolderService.list(this.workingRootNodeRef1, true, true, null, null, null, pagingRequest);
        FileFolderServiceImplTest.assertNotNull(pagingResults);
        FileFolderServiceImplTest.assertNotNull((Object)pagingResults.getPage());
        FileFolderServiceImplTest.assertEquals((int)1, (int)pagingResults.getPage().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListHiddenFiles() {
        FileFilterMode.Client saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            int i;
            NodeRef nodeRef = this.fileFolderService.create(this.workingRootNodeRef, "" + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef nodeRef1 = this.fileFolderService.create(nodeRef, "parent", ContentModel.TYPE_CONTENT).getNodeRef();
            for (i = 0; i < 10; ++i) {
                this.fileFolderService.create(nodeRef1, ".child" + i, ContentModel.TYPE_CONTENT).getNodeRef();
            }
            for (i = 0; i < 10; ++i) {
                this.fileFolderService.create(nodeRef1, "visiblechild" + i, ContentModel.TYPE_CONTENT).getNodeRef();
            }
            saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
            PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE);
            pagingRequest.setRequestTotalCountMax(10000);
            PagingResults<FileInfo> results = this.fileFolderService.list(nodeRef1, true, true, null, null, pagingRequest);
            Pair totalResultCount = results.getTotalResultCount();
            FileFolderServiceImplTest.assertNotNull((Object)totalResultCount.getFirst());
            FileFolderServiceImplTest.assertEquals((String)"Total result lower count should be 10", (int)10, (int)((Integer)totalResultCount.getFirst()));
            FileFolderServiceImplTest.assertNotNull((Object)totalResultCount.getSecond());
            FileFolderServiceImplTest.assertEquals((String)"Total result upper count should be 10", (int)10, (int)((Integer)totalResultCount.getSecond()));
            for (FileInfo fileInfo : results.getPage()) {
                FileFolderServiceImplTest.assertTrue((boolean)fileInfo.getName().startsWith("visiblechild"));
            }
            FileFolderServiceImplTest.assertEquals((String)"Expected only 10 results", (int)10, (int)results.getPage().size());
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
        }
    }
}

