/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;

public class GetChildrenCannedQuery
extends org.alfresco.repo.node.getchildren.GetChildrenCannedQuery {
    private HiddenAspect hiddenAspect;
    private DictionaryService dictionaryService;

    public GetChildrenCannedQuery(NodeDAO nodeDAO, QNameDAO qnameDAO, CannedQueryDAO cannedQueryDAO, NodePropertyHelper nodePropertyHelper, TenantService tenantService, MethodSecurityBean<NodeRef> methodSecurity, CannedQueryParameters params, HiddenAspect hiddenAspect, DictionaryService dictionaryService) {
        super(nodeDAO, qnameDAO, cannedQueryDAO, nodePropertyHelper, tenantService, methodSecurity, params);
        this.hiddenAspect = hiddenAspect;
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected GetChildrenCannedQuery.UnsortedChildQueryCallback getUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount) {
        FileFolderUnsortedChildQueryCallback callback = new FileFolderUnsortedChildQueryCallback(rawResult, requestedCount);
        return callback;
    }

    @Override
    protected GetChildrenCannedQuery.FilterSortChildQueryCallback getFilterSortChildQuery(List<GetChildrenCannedQuery.FilterSortNode> children, List<FilterProp> filterProps) {
        FileFolderFilterSortChildQueryCallback callback = new FileFolderFilterSortChildQueryCallback(children, filterProps);
        return callback;
    }

    private class FileFolderUnsortedChildQueryCallback
    extends GetChildrenCannedQuery.DefaultUnsortedChildQueryCallback {
        public FileFolderUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount) {
            super(GetChildrenCannedQuery.this, rawResult, requestedCount);
        }

        @Override
        protected boolean include(NodeRef nodeRef) {
            boolean ret = super.include(nodeRef);
            try {
                FileFilterMode.Client client = FileFilterMode.getClient();
                return ret && GetChildrenCannedQuery.this.hiddenAspect.getVisibility(client, nodeRef) != HiddenAspect.Visibility.NotVisible;
            }
            catch (AccessDeniedException e) {
                return ret;
            }
        }
    }

    private class FileFolderFilterSortChildQueryCallback
    extends GetChildrenCannedQuery.DefaultFilterSortChildQueryCallback {
        private Map<QName, Boolean> isTypeFolderMap;

        public FileFolderFilterSortChildQueryCallback(List<GetChildrenCannedQuery.FilterSortNode> children, List<FilterProp> filterProps) {
            super(GetChildrenCannedQuery.this, children, filterProps);
            this.isTypeFolderMap = new HashMap<QName, Boolean>(10);
        }

        @Override
        protected boolean include(GetChildrenCannedQuery.FilterSortNode node) {
            boolean ret = super.include(node);
            try {
                FileFilterMode.Client client = FileFilterMode.getClient();
                return ret && GetChildrenCannedQuery.this.hiddenAspect.getVisibility(client, node.getNodeRef()) != HiddenAspect.Visibility.NotVisible;
            }
            catch (AccessDeniedException e) {
                return ret;
            }
        }

        @Override
        public boolean handle(GetChildrenCannedQuery.FilterSortNode node) {
            super.handle(node);
            Map<QName, Serializable> propVals = node.getPropVals();
            QName nodeTypeQName = (QName)propVals.get(SORT_QNAME_NODE_TYPE);
            if (nodeTypeQName != null) {
                Boolean isFolder = this.isTypeFolderMap.get(nodeTypeQName);
                if (isFolder == null) {
                    isFolder = GetChildrenCannedQuery.this.dictionaryService.isSubClass(nodeTypeQName, ContentModel.TYPE_FOLDER);
                    this.isTypeFolderMap.put(nodeTypeQName, isFolder);
                }
                propVals.put(SORT_QNAME_NODE_IS_FOLDER, isFolder);
            }
            return true;
        }
    }
}

