/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleInstallState;
import org.alfresco.util.VersionNumber;

public class ModuleDetailsImplTest
extends TestCase {
    private Properties defaultProperties;

    protected void setUp() throws Exception {
        this.defaultProperties = new Properties();
        this.defaultProperties.setProperty("module.id", "org.alfresco.module.Test");
        this.defaultProperties.setProperty("module.aliases", "test, Test");
        this.defaultProperties.setProperty("module.title", "Test");
        this.defaultProperties.setProperty("module.description", "Test description");
        this.defaultProperties.setProperty("module.version", "1.0.0");
        this.defaultProperties.setProperty("module.editions", "Community, Enterprise");
        this.defaultProperties.setProperty("module.repo.version.min", new VersionNumber("1.2").toString());
        this.defaultProperties.setProperty("module.repo.version.max", new VersionNumber("1.4.3").toString());
        this.defaultProperties.setProperty("module.depends.a", "1.2.3");
        this.defaultProperties.setProperty("module.depends.b", "*");
        this.defaultProperties.setProperty("module.depends.c", "- 1.2");
        this.defaultProperties.setProperty("module.depends.d", "1.2 -");
        this.defaultProperties.setProperty("module.depends.e", "* - 1.2");
        this.defaultProperties.setProperty("module.depends.f", "1.2 - *");
        this.defaultProperties.setProperty("module.depends.g", "0.5, 0.6");
        this.defaultProperties.setProperty("module.depends.h", "0.5 - 0.6, 0.9 - *");
        this.defaultProperties.setProperty("module.installState", ModuleInstallState.INSTALLED.toString());
    }

    public void testDefaults() {
        ModuleDetailsImpl details = new ModuleDetailsImpl(this.defaultProperties);
    }

    public void testWriteAndReadProperties() {
        ModuleDetailsImpl details = new ModuleDetailsImpl(this.defaultProperties);
        Properties processedProperties = details.getProperties();
        ModuleDetailsImplTest.assertEquals((String)"The number of properties changed", (int)this.defaultProperties.size(), (int)processedProperties.size());
        ModuleDetailsImplTest.assertEquals((String)"The properties are different", (Object)this.defaultProperties, (Object)processedProperties);
    }

    public void testDependencyChecks() {
        ModuleDetailsImpl details = new ModuleDetailsImpl(this.defaultProperties);
        Properties tempProperties = new Properties();
        tempProperties.setProperty("module.id", "a");
        tempProperties.setProperty("module.title", "A");
        tempProperties.setProperty("module.description", "A description");
        tempProperties.setProperty("module.version", "1.0.0");
        ModuleDetailsImpl tempDetails = new ModuleDetailsImpl(tempProperties);
        List<ModuleDependency> dependencies = details.getDependencies();
        ModuleDetailsImplTest.assertEquals((String)"Incorrect number of dependencies", (int)8, (int)dependencies.size());
        for (ModuleDependency dependency : dependencies) {
            if (!dependency.getDependencyId().equals(tempDetails.getId())) continue;
            ModuleDetailsImplTest.assertFalse((String)"No match expected", (boolean)dependency.isValidDependency(tempDetails));
        }
    }

    public void testTrimming() throws Exception {
        this.defaultProperties.setProperty("module.installState", "    ");
        ModuleDetailsImpl details = new ModuleDetailsImpl(this.defaultProperties);
        ModuleDetailsImplTest.assertEquals((String)"Expected the install state to be UNKNOWN", (Object)((Object)ModuleInstallState.UNKNOWN), (Object)((Object)details.getInstallState()));
    }

    public void testInvalidIds() throws Exception {
        String[] invalidIds;
        for (String invalidId : invalidIds = new String[]{"", " ", "$", "module$Test", "module.Test$", "org alfresco module Test"}) {
            try {
                this.defaultProperties.setProperty("module.id", invalidId);
                new ModuleDetailsImpl(this.defaultProperties);
                ModuleDetailsImplTest.fail((String)("Invalid ID not detected: " + invalidId));
            }
            catch (AlfrescoRuntimeException e) {
                // empty catch block
            }
        }
    }

    public void testValidIds() throws Exception {
        String[] validIds;
        for (String validId : validIds = new String[]{"abc123", " abc123 ", "a-b-c", "a.b.c", "a_b_c", "A.1.2.3"}) {
            this.defaultProperties.setProperty("module.id", validId);
            new ModuleDetailsImpl(this.defaultProperties);
        }
    }
}

