/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.module.tool.InstalledFiles;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.util.TempFileProvider;
import org.springframework.util.FileCopyUtils;

public class ModuleManagementToolTest
extends TestCase {
    private ModuleManagementTool manager = new ModuleManagementTool();
    static final int BUFFER = 2048;

    public void testBasicInstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        String ampV2Location = this.getFileLocation(".amp", "module/test_v2.amp");
        this.installerSharedTests(warLocation, ampLocation, ampV2Location);
    }

    private void installerSharedTests(String warLocation, String ampLocation, String ampV2Location) {
        this.manager.installModule(ampLocation, warLocation);
        ArrayList<String> files = new ArrayList<String>(10);
        files.add("/WEB-INF/classes/alfresco/module/test/module.properties");
        files.add("/WEB-INF/classes/alfresco/module/test/modifications.install");
        files.add("/WEB-INF/lib/test.jar");
        files.add("/WEB-INF/classes/alfresco/module/test/module-context.xml");
        files.add("/WEB-INF/classes/alfresco/module/test");
        files.add("/WEB-INF/licenses/license.txt");
        files.add("/scripts/test.js");
        files.add("/images/test.jpg");
        files.add("/jsp/test.jsp");
        files.add("/css/test.css");
        files.add("/extra.txt");
        this.checkForFileExistance(warLocation, files);
        InstalledFiles installed0 = new InstalledFiles(warLocation, "test");
        installed0.load();
        ModuleManagementToolTest.assertNotNull((Object)installed0);
        ModuleManagementToolTest.assertEquals((int)9, (int)installed0.getAdds().size());
        ModuleManagementToolTest.assertEquals((int)1, (int)installed0.getMkdirs().size());
        try {
            this.manager.installModule(ampLocation, warLocation);
        }
        catch (ModuleManagementToolException exception) {
            // empty catch block
        }
        this.manager.installModule(ampV2Location, warLocation);
        ArrayList<String> files2 = new ArrayList<String>(12);
        files.add("/WEB-INF/classes/alfresco/module/test/module.properties");
        files.add("/WEB-INF/classes/alfresco/module/test/modifications.install");
        files2.add("/WEB-INF/lib/test.jar");
        files2.add("/WEB-INF/classes/alfresco/module/test/module-context.xml");
        files2.add("/WEB-INF/classes/alfresco/module/test");
        files2.add("/WEB-INF/licenses/license.txt");
        files2.add("/scripts/test2.js");
        files2.add("/scripts/test3.js");
        files2.add("/images/test.jpg");
        files2.add("/css/test.css");
        files2.add("/WEB-INF/classes/alfresco/module/test/version2");
        files2.add("/WEB-INF/classes/alfresco/module/test/version2/version2-context.xml");
        this.checkForFileExistance(warLocation, files2);
        ArrayList<String> files3 = new ArrayList<String>(2);
        files3.add("/scripts/test.js");
        files3.add("/jsp/test.jsp");
        files3.add("/extra.txt");
        this.checkForFileNonExistance(warLocation, files3);
        InstalledFiles installed1 = new InstalledFiles(warLocation, "test");
        installed1.load();
        ModuleManagementToolTest.assertNotNull((Object)installed1);
        ModuleManagementToolTest.assertEquals((int)8, (int)installed1.getAdds().size());
        ModuleManagementToolTest.assertEquals((int)1, (int)installed1.getMkdirs().size());
        ModuleManagementToolTest.assertEquals((int)0, (int)installed1.getUpdates().size());
        try {
            this.manager.installModule(ampLocation, warLocation);
            this.checkForFileExistance(warLocation, files2);
            this.checkForFileNonExistance(warLocation, files3);
        }
        catch (ModuleManagementToolException exception) {
            // empty catch block
        }
    }

    public void testBasicFolderInstall() throws Exception {
        this.manager.setVerbose(true);
        String warDirectory = this.extractToDir(".war", "module/test.war");
        String ampDirectory = this.extractToDir(".amp", "module/test_v1.amp");
        String ampV2Directory = this.getFileLocation(".amp", "module/test_v2.amp");
        ModuleManagementToolTest.assertNotNull((Object)warDirectory);
        ModuleManagementToolTest.assertNotNull((Object)ampDirectory);
        ModuleManagementToolTest.assertNotNull((Object)ampV2Directory);
        this.installerSharedTests(warDirectory, ampDirectory, ampV2Directory);
        warDirectory = this.extractToDir(".war", "module/share-3.4.11.war");
        ModuleManagementToolTest.assertNotNull((Object)warDirectory);
        ModuleManagementToolTest.assertNotNull((Object)ampDirectory);
        this.manager.installModule(ampDirectory, warDirectory);
    }

    public void testDependencySuccess() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String testAmpV1Location = this.getFileLocation(".amp", "module/test_v1.amp");
        String testAmpV2Location = this.getFileLocation(".amp", "module/test_v2.amp");
        String testAmpDepV1Location = this.getFileLocation(".amp", "module/dependent_on_test_v1.amp");
        String testAmpDepV2Location = this.getFileLocation(".amp", "module/dependent_on_test_v2.amp");
        this.manager.installModule(testAmpV1Location, warLocation, false, false, false);
        this.manager.installModule(testAmpDepV1Location, warLocation, false, false, false);
        try {
            this.manager.installModule(testAmpDepV2Location, warLocation, false, false, false);
            ModuleManagementToolTest.fail((String)"Failed to detect inadequate dependency on the test amp");
        }
        catch (ModuleManagementToolException e) {
            System.out.println("Expected: " + e.getMessage());
        }
        this.manager.installModule(testAmpV2Location, warLocation, false, false, false);
        this.manager.installModule(testAmpDepV2Location, warLocation, false, false, false);
    }

    public void testPreviewInstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        this.manager.installModule(ampLocation, warLocation, true, false, true);
    }

    public void testUninstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        this.manager.installModule(ampLocation, warLocation, false, false, false);
        this.manager.listModules(warLocation);
        this.manager.uninstallModule("test", warLocation, false, false);
        ArrayList<String> files = new ArrayList<String>(10);
        files.add("/WEB-INF/classes/alfresco/module/test/module.properties");
        files.add("/WEB-INF/classes/alfresco/module/test/modifications.install");
        files.add("/WEB-INF/lib/test.jar");
        files.add("/WEB-INF/classes/alfresco/module/test/module-context.xml");
        this.checkForFileNonExistance(warLocation, files);
    }

    public void testForcedInstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v4.amp");
        try {
            this.manager.installModule(ampLocation, warLocation, false, false, false);
            ModuleManagementToolTest.fail((String)"Failed to detect existing files in the amp");
        }
        catch (ModuleManagementToolException e) {
            ModuleManagementToolTest.assertTrue((boolean)e.getMessage().contains("The amp will overwrite an existing file"));
        }
        this.manager.installModule(ampLocation, warLocation, false, true, false);
        this.manager.installModule(ampLocation, warLocation, false, true, false);
    }

    public void testInstallFromDir() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        String ampV2Location = this.getFileLocation(".amp", "module/test_v2.amp");
        int index = ampV2Location.lastIndexOf(File.separator);
        System.out.println(index);
        String directoryLocation = ampV2Location.substring(0, index);
        try {
            this.manager.installModules(directoryLocation, warLocation);
        }
        catch (ModuleManagementToolException exception) {
            exception.printStackTrace();
            System.out.println("Expected failure: " + exception.getMessage());
        }
    }

    public void testExistingFilesInWar() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v4.amp");
        try {
            this.manager.installModule(ampLocation, warLocation, false, false, true);
        }
        catch (ModuleManagementToolException exception) {
            ModuleManagementToolTest.assertTrue((boolean)exception.getMessage().contains("will overwrite an existing file in the war"));
        }
        this.manager.installModule(ampLocation, warLocation, false, true, true);
        this.checkContentsOfFile(warLocation + "/jsp/relogin.jsp", "VERSIONONE");
        this.checkContentsOfFile(warLocation + "/css/main.css", "p{margin-bottom:1em;}");
        this.manager.installModule(ampLocation, warLocation, false, true, false);
    }

    public void testWhiteSpaceInCustomMapping() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v3.amp");
        this.manager.installModule(ampLocation, warLocation, false, false, true);
        ArrayList<String> files = new ArrayList<String>(10);
        files.add("/WEB-INF/classes/alfresco/module/test/module.properties");
        files.add("/WEB-INF/classes/alfresco/module/test/modifications.install");
        files.add("/WEB-INF/lib/test.jar");
        files.add("/WEB-INF/classes/alfresco/module/test/module-context.xml");
        files.add("/images/test.jpg");
        files.add("/css/test.css");
        files.add("/extra.txt");
        this.checkForFileExistance(warLocation, files);
    }

    public void testList() throws Exception {
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        this.manager.listModules(warLocation);
        this.manager.installModule(ampLocation, warLocation);
        this.manager.listModules(warLocation);
    }

    private String getFileLocation(String extension, String location) throws IOException {
        File file = TempFileProvider.createTempFile((String)"moduleManagementToolTest-", (String)extension);
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(location);
        ModuleManagementToolTest.assertNotNull((Object)is);
        FileOutputStream os = new FileOutputStream(file);
        FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        return file.getPath();
    }

    private String extractToDir(String extension, String location) {
        File tmpDir = TempFileProvider.getTempDir();
        try {
            TFile zipFile = new TFile(((Object)((Object)this)).getClass().getClassLoader().getResource(location).getPath());
            TFile outDir = new TFile(tmpDir.getAbsolutePath() + "/moduleManagementToolTestDir" + System.currentTimeMillis());
            outDir.mkdir();
            zipFile.cp_rp((File)outDir);
            TVFS.umount((TFile)zipFile);
            return outDir.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void testNoWar() throws Exception {
        String noWar = "noWar";
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        try {
            this.manager.installModule(ampLocation, noWar, false, false, false);
        }
        catch (ModuleManagementToolException exception) {
            ModuleManagementToolTest.assertTrue((boolean)exception.getMessage().endsWith("does not exist."));
        }
        try {
            this.manager.installModule(ampLocation, noWar, false, false, true);
        }
        catch (ModuleManagementToolException exception) {
            ModuleManagementToolTest.assertTrue((boolean)exception.getMessage().endsWith("does not exist."));
        }
    }

    private void checkForFileExistance(String warLocation, List<String> files) {
        for (String file : files) {
            TFile file0 = new TFile(warLocation + file);
            ModuleManagementToolTest.assertTrue((String)("The file/dir " + file + " does not exist in the WAR."), (boolean)file0.exists());
        }
    }

    private void checkForFileNonExistance(String warLocation, List<String> files) {
        for (String file : files) {
            TFile file0 = new TFile(warLocation + file);
            ModuleManagementToolTest.assertFalse((String)("The file/dir " + file + " does exist in the WAR."), (boolean)file0.exists());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkContentsOfFile(String location, String expectedContents) throws IOException {
        TFile file = new TFile(location);
        ModuleManagementToolTest.assertTrue((boolean)file.exists());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new TFileInputStream((File)file)));
            String line = reader.readLine();
            ModuleManagementToolTest.assertNotNull((Object)line);
            ModuleManagementToolTest.assertEquals((String)expectedContents, (String)line.trim());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {}
            }
        }
    }
}

