/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class LargeArchiveAndRestoreTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Log logger = LogFactory.getLog(LargeArchiveAndRestoreTest.class);
    private NodeService nodeService;
    private NodeArchiveService nodeArchiveService;
    private FileFolderService fileFolderService;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private NodeRef rootNodeRef;
    private static final int NUM_FOLDERS = 5;
    private static final int MAX_DEPTH = 3;
    private static final int NUM_FILES = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.transactionService = serviceRegistry.getTransactionService();
        try {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
            this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        }
        finally {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
    }

    public void tearDown() throws Exception {
    }

    public void testSetUp() throws Exception {
    }

    public void testCreateAndRestore() throws Exception {
        AuthenticationUtil.RunAsWork<NodeRef> createHierarchyWork = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                CreateDataCallback callback = new CreateDataCallback(LargeArchiveAndRestoreTest.this.rootNodeRef);
                return LargeArchiveAndRestoreTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(callback);
            }
        };
        final NodeRef parentNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createHierarchyWork, (String)"System");
        final RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> deleteHierarchyCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                LargeArchiveAndRestoreTest.this.fileFolderService.delete(parentNodeRef);
                NodeRef archivedParentNodeRef = new NodeRef("archive", parentNodeRef.getStoreRef().getIdentifier(), parentNodeRef.getId());
                if (!LargeArchiveAndRestoreTest.this.nodeService.exists(archivedParentNodeRef)) {
                    throw new InvalidNodeRefException("Archived node not found after delete: " + archivedParentNodeRef, archivedParentNodeRef);
                }
                if (LargeArchiveAndRestoreTest.this.nodeService.exists(parentNodeRef)) {
                    throw new InvalidNodeRefException("Original node was found after delete: " + parentNodeRef, parentNodeRef);
                }
                return archivedParentNodeRef;
            }
        };
        AuthenticationUtil.RunAsWork<NodeRef> deleteHierarchyWork = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return (NodeRef)LargeArchiveAndRestoreTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteHierarchyCallback);
            }
        };
        final NodeRef archivedParentNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)deleteHierarchyWork, (String)"System");
        final RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> restoreHierarchyCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                List<RestoreNodeReport> report = LargeArchiveAndRestoreTest.this.nodeArchiveService.restoreArchivedNodes(Collections.singletonList(archivedParentNodeRef));
                System.out.println("Restore report: \n" + report);
                if (LargeArchiveAndRestoreTest.this.nodeService.exists(archivedParentNodeRef)) {
                    throw new InvalidNodeRefException("Archived node was found after restore: " + archivedParentNodeRef, archivedParentNodeRef);
                }
                if (!LargeArchiveAndRestoreTest.this.nodeService.exists(parentNodeRef)) {
                    throw new InvalidNodeRefException("Original node was not found after restore: " + parentNodeRef, parentNodeRef);
                }
                return parentNodeRef;
            }
        };
        AuthenticationUtil.RunAsWork<NodeRef> restoreHierarchyWork = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return (NodeRef)LargeArchiveAndRestoreTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(restoreHierarchyCallback);
            }
        };
        NodeRef checkParentNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)restoreHierarchyWork, (String)"System");
        LargeArchiveAndRestoreTest.assertEquals((String)"Restored node reference doesn't match original", (Object)parentNodeRef, (Object)checkParentNodeRef);
        final RetryingTransactionHelper.RetryingTransactionCallback<Object> purgeHierarchyCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                LargeArchiveAndRestoreTest.this.nodeService.addAspect(parentNodeRef, ContentModel.ASPECT_TEMPORARY, null);
                LargeArchiveAndRestoreTest.this.fileFolderService.delete(parentNodeRef);
                NodeRef archivedParentNodeRef = new NodeRef("archive", parentNodeRef.getStoreRef().getIdentifier(), parentNodeRef.getId());
                if (LargeArchiveAndRestoreTest.this.nodeService.exists(archivedParentNodeRef)) {
                    throw new InvalidNodeRefException("Node not purged by delete: " + archivedParentNodeRef, archivedParentNodeRef);
                }
                if (LargeArchiveAndRestoreTest.this.nodeService.exists(parentNodeRef)) {
                    throw new InvalidNodeRefException("Original node was found after purge: " + parentNodeRef, parentNodeRef);
                }
                return null;
            }
        };
        AuthenticationUtil.RunAsWork<Object> purgeHierarchyWork = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                LargeArchiveAndRestoreTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(purgeHierarchyCallback);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)purgeHierarchyWork, (String)"System");
    }

    private class CreateDataCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> {
        private NodeRef parentNodeRef;
        private List<String> rollbackMessages;

        public CreateDataCallback(NodeRef parentNodeRef) {
            this.parentNodeRef = parentNodeRef;
            this.rollbackMessages = new ArrayList<String>(20);
        }

        @Override
        public NodeRef execute() throws Throwable {
            String foldername = String.format("FOLDER-%04d-%04d", 0, 0);
            System.out.println("Creating folder " + foldername + " in parent " + this.parentNodeRef);
            PropertyMap props = new PropertyMap();
            props.put(ContentModel.PROP_NAME, "foldername");
            NodeRef folderNodeRef = LargeArchiveAndRestoreTest.this.nodeService.createNode(this.parentNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
            this.makeFolders(folderNodeRef, 1);
            if (this.rollbackMessages.size() > 0) {
                StringBuilder sb = new StringBuilder(1024);
                sb.append("Errors during create: \n");
                for (String msg : this.rollbackMessages) {
                    sb.append("   ").append(msg);
                }
                throw new RuntimeException(sb.toString());
            }
            return folderNodeRef;
        }

        private void makeFolders(NodeRef parentNodeRef, int depth) {
            if (depth == 3) {
                for (int i = 0; i < 10; ++i) {
                    String filename = String.format("FILE-%04d-%04d", depth, i);
                    this.addFile(parentNodeRef, filename, depth);
                }
            } else {
                int nextDepth = depth + 1;
                for (int i = 0; i < 5; ++i) {
                    String foldername = String.format("FOLDER-%04d-%04d", depth, i);
                    NodeRef folderNodeRef = this.addFolder(parentNodeRef, foldername, depth);
                    this.makeFolders(folderNodeRef, nextDepth);
                }
            }
        }

        private NodeRef addFolder(NodeRef parentNodeRef, String foldername, int depth) {
            System.out.println(this.makeTabs(depth) + "Creating folder " + foldername + " in parent " + parentNodeRef);
            FileInfo info = LargeArchiveAndRestoreTest.this.fileFolderService.create(parentNodeRef, foldername, ContentModel.TYPE_FOLDER);
            String name = info.getName();
            if (!name.equals(foldername)) {
                String msg = "A foldername '" + foldername + "' was not persisted: " + info;
                logger.error((Object)msg);
                this.rollbackMessages.add(msg);
            }
            return info.getNodeRef();
        }

        private NodeRef addFile(NodeRef parentNodeRef, String filename, int depth) {
            System.out.println(this.makeTabs(depth) + "Creating file " + filename + " in parent " + parentNodeRef);
            FileInfo info = LargeArchiveAndRestoreTest.this.fileFolderService.create(parentNodeRef, filename, ContentModel.TYPE_CONTENT);
            String name = info.getName();
            if (!name.equals(filename)) {
                String msg = "A filename '" + filename + "' was not persisted: " + info;
                logger.error((Object)msg);
                this.rollbackMessages.add(msg);
            }
            return info.getNodeRef();
        }

        private String makeTabs(int count) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                sb.append("   ");
            }
            return sb.toString();
        }
    }
}

