/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.cleanup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.db.DeletedNodeCleanupWorker;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.GUID;

public class TransactionCleanupTest {
    private static Log logger = LogFactory.getLog(TransactionCleanupTest.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private SearchService searchService;
    private MutableAuthenticationService authenticationService;
    private NodeDAO nodeDAO;
    private SimpleCache<Serializable, Serializable> nodesCache;
    private DeletedNodeCleanupWorker worker;
    private NodeRef nodeRef1;
    private NodeRef nodeRef2;
    private NodeRef nodeRef3;
    private NodeRef nodeRef4;
    private NodeRef nodeRef5;
    private RetryingTransactionHelper helper;

    @Before
    public void before() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        NamespaceService namespaceService = serviceRegistry.getNamespaceService();
        this.transactionService = serviceRegistry.getTransactionService();
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.nodeService = serviceRegistry.getNodeService();
        this.searchService = serviceRegistry.getSearchService();
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        this.nodesCache = (SimpleCache)ctx.getBean("node.nodesSharedCache");
        this.worker = (DeletedNodeCleanupWorker)ctx.getBean("nodeCleanup.deletedNodeCleanup");
        this.worker.setMinPurgeAgeDays(0);
        this.helper = this.transactionService.getRetryingTransactionHelper();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        NodeRef storeRoot = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRoot, "/app:company_home", null, (NamespacePrefixResolver)namespaceService, false);
        final NodeRef companyHome = (NodeRef)nodeRefs.get(0);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNode = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return TransactionCleanupTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test", (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
            }
        };
        this.nodeRef1 = this.helper.doInTransaction(createNode, false, true);
        this.nodeRef2 = this.helper.doInTransaction(createNode, false, true);
        this.nodeRef3 = this.helper.doInTransaction(createNode, false, true);
        this.nodeRef4 = this.helper.doInTransaction(createNode, false, true);
        this.nodeRef5 = this.helper.doInTransaction(createNode, false, true);
    }

    private Map<NodeRef, List<String>> createTransactions() {
        HashMap<NodeRef, List<String>> txnIds = new HashMap<NodeRef, List<String>>();
        UpdateNode updateNode1 = new UpdateNode(this.nodeRef1);
        UpdateNode updateNode2 = new UpdateNode(this.nodeRef2);
        UpdateNode updateNode3 = new UpdateNode(this.nodeRef3);
        DeleteNode deleteNode4 = new DeleteNode(this.nodeRef4);
        DeleteNode deleteNode5 = new DeleteNode(this.nodeRef5);
        ArrayList<String> txnIds1 = new ArrayList<String>();
        ArrayList<String> txnIds2 = new ArrayList<String>();
        ArrayList<String> txnIds3 = new ArrayList<String>();
        ArrayList<String> txnIds4 = new ArrayList<String>();
        ArrayList<String> txnIds5 = new ArrayList<String>();
        txnIds.put(this.nodeRef1, txnIds1);
        txnIds.put(this.nodeRef2, txnIds2);
        txnIds.put(this.nodeRef3, txnIds3);
        txnIds.put(this.nodeRef4, txnIds4);
        txnIds.put(this.nodeRef5, txnIds5);
        for (int i = 0; i < 10; ++i) {
            String txnId1 = this.helper.doInTransaction(updateNode1, false, true);
            txnIds1.add(txnId1);
            if (i == 0) {
                String txnId2 = this.helper.doInTransaction(updateNode2, false, true);
                txnIds2.add(txnId2);
            }
            if (i != 1) continue;
            String txnId3 = this.helper.doInTransaction(updateNode3, false, true);
            txnIds3.add(txnId3);
        }
        String txnId4 = this.helper.doInTransaction(deleteNode4, false, true);
        txnIds4.add(txnId4);
        String txnId5 = this.helper.doInTransaction(deleteNode5, false, true);
        txnIds5.add(txnId5);
        return txnIds;
    }

    private boolean containsTransaction(List<Transaction> txns, String txnId) {
        boolean found = false;
        for (Transaction tx : txns) {
            if (!tx.getChangeTxnId().equals(txnId)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Test
    public void testPurgeUnusedTransactions() throws Exception {
        this.worker.doClean();
        long start = System.currentTimeMillis();
        Long minTxnId = this.nodeDAO.getMinTxnId();
        Map<NodeRef, List<String>> txnIds = this.createTransactions();
        List<String> txnIds1 = txnIds.get(this.nodeRef1);
        List<String> txnIds2 = txnIds.get(this.nodeRef2);
        List<String> txnIds3 = txnIds.get(this.nodeRef3);
        this.nodesCache.clear();
        Assert.assertNotNull((String)"Node 4 is deleted but not purged", (Object)this.nodeDAO.getNodeRefStatus(this.nodeRef4));
        Assert.assertNotNull((String)"Node 5 is deleted but not purged", (Object)this.nodeDAO.getNodeRefStatus(this.nodeRef5));
        this.worker.setPurgeSize(5);
        List<String> reports = this.worker.doClean();
        for (String report : reports) {
            logger.debug((Object)report);
        }
        List<Transaction> txns = this.nodeDAO.getTxnsByCommitTimeAscending(start, Long.MAX_VALUE, Integer.MAX_VALUE, null, false);
        ArrayList<String> expectedUnusedTxnIds = new ArrayList<String>(10);
        expectedUnusedTxnIds.addAll(txnIds1.subList(0, txnIds1.size() - 1));
        ArrayList<String> expectedUsedTxnIds = new ArrayList<String>(5);
        expectedUsedTxnIds.add(txnIds1.get(txnIds1.size() - 1));
        expectedUsedTxnIds.addAll(txnIds2);
        expectedUsedTxnIds.addAll(txnIds3);
        int numFoundUnusedTxnIds = 0;
        for (String txnId : expectedUnusedTxnIds) {
            if (!this.containsTransaction(txns, txnId)) {
                ++numFoundUnusedTxnIds;
                continue;
            }
            if (!txnIds1.contains(txnId)) continue;
            Assert.fail((String)("Unused transaction(s) were not purged: " + txnId));
        }
        Assert.assertEquals((long)9L, (long)numFoundUnusedTxnIds);
        int numFoundUsedTxnIds = 0;
        for (String txnId : expectedUsedTxnIds) {
            if (!this.containsTransaction(txns, txnId)) continue;
            ++numFoundUsedTxnIds;
        }
        Assert.assertEquals((long)3L, (long)numFoundUsedTxnIds);
        List<Long> txnsUnused = this.nodeDAO.getTxnsUnused(minTxnId, Long.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)txnsUnused.size());
        this.nodesCache.clear();
        Assert.assertNull((String)"Node 4 was not cleaned up", (Object)this.nodeDAO.getNodeRefStatus(this.nodeRef4));
        Assert.assertNull((String)"Node 5 was not cleaned up", (Object)this.nodeDAO.getNodeRefStatus(this.nodeRef5));
    }

    @After
    public void after() {
        ApplicationContextHelper.closeApplicationContext();
    }

    private class DeleteNode
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private NodeRef nodeRef;

        DeleteNode(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        @Override
        public String execute() throws Throwable {
            TransactionCleanupTest.this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY, null);
            TransactionCleanupTest.this.nodeService.deleteNode(this.nodeRef);
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            return txnId;
        }
    }

    private class UpdateNode
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private NodeRef nodeRef;

        UpdateNode(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        @Override
        public String execute() throws Throwable {
            TransactionCleanupTest.this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)GUID.generate()));
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            return txnId;
        }
    }
}

