/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.cleanup.AbstractNodeCleanupWorker;
import org.alfresco.repo.transaction.RetryingTransactionHelper;

public class DeletedNodeCleanupWorker
extends AbstractNodeCleanupWorker {
    private long minPurgeAgeMs = 604800000L;
    private int purgeSize = 0x6DDD00;

    @Override
    protected List<String> doCleanInternal() throws Throwable {
        if (this.minPurgeAgeMs < 0L) {
            return Collections.singletonList("Minimum purge age is negative; purge disabled");
        }
        List<String> purgedNodes = this.purgeOldDeletedNodes(this.minPurgeAgeMs);
        List<String> purgedTxns = this.purgeOldEmptyTransactions(this.minPurgeAgeMs);
        ArrayList<String> allResults = new ArrayList<String>(100);
        allResults.addAll(purgedNodes);
        allResults.addAll(purgedTxns);
        return allResults;
    }

    public void setMinPurgeAgeDays(int minPurgeAgeDays) {
        this.minPurgeAgeMs = (long)minPurgeAgeDays * 24L * 3600L * 1000L;
    }

    public void setPurgeSize(int purgeSize) {
        this.purgeSize = purgeSize;
    }

    private List<String> purgeOldDeletedNodes(long minAge) {
        ArrayList<String> results = new ArrayList<String>(100);
        final long maxCommitTimeMs = System.currentTimeMillis() - minAge;
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> purgeNodesCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                return DeletedNodeCleanupWorker.this.nodeDAO.purgeNodes(maxCommitTimeMs);
            }
        };
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setMaxRetries(5);
        txnHelper.setRetryWaitIncrementMs(1000);
        Integer purgeCount = new Integer(0);
        try {
            purgeCount = txnHelper.doInTransaction(purgeNodesCallback, false, true);
            if (purgeCount > 0) {
                String msg = "Purged old nodes: \n   Max commit time: " + maxCommitTimeMs + "\n" + "   Purge count:     " + purgeCount;
                results.add(msg);
            }
        }
        catch (Throwable e) {
            String msg = "Failed to purge nodes.  If the purgable set is too large for the available DB resources \n  then the nodes can be purged manually as well. \n  Set log level to WARN for this class to get exception log: \n   Max commit time: " + maxCommitTimeMs + "\n" + "   Error:       " + e.getMessage();
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)msg, e);
            } else {
                this.logger.error((Object)msg);
            }
            results.add(msg);
        }
        return results;
    }

    private List<String> purgeOldEmptyTransactions(long minAge) {
        if (minAge < 0L) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(100);
        long maxCommitTime = System.currentTimeMillis() - minAge;
        long fromCommitTime = this.nodeDAO.getMinUnusedTxnCommitTime();
        do {
            this.refreshLock();
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            txnHelper.setMaxRetries(5);
            txnHelper.setRetryWaitIncrementMs(1000);
            long toCommitTime = fromCommitTime + (long)this.purgeSize;
            if (toCommitTime >= maxCommitTime) {
                toCommitTime = maxCommitTime;
            }
            try {
                DeleteTransactionsCallback purgeTxnsCallback = new DeleteTransactionsCallback(this.nodeDAO, fromCommitTime, toCommitTime);
                long purgeCount = txnHelper.doInTransaction(purgeTxnsCallback, false, true);
                if (purgeCount <= 0L) continue;
                String msg = "Purged old txns: \n   From commit time (ms):      " + fromCommitTime + "\n" + "   To commit time (ms):      " + toCommitTime + "\n" + "   Purge count:     " + purgeCount;
                results.add(msg);
            }
            catch (Throwable e) {
                String msg = "Failed to purge txns.  Set log level to WARN for this class to get exception log: \n   From commit time:      " + fromCommitTime + "\n" + "   To commit time (ms):   " + toCommitTime + "\n" + "   Error:       " + e.getMessage();
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)msg, e);
                } else {
                    this.logger.error((Object)msg);
                }
                results.add(msg);
                break;
            }
        } while ((fromCommitTime += (long)this.purgeSize) < maxCommitTime);
        return results;
    }

    private static class DeleteTransactionsCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Long> {
        private NodeDAO nodeDAO;
        private long fromCommitTime;
        private long toCommitTime;

        DeleteTransactionsCallback(NodeDAO nodeDAO, long fromCommitTime, long toCommitTime) {
            this.nodeDAO = nodeDAO;
            this.fromCommitTime = fromCommitTime;
            this.toCommitTime = toCommitTime;
        }

        @Override
        public Long execute() throws Throwable {
            long count = this.nodeDAO.deleteTxnsUnused(this.fromCommitTime, this.toCommitTime);
            return count;
        }
    }
}

