/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.getchildren;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQueryParams;
import org.alfresco.repo.query.AbstractQNameAwareCannedQueryFactory;
import org.alfresco.repo.query.NodeBackedEntity;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetChildrenAuditableCannedQuery
extends AbstractCannedQueryPermissions<NodeBackedEntity> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.auditable";
    private static final String QUERY_SELECT_GET_NODES = "select_GetChildrenAuditableCannedQuery";
    private final CannedQueryDAO cannedQueryDAO;

    public GetChildrenAuditableCannedQuery(CannedQueryDAO cannedQueryDAO, MethodSecurityBean<NodeBackedEntity> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
    }

    protected List<NodeBackedEntity> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object paramBeanObj = parameters.getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Null GetChildrenAuditable query params");
        }
        GetChildrenAuditableCannedQueryParams paramBean = (GetChildrenAuditableCannedQueryParams)paramBeanObj;
        boolean filterByCreator = paramBean.getCreatorFilter() != null;
        boolean filterByModifier = paramBean.getModifierFilter() != null;
        boolean filterByCreatedDate = paramBean.getCreatedBefore() != null && paramBean.getCreatedAfter() != null;
        boolean filterByModifiedDate = paramBean.getModifiedBefore() != null && paramBean.getModifiedAfter() != null;
        List results = this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_NODES, paramBean, 0, Integer.MAX_VALUE);
        ArrayList<NodeBackedEntity> filtered = new ArrayList<NodeBackedEntity>(results.size());
        for (NodeBackedEntity result : results) {
            boolean nextNodeIsAcceptable = true;
            if (filterByCreator || filterByModifier) {
                String creator = result.getCreator();
                String modifier = result.getModifier();
                if (modifier == null) {
                    modifier = creator;
                }
                if (filterByCreator && !paramBean.getCreatorFilter().equals(creator)) {
                    nextNodeIsAcceptable = false;
                }
                if (filterByModifier && !paramBean.getModifierFilter().equals(modifier)) {
                    nextNodeIsAcceptable = false;
                }
            }
            if (filterByCreatedDate || filterByModifiedDate) {
                Date createdDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)result.getCreatedDate());
                Date modifiedDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)result.getModifiedDate());
                if (modifiedDate == null) {
                    modifiedDate = createdDate;
                }
                if (filterByCreatedDate && (createdDate.before(paramBean.getCreatedAfter()) || createdDate.after(paramBean.getCreatedBefore()))) {
                    nextNodeIsAcceptable = false;
                }
                if (filterByModifiedDate && (modifiedDate.before(paramBean.getModifiedAfter()) || modifiedDate.after(paramBean.getModifiedBefore()))) {
                    nextNodeIsAcceptable = false;
                }
            }
            if (!nextNodeIsAcceptable) continue;
            filtered.add(result);
        }
        List sortPairs = parameters.getSortDetails().getSortPairs();
        if (sortPairs != null && !sortPairs.isEmpty()) {
            ArrayList comparators = new ArrayList();
            for (Pair sortPair : sortPairs) {
                QName sortProperty = (QName)sortPair.getFirst();
                AbstractQNameAwareCannedQueryFactory.NodeBackedEntityComparator comparator = new AbstractQNameAwareCannedQueryFactory.NodeBackedEntityComparator(sortProperty);
                comparators.add(new Pair((Object)comparator, sortPair.getSecond()));
            }
            AbstractQNameAwareCannedQueryFactory.NestedComparator comparator = new AbstractQNameAwareCannedQueryFactory.NestedComparator(comparators);
            Collections.sort(filtered, comparator);
        }
        if (start != null) {
            this.logger.debug((Object)("Base query: " + filtered.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return filtered;
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }
}

