/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.getchildren;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.node.ReferenceablePropertiesEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropBoolean;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.node.getchildren.FilterSortNodeEntity;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryParams;
import org.alfresco.repo.security.permissions.PermissionCheckedValue;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetChildrenCannedQuery
extends AbstractCannedQueryPermissions<NodeRef> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.node";
    private static final String QUERY_SELECT_GET_CHILDREN_WITH_PROPS = "select_GetChildrenCannedQueryWithProps";
    private static final String QUERY_SELECT_GET_CHILDREN_WITHOUT_PROPS = "select_GetChildrenCannedQueryWithoutProps";
    public static final int MAX_FILTER_SORT_PROPS = 3;
    public static final QName SORT_QNAME_CONTENT_SIZE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"content.size");
    public static final QName SORT_QNAME_CONTENT_MIMETYPE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"content.mimetype");
    public static final QName SORT_QNAME_NODE_TYPE = QName.createQName((String)"", (String)"TYPE");
    public static final QName SORT_QNAME_NODE_IS_FOLDER = QName.createQName((String)"", (String)"IS_FOLDER");
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private CannedQueryDAO cannedQueryDAO;
    private NodePropertyHelper nodePropertyHelper;
    private TenantService tenantService;
    private boolean applyPostQueryPermissions = false;

    public GetChildrenCannedQuery(NodeDAO nodeDAO, QNameDAO qnameDAO, CannedQueryDAO cannedQueryDAO, NodePropertyHelper nodePropertyHelper, TenantService tenantService, MethodSecurityBean<NodeRef> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        GetChildrenCannedQueryParams paramBean;
        this.nodeDAO = nodeDAO;
        this.qnameDAO = qnameDAO;
        this.cannedQueryDAO = cannedQueryDAO;
        this.nodePropertyHelper = nodePropertyHelper;
        this.tenantService = tenantService;
        if (params.getSortDetails() != null && params.getSortDetails().getSortPairs().size() > 0) {
            this.applyPostQueryPermissions = true;
        }
        if ((paramBean = (GetChildrenCannedQueryParams)params.getParameterBean()).getFilterProps() != null && paramBean.getFilterProps().size() > 0) {
            this.applyPostQueryPermissions = true;
        }
    }

    protected FilterSortChildQueryCallback getFilterSortChildQuery(List<FilterSortNode> children, List<FilterProp> filterProps) {
        DefaultFilterSortChildQueryCallback callback = new DefaultFilterSortChildQueryCallback(children, filterProps);
        return callback;
    }

    protected UnsortedChildQueryCallback getUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount) {
        DefaultUnsortedChildQueryCallback callback = new DefaultUnsortedChildQueryCallback(rawResult, requestedCount);
        return callback;
    }

    protected List<NodeRef> queryAndFilter(CannedQueryParameters parameters) {
        ArrayList<NodeRef> result;
        Set<Long> assocTypeQNameIds;
        Set<Long> childNodeTypeQNameIds;
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetChildrenCannedQueryParams paramBean = (GetChildrenCannedQueryParams)parameters.getParameterBean();
        NodeRef parentRef = paramBean.getParentRef();
        ParameterCheck.mandatory((String)"nodeRef", (Object)parentRef);
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(parentRef);
        if (nodePair == null) {
            throw new InvalidNodeRefException("Parent node does not exist: " + parentRef, parentRef);
        }
        Long parentNodeId = (Long)nodePair.getFirst();
        FilterSortNodeEntity params = new FilterSortNodeEntity();
        params.setParentNodeId(parentNodeId);
        Set<QName> childNodeTypeQNames = paramBean.getChildTypeQNames();
        Set<QName> assocTypeQNames = paramBean.getAssocTypeQNames();
        List<FilterProp> filterProps = paramBean.getFilterProps();
        String pattern = paramBean.getPattern();
        CannedQuerySortDetails sortDetails = parameters.getSortDetails();
        List sortPairs = sortDetails.getSortPairs();
        ArrayList<QName> sortFilterProps = new ArrayList<QName>(filterProps.size() + sortPairs.size());
        for (Pair sort : sortPairs) {
            QName sortQName = (QName)sort.getFirst();
            if (sortFilterProps.contains(sortQName)) continue;
            sortFilterProps.add(sortQName);
        }
        for (FilterProp filter : filterProps) {
            QName filterQName = filter.getPropName();
            if (sortFilterProps.contains(filterQName)) continue;
            sortFilterProps.add(filterQName);
        }
        int filterSortPropCnt = sortFilterProps.size();
        if (filterSortPropCnt > 3) {
            throw new AlfrescoRuntimeException("GetChildren: exceeded maximum number filter/sort properties: (max=3, actual=" + filterSortPropCnt);
        }
        filterSortPropCnt = this.setFilterSortParams(sortFilterProps, params);
        if (childNodeTypeQNames != null && (childNodeTypeQNameIds = this.qnameDAO.convertQNamesToIds(childNodeTypeQNames, false)).size() > 0) {
            params.setChildNodeTypeQNameIds(new ArrayList<Long>(childNodeTypeQNameIds));
        }
        if (assocTypeQNames != null && (assocTypeQNameIds = this.qnameDAO.convertQNamesToIds(assocTypeQNames, false)).size() > 0) {
            params.setAssocTypeQNameIds(assocTypeQNameIds);
        }
        if (pattern != null) {
            Pair<Long, QName> nameQName = this.qnameDAO.getQName(ContentModel.PROP_NAME);
            if (nameQName == null) {
                throw new AlfrescoRuntimeException("Unable to determine qname id of name property");
            }
            params.setNamePropertyQNameId((Long)nameQName.getFirst());
            params.setPattern(pattern);
        }
        if (filterSortPropCnt > 0) {
            ArrayList<FilterSortNode> children = new ArrayList<FilterSortNode>(100);
            FilterSortChildQueryCallback c = this.getFilterSortChildQuery(children, filterProps);
            FilterSortResultHandler resultHandler = new FilterSortResultHandler(c);
            this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_CHILDREN_WITH_PROPS, params, 0, Integer.MAX_VALUE, resultHandler);
            resultHandler.done();
            if (sortPairs.size() > 0) {
                Collections.sort(children, new PropComparatorAsc(sortPairs));
            }
            result = new ArrayList(children.size());
            for (FilterSortNode child : children) {
                result.add(this.tenantService.getBaseName(child.getNodeRef()));
            }
        } else {
            int requestedCount = parameters.getResultsRequired();
            ArrayList<NodeRef> rawResult = new ArrayList<NodeRef>(Math.min(1000, requestedCount));
            UnsortedChildQueryCallback callback = this.getUnsortedChildQueryCallback(rawResult, requestedCount);
            UnsortedResultHandler resultHandler = new UnsortedResultHandler(callback);
            this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_CHILDREN_WITHOUT_PROPS, params, 0, Integer.MAX_VALUE, resultHandler);
            resultHandler.done();
            result = PermissionCheckedValue.PermissionCheckedValueMixin.create(rawResult);
        }
        if (start != null) {
            this.logger.debug((Object)("Base query " + (filterSortPropCnt > 0 ? "(sort=y, perms=n)" : "(sort=n, perms=y)") + ": " + result.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return result;
    }

    private int setFilterSortParams(List<QName> filterSortProps, FilterSortNodeEntity params) {
        int cnt = 0;
        int propCnt = 0;
        for (QName filterSortProp : filterSortProps) {
            if (AuditablePropertiesEntity.getAuditablePropertyQNames().contains(filterSortProp)) {
                params.setAuditableProps(true);
            } else if (filterSortProp.equals((Object)SORT_QNAME_NODE_TYPE) || filterSortProp.equals((Object)SORT_QNAME_NODE_IS_FOLDER)) {
                params.setNodeType(true);
            } else {
                Long sortQNameId = this.getQNameId(filterSortProp);
                if (sortQNameId != null) {
                    if (propCnt == 0) {
                        params.setProp1qnameId(sortQNameId);
                    } else if (propCnt == 1) {
                        params.setProp2qnameId(sortQNameId);
                    } else if (propCnt == 2) {
                        params.setProp3qnameId(sortQNameId);
                    } else {
                        throw new AlfrescoRuntimeException("GetChildren: unexpected - cannot set sort parameter: " + cnt);
                    }
                    ++propCnt;
                } else {
                    this.logger.warn((Object)("Skipping filter/sort param - cannot find: " + filterSortProp));
                    break;
                }
            }
            ++cnt;
        }
        return cnt;
    }

    private Long getQNameId(QName sortPropQName) {
        Pair<Long, QName> qnamePair;
        if (sortPropQName.equals((Object)SORT_QNAME_CONTENT_SIZE) || sortPropQName.equals((Object)SORT_QNAME_CONTENT_MIMETYPE)) {
            sortPropQName = ContentModel.PROP_CONTENT;
        }
        return (qnamePair = this.qnameDAO.getQName(sortPropQName)) == null ? null : (Long)qnamePair.getFirst();
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    private boolean includeFilter(Map<QName, Serializable> propVals, List<FilterProp> filterProps) {
        for (FilterProp filterProp : filterProps) {
            Object filter;
            Object val;
            Serializable propVal = propVals.get(filterProp.getPropName());
            if (propVal != null && filterProp instanceof FilterPropString && propVal instanceof String) {
                val = (String)((Object)propVal);
                filter = (String)((Object)filterProp.getPropVal());
                switch ((FilterPropString.FilterTypeString)filterProp.getFilterType()) {
                    case STARTSWITH: {
                        if (!((String)val).startsWith((String)filter)) break;
                        return true;
                    }
                    case STARTSWITH_IGNORECASE: {
                        if (!((String)val).toLowerCase().startsWith(((String)filter).toLowerCase())) break;
                        return true;
                    }
                    case EQUALS: {
                        if (!((String)val).equals(filter)) break;
                        return true;
                    }
                    case EQUALS_IGNORECASE: {
                        if (!((String)val).equalsIgnoreCase((String)filter)) break;
                        return true;
                    }
                }
            }
            if (!(filterProp instanceof FilterPropBoolean) || !(propVal instanceof Boolean)) continue;
            val = (Boolean)propVal;
            filter = (Boolean)filterProp.getPropVal();
            return val == filter;
        }
        return false;
    }

    @Override
    protected boolean isApplyPostQueryPermissions() {
        return this.applyPostQueryPermissions;
    }

    @Override
    protected List<NodeRef> applyPostQueryPermissions(List<NodeRef> results, int requestedCount) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        int requestTotalCountMax = this.getParameters().getTotalResultCountMax();
        int maxChecks = requestTotalCountMax > 0 && requestTotalCountMax > requestedCount ? requestTotalCountMax : requestedCount;
        int cnt = results.size();
        int toIdx = maxChecks > cnt ? cnt : maxChecks;
        this.preload(results.subList(0, toIdx));
        List<NodeRef> ret = super.applyPostQueryPermissions(results, requestedCount);
        if (start != null) {
            this.logger.debug((Object)("Post-query perms: " + ret.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return ret;
    }

    private void preload(List<NodeRef> nodeRefs) {
        Long start = this.logger.isTraceEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        this.nodeDAO.cacheNodes(nodeRefs);
        if (start != null) {
            this.logger.trace((Object)("Pre-load: " + nodeRefs.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
    }

    private class UnsortedResultHandler
    implements CannedQueryDAO.ResultHandler<NodeEntity> {
        private final UnsortedChildQueryCallback resultsCallback;
        private boolean more = true;
        private static final int BATCH_SIZE = 1024;
        private final List<NodeRef> nodeRefs;

        private UnsortedResultHandler(UnsortedChildQueryCallback resultsCallback) {
            this.resultsCallback = resultsCallback;
            this.nodeRefs = new LinkedList<NodeRef>();
        }

        @Override
        public boolean handleResult(NodeEntity result) {
            if (!this.more) {
                return false;
            }
            NodeRef nodeRef = result.getNodeRef();
            if (this.nodeRefs.size() >= 1024) {
                this.preloadAndApplyPermissions();
            }
            this.nodeRefs.add(nodeRef);
            return this.more;
        }

        private void preloadAndApplyPermissions() {
            GetChildrenCannedQuery.this.preload(this.nodeRefs);
            List<NodeRef> results = GetChildrenCannedQuery.this.applyPostQueryPermissions(this.nodeRefs, this.nodeRefs.size());
            for (NodeRef nodeRef : results) {
                boolean more = this.resultsCallback.handle(nodeRef);
                if (more) continue;
                this.more = false;
                break;
            }
            this.nodeRefs.clear();
        }

        public void done() {
            if (this.nodeRefs.size() >= 0) {
                this.preloadAndApplyPermissions();
            }
        }
    }

    protected class FilterSortNode {
        private NodeRef nodeRef;
        private Map<QName, Serializable> propVals;

        public FilterSortNode(NodeRef nodeRef, Map<QName, Serializable> propVals) {
            this.nodeRef = nodeRef;
            this.propVals = propVals;
        }

        public String toString() {
            return "FilterSortNode [nodeRef=" + this.nodeRef + ", propVals=" + this.propVals + "]";
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public Serializable getVal(QName prop) {
            return this.propVals.get(prop);
        }

        public Map<QName, Serializable> getPropVals() {
            return this.propVals;
        }
    }

    protected class FilterSortResultHandler
    implements CannedQueryDAO.ResultHandler<FilterSortNodeEntity> {
        private final FilterSortChildQueryCallback resultsCallback;
        private boolean more = true;

        private FilterSortResultHandler(FilterSortChildQueryCallback resultsCallback) {
            this.resultsCallback = resultsCallback;
        }

        @Override
        public boolean handleResult(FilterSortNodeEntity result) {
            boolean more;
            Pair<Long, QName> pair;
            Long nodeTypeQNameId;
            AuditablePropertiesEntity auditableProps;
            NodePropertyEntity prop3;
            NodePropertyEntity prop2;
            if (!this.more) {
                return false;
            }
            NodeEntity node = result.getNode();
            NodeRef nodeRef = node.getNodeRef();
            HashMap<NodePropertyKey, NodePropertyValue> propertyValues = new HashMap<NodePropertyKey, NodePropertyValue>(3);
            NodePropertyEntity prop1 = result.getProp1();
            if (prop1 != null) {
                propertyValues.put(prop1.getKey(), prop1.getValue());
            }
            if ((prop2 = result.getProp2()) != null) {
                propertyValues.put(prop2.getKey(), prop2.getValue());
            }
            if ((prop3 = result.getProp3()) != null) {
                propertyValues.put(prop3.getKey(), prop3.getValue());
            }
            Map<QName, Serializable> propVals = GetChildrenCannedQuery.this.nodePropertyHelper.convertToPublicProperties(propertyValues);
            ReferenceablePropertiesEntity.addReferenceableProperties(node, propVals);
            for (Map.Entry<QName, Serializable> entry : propVals.entrySet()) {
                if (!(entry.getValue() instanceof MLText)) continue;
                propVals.put(entry.getKey(), (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)((MLText)entry.getValue())));
            }
            ContentData contentData = (ContentData)propVals.get(ContentModel.PROP_CONTENT);
            if (contentData != null) {
                propVals.put(SORT_QNAME_CONTENT_SIZE, Long.valueOf(contentData.getSize()));
                propVals.put(SORT_QNAME_CONTENT_MIMETYPE, (Serializable)((Object)contentData.getMimetype()));
            }
            if ((auditableProps = node.getAuditableProperties()) != null) {
                for (Map.Entry<QName, Serializable> entry : auditableProps.getAuditableProperties().entrySet()) {
                    propVals.put(entry.getKey(), entry.getValue());
                }
            }
            if ((nodeTypeQNameId = node.getTypeQNameId()) != null && (pair = GetChildrenCannedQuery.this.qnameDAO.getQName(nodeTypeQNameId)) != null) {
                propVals.put(SORT_QNAME_NODE_TYPE, (Serializable)pair.getSecond());
            }
            if (!(more = this.resultsCallback.handle(new FilterSortNode(nodeRef, propVals)))) {
                this.more = false;
            }
            return more;
        }

        public void done() {
        }
    }

    protected static interface UnsortedChildQueryCallback {
        public boolean handle(NodeRef var1);
    }

    protected class DefaultUnsortedChildQueryCallback
    implements UnsortedChildQueryCallback {
        private List<NodeRef> rawResult;
        private int requestedCount;

        public DefaultUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount) {
            this.rawResult = rawResult;
            this.requestedCount = requestedCount;
        }

        @Override
        public boolean handle(NodeRef nodeRef) {
            if (this.include(nodeRef)) {
                this.rawResult.add(GetChildrenCannedQuery.this.tenantService.getBaseName(nodeRef));
            }
            return this.rawResult.size() < this.requestedCount;
        }

        protected boolean include(NodeRef nodeRef) {
            return true;
        }
    }

    protected class DefaultFilterSortChildQueryCallback
    implements FilterSortChildQueryCallback {
        private List<FilterSortNode> children;
        private List<FilterProp> filterProps;
        private boolean applyFilter;

        public DefaultFilterSortChildQueryCallback(List<FilterSortNode> children, List<FilterProp> filterProps) {
            this.children = children;
            this.filterProps = filterProps;
            this.applyFilter = filterProps.size() > 0;
        }

        @Override
        public boolean handle(FilterSortNode node) {
            if (this.include(node)) {
                this.children.add(node);
            }
            return true;
        }

        protected boolean include(FilterSortNode node) {
            return !this.applyFilter || GetChildrenCannedQuery.this.includeFilter(node.getPropVals(), this.filterProps);
        }
    }

    protected static interface FilterSortChildQueryCallback {
        public boolean handle(FilterSortNode var1);
    }

    private class PropComparatorAsc
    implements Comparator<FilterSortNode> {
        private List<Pair<QName, CannedQuerySortDetails.SortOrder>> sortProps;
        private Collator collator;

        public PropComparatorAsc(List<Pair<QName, CannedQuerySortDetails.SortOrder>> sortProps) {
            this.sortProps = sortProps;
            this.collator = Collator.getInstance();
        }

        @Override
        public int compare(FilterSortNode n1, FilterSortNode n2) {
            return this.compareImpl(n1, n2, this.sortProps);
        }

        private int compareImpl(FilterSortNode node1In, FilterSortNode node2In, List<Pair<QName, CannedQuerySortDetails.SortOrder>> sortProps) {
            Serializable pv1 = null;
            Serializable pv2 = null;
            QName sortPropQName = (QName)sortProps.get(0).getFirst();
            boolean sortAscending = sortProps.get(0).getSecond() == CannedQuerySortDetails.SortOrder.ASCENDING;
            FilterSortNode node1 = node1In;
            FilterSortNode node2 = node2In;
            if (!sortAscending) {
                node1 = node2In;
                node2 = node1In;
            }
            int result = 0;
            pv1 = node1.getVal(sortPropQName);
            pv2 = node2.getVal(sortPropQName);
            if (pv1 == null) {
                return pv2 == null ? 0 : -1;
            }
            if (pv2 == null) {
                return 1;
            }
            if (pv1 instanceof String) {
                result = this.collator.compare((String)((Object)pv1), (String)((Object)pv2));
            } else if (pv1 instanceof Date) {
                result = ((Date)pv1).compareTo((Date)pv2);
            } else if (pv1 instanceof Long) {
                result = ((Long)pv1).compareTo((Long)pv2);
            } else if (pv1 instanceof Integer) {
                result = ((Integer)pv1).compareTo((Integer)pv2);
            } else if (pv1 instanceof QName) {
                result = ((QName)pv1).compareTo((QName)pv2);
            } else if (pv1 instanceof Boolean) {
                result = ((Boolean)pv1).compareTo((Boolean)pv2);
            } else {
                throw new RuntimeException("Unsupported sort type: " + pv1.getClass().getName());
            }
            if (result == 0 && sortProps.size() > 1) {
                return this.compareImpl(node1In, node2In, sortProps.subList(1, sortProps.size()));
            }
            return result;
        }
    }
}

