/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.nodelocator;

import javax.annotation.Resource;
import junit.framework.Assert;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.nodelocator.NodeLocatorService;
import org.alfresco.repo.site.SiteServiceInternal;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:alfresco/node-locator-context.xml", "classpath:test-nodeLocatorServiceImpl-context.xml"})
public class NodeLocatorServiceImplTest {
    private static final NodeRef companyHome = new NodeRef("alfresco://company/home");
    private static final NodeRef sitesHome = new NodeRef("alfresco://sites/home");
    @Resource
    private NodeLocatorService nodeLocatorService;
    @Autowired
    private Repository repositoryHelper;
    @Autowired
    private SiteServiceInternal siteService;

    @Test
    public void testUnknownNodeLocator() throws Exception {
        try {
            this.nodeLocatorService.getNode(null, null, null);
            Assert.fail((String)"An exception should have been thrown!");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.nodeLocatorService.getNode("some unknown name", null, null);
            Assert.fail((String)"An exception should have been thrown!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCompanyHomeNodeLocator() throws Exception {
        NodeRef result = this.nodeLocatorService.getNode("companyhome", null, null);
        Assert.assertEquals((Object)companyHome, (Object)result);
    }

    @Test
    public void testSitesHomeNodeLocator() throws Exception {
        NodeRef result = this.nodeLocatorService.getNode("siteshome", null, null);
        Assert.assertEquals((Object)sitesHome, (Object)result);
    }

    @Before
    public void setUpClass() {
        Mockito.when((Object)this.repositoryHelper.getCompanyHome()).thenReturn((Object)companyHome);
        Mockito.when((Object)this.siteService.getSiteRoot()).thenReturn((Object)sitesHome);
    }
}

