/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.oauth1;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.oauth1.OAuth1CredentialsStoreService;
import org.alfresco.service.cmr.remotecredentials.OAuth1CredentialsInfo;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.context.ApplicationContext;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OAuth1CredentialsStoreServiceTest {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static OAuth1CredentialsStoreService oauth1CredentialsStoreService;
    private static ServiceRegistry serviceRegistry;
    private static RetryingTransactionHelper transactionHelper;
    private static MutableAuthenticationService authenticationService;
    private static PersonService personService;
    private static String RemoteSystemId;
    private static String Token;
    private static String Secret;
    private static String UpdatedToken;
    private static String UpdatedSecret;
    private static String TEST_USER_ONE;
    private static String TEST_USER_TWO;
    private static final String ADMIN_USER;

    @BeforeClass
    public static void setUp() throws Exception {
        serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        transactionHelper = serviceRegistry.getRetryingTransactionHelper();
        authenticationService = serviceRegistry.getAuthenticationService();
        personService = serviceRegistry.getPersonService();
        oauth1CredentialsStoreService = (OAuth1CredentialsStoreService)ctx.getBean("oauth1CredentialsStoreService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        OAuth1CredentialsStoreServiceTest.createUser(TEST_USER_ONE);
        OAuth1CredentialsStoreServiceTest.createUser(TEST_USER_TWO);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        OAuth1CredentialsStoreServiceTest.deleteUser(TEST_USER_ONE);
        OAuth1CredentialsStoreServiceTest.deleteUser(TEST_USER_TWO);
    }

    @Test
    public void test1StorePersonalOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        oauth1CredentialsStoreService.storePersonalOAuth1Credentials(RemoteSystemId, Token, Secret);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = oauth1CredentialsStoreService.getPersonalOAuth1Credentials(RemoteSystemId);
        Assert.assertEquals((String)"Expect that access tokens will match", (Object)Token, (Object)oAuth1CredentialsInfo.getOAuthToken());
        Assert.assertEquals((String)"Expect the refresh token will match", (Object)Secret, (Object)oAuth1CredentialsInfo.getOAuthSecret());
        oauth1CredentialsStoreService.storePersonalOAuth1Credentials(RemoteSystemId, UpdatedToken, UpdatedSecret);
        OAuth1CredentialsInfo _oAuth1CredentialsInfo = oauth1CredentialsStoreService.getPersonalOAuth1Credentials(RemoteSystemId);
        Assert.assertEquals((String)"Expect that access tokens will match", (Object)UpdatedToken, (Object)_oAuth1CredentialsInfo.getOAuthToken());
        Assert.assertEquals((String)"Expect the refresh token will match", (Object)UpdatedSecret, (Object)_oAuth1CredentialsInfo.getOAuthSecret());
    }

    @Test
    public void test2StoreSharedOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        oauth1CredentialsStoreService.storeSharedOAuth1Credentials(RemoteSystemId, Token, Secret);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List<OAuth1CredentialsInfo> sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = sharedCredentials.get(0);
        Assert.assertEquals((String)"Expect that access tokens will match", (Object)Token, (Object)oAuth1CredentialsInfo.getOAuthToken());
        Assert.assertEquals((String)"Expect the refresh token will match", (Object)Secret, (Object)oAuth1CredentialsInfo.getOAuthSecret());
    }

    @Test(expected=AccessDeniedException.class)
    public void test3SecureUpdateSharedOAuth1CredentialsTestUpdateSharedOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List<OAuth1CredentialsInfo> sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = sharedCredentials.get(0);
        oauth1CredentialsStoreService.updateSharedOAuth1Credentials(oAuth1CredentialsInfo, RemoteSystemId, UpdatedToken, UpdatedSecret);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        oAuth1CredentialsInfo = sharedCredentials.get(0);
        OAuth1CredentialsInfo _oAuth1CredentialsInfo = oauth1CredentialsStoreService.updateSharedOAuth1Credentials(oAuth1CredentialsInfo, RemoteSystemId, UpdatedToken, UpdatedSecret);
        Assert.assertEquals((String)"Expect that access tokens will match", (Object)UpdatedToken, (Object)_oAuth1CredentialsInfo.getOAuthToken());
        Assert.assertEquals((String)"Expect the refresh token will match", (Object)UpdatedSecret, (Object)_oAuth1CredentialsInfo.getOAuthSecret());
    }

    @Test
    public void test4DeletePesonalOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        boolean deleted = oauth1CredentialsStoreService.deletePersonalOAuth1Credentials(RemoteSystemId);
        Assert.assertTrue((boolean)deleted);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        boolean _deleted = oauth1CredentialsStoreService.deletePersonalOAuth1Credentials(RemoteSystemId);
        Assert.assertFalse((boolean)_deleted);
    }

    @Test(expected=AccessDeniedException.class)
    public void test5SecureDeleteSharedOAuth1CredentialsTestDeleteSharedOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List<OAuth1CredentialsInfo> sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = sharedCredentials.get(0);
        oauth1CredentialsStoreService.deleteSharedOAuth1Credentials(RemoteSystemId, oAuth1CredentialsInfo);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        oAuth1CredentialsInfo = sharedCredentials.get(0);
        boolean deleted = oauth1CredentialsStoreService.deleteSharedOAuth1Credentials(RemoteSystemId, oAuth1CredentialsInfo);
        Assert.assertTrue((boolean)deleted);
    }

    private static void createUser(final String userName) {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (!authenticationService.authenticationExists(userName)) {
                    authenticationService.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!personService.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put(ContentModel.PROP_USERNAME, userName);
                    ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
                    ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
                    ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
                    ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
                    personService.createPerson(ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (personService.personExists(userName)) {
                    personService.deletePerson(userName);
                }
                return null;
            }
        });
    }

    static {
        RemoteSystemId = "Test-OAuth1RemoteSystem";
        Token = "123456789ABC";
        Secret = "CBA987654321";
        UpdatedToken = "abcdefghi123";
        UpdatedSecret = "321ihgfedcba";
        TEST_USER_ONE = OAuth1CredentialsStoreService.class.getSimpleName() + "testuser1";
        TEST_USER_TWO = OAuth1CredentialsStoreService.class.getSimpleName() + "testuser2";
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
    }
}

