/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.preference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.preference.UnauthorizedAccessException;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.json.JSONException;
import org.json.JSONObject;

public class PreferenceServiceImpl
implements PreferenceService {
    private NodeService nodeService;
    private ContentService contentService;
    private PersonService personService;
    private PermissionService permissionService;
    private AuthenticationContext authenticationContext;
    private AuthorityService authorityService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    public Map<String, Serializable> getPreferences(String userName) {
        return this.getPreferences(userName, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, Serializable> getPreferences(String userName, String preferenceFilter) {
        HashMap<String, Serializable> preferences = new HashMap<String, Serializable>(20);
        NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Could not get preferences for " + userName + " because they do not exist.");
        }
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!userName.equals(currentUserName) && !this.personService.getUserIdentifier(userName).equals(this.personService.getUserIdentifier(currentUserName)) && !this.authenticationContext.isSystemUserName(currentUserName) && !this.authorityService.isAdminAuthority(currentUserName)) throw new UnauthorizedAccessException("The current user " + currentUserName + " does not have sufficient permissions to get the preferences of the user " + userName);
        try {
            if (!this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES)) return preferences;
            JSONObject jsonPrefs = new JSONObject();
            ContentReader reader = this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
            if (reader != null) {
                jsonPrefs = new JSONObject(reader.getContentString());
            }
            Iterator keys = jsonPrefs.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (preferenceFilter != null && preferenceFilter.length() != 0 && !this.matchPreferenceNames(key, preferenceFilter)) continue;
                preferences.put(key, (Serializable)jsonPrefs.get(key));
            }
            return preferences;
        }
        catch (JSONException exception) {
            throw new AlfrescoRuntimeException("Can not get preferences for " + userName + " because there was an error pasing the JSON data.", (Throwable)exception);
        }
    }

    private boolean matchPreferenceNames(String name, String matchTo) {
        boolean result = true;
        name = name.replace(".", "+");
        String[] nameArr = name.split("\\+");
        matchTo = matchTo.replace(".", "+");
        String[] matchToArr = matchTo.split("\\+");
        int index = 0;
        for (String matchToElement : matchToArr) {
            if (!matchToElement.equals(nameArr[index])) {
                result = false;
                break;
            }
            ++index;
        }
        return result;
    }

    @Override
    public void setPreferences(final String userName, final Map<String, Serializable> preferences) {
        final NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Could not update preferences for " + userName + " because they do not exist.");
        }
        if (!this.userCanWritePreferences(userName, personNodeRef)) {
            throw new UnauthorizedAccessException("The current user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have sufficient permissions to update the preferences of the user " + userName);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!PreferenceServiceImpl.this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES)) {
                    PreferenceServiceImpl.this.nodeService.addAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES, null);
                }
                try {
                    JSONObject jsonPrefs = new JSONObject();
                    ContentReader reader = PreferenceServiceImpl.this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
                    if (reader != null) {
                        jsonPrefs = new JSONObject(reader.getContentString());
                    }
                    for (Map.Entry entry : preferences.entrySet()) {
                        jsonPrefs.put((String)entry.getKey(), entry.getValue());
                    }
                    ContentWriter contentWriter = PreferenceServiceImpl.this.contentService.getWriter(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES, true);
                    contentWriter.setEncoding("UTF-8");
                    contentWriter.setMimetype("text/plain");
                    contentWriter.putContent(jsonPrefs.toString());
                }
                catch (JSONException exception) {
                    throw new AlfrescoRuntimeException("Can not update preferences for " + userName + " because there was an error pasing the JSON data.", (Throwable)exception);
                }
                return null;
            }
        }, (String)"System");
    }

    @Override
    public void clearPreferences(String userName) {
        this.clearPreferences(userName, null);
    }

    @Override
    public void clearPreferences(final String userName, final String preferenceFilter) {
        final NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Could not update preferences for " + userName + " because they do not exist.");
        }
        if (!this.userCanWritePreferences(userName, personNodeRef)) {
            throw new UnauthorizedAccessException("The current user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have sufficient permissions to update the preferences of the user " + userName);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (PreferenceServiceImpl.this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES)) {
                    try {
                        JSONObject jsonPrefs = new JSONObject();
                        if (preferenceFilter != null && preferenceFilter.length() != 0) {
                            ContentReader reader = PreferenceServiceImpl.this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
                            if (reader != null) {
                                jsonPrefs = new JSONObject(reader.getContentString());
                            }
                            ArrayList<String> removeKeys = new ArrayList<String>(10);
                            Iterator keys = jsonPrefs.keys();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                if (preferenceFilter != null && preferenceFilter.length() != 0 && !PreferenceServiceImpl.this.matchPreferenceNames(key, preferenceFilter)) continue;
                                removeKeys.add(key);
                            }
                            for (String removeKey : removeKeys) {
                                jsonPrefs.remove(removeKey);
                            }
                        }
                        ContentWriter contentWriter = PreferenceServiceImpl.this.contentService.getWriter(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES, true);
                        contentWriter.setEncoding("UTF-8");
                        contentWriter.setMimetype("text/plain");
                        contentWriter.putContent(jsonPrefs.toString());
                    }
                    catch (JSONException exception) {
                        throw new AlfrescoRuntimeException("Can not update preferences for " + userName + " because there was an error pasing the JSON data.", (Throwable)exception);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    private boolean userCanWritePreferences(String userName, NodeRef personNodeRef) {
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        return userName.equals(currentUserName) || this.personService.getUserIdentifier(userName).equals(this.personService.getUserIdentifier(currentUserName)) || this.authenticationContext.isSystemUserName(currentUserName) || this.permissionService.hasPermission(personNodeRef, "Write") == AccessStatus.ALLOWED;
    }
}

