/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.AbstractPublishingIntegrationTest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ChannelServiceImplIntegratedTest
extends AbstractPublishingIntegrationTest {
    private static final String channelName = GUID.generate();
    private ChannelService channelService;

    @Test
    public void testCreateChannel() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        Channel channel = this.createChannel();
        ChannelServiceImplIntegratedTest.assertEquals((String)"MockChannelType", (String)channel.getChannelType().getId());
        ChannelServiceImplIntegratedTest.assertNotNull((String)channelName, (Object)channel.getName());
        NodeRef channelNode = new NodeRef(channel.getId());
        ChannelServiceImplIntegratedTest.assertTrue((boolean)this.nodeService.exists(channelNode));
    }

    @Test
    public void testDeleteChannel() throws Exception {
        Channel channel = this.createChannel();
        ChannelServiceImplIntegratedTest.assertNotNull((String)("The channel should exist! Id: " + channel.getId()), (Object)this.channelService.getChannelById(channel.getId()));
        ChannelServiceImplIntegratedTest.assertNotNull((String)("The channel should exist! Name: " + channelName), (Object)this.channelService.getChannelByName(channelName));
        this.personManager.setUser(this.username);
        try {
            this.channelService.deleteChannel(channel);
            ChannelServiceImplIntegratedTest.fail((String)"Only Admin users should be able to delete channels.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.channelService.deleteChannel(channel);
        ChannelServiceImplIntegratedTest.assertNull((String)("The channel should have been deleed! Id: " + channel.getId()), (Object)this.channelService.getChannelById(channel.getId()));
        ChannelServiceImplIntegratedTest.assertNull((String)("The channel should have been deleed! Name: " + channelName), (Object)this.channelService.getChannelByName(channelName));
    }

    @Test
    public void testRenameChannel() throws Exception {
        String newChannelName = "New Channel Name";
        Channel channel = this.createChannel();
        this.personManager.setUser(this.username);
        try {
            this.channelService.renameChannel(channel, newChannelName);
            ChannelServiceImplIntegratedTest.fail((String)"Only Admin user can rename Channel.");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.channelService.renameChannel(channel, newChannelName);
        Channel renamedChannel = this.channelService.getChannelById(channel.getId());
        ChannelServiceImplIntegratedTest.assertNotNull((Object)renamedChannel);
        ChannelServiceImplIntegratedTest.assertEquals((String)newChannelName, (String)renamedChannel.getName());
        ChannelServiceImplIntegratedTest.assertNotNull((Object)this.channelService.getChannelByName(newChannelName));
        ChannelServiceImplIntegratedTest.assertNotNull((Object)this.channelService.getChannelById(channel.getId()));
        ChannelServiceImplIntegratedTest.assertNull((Object)this.channelService.getChannelByName(channelName));
    }

    @Test
    public void testUpdateChannel() throws Exception {
        String newTitle = "This is my title";
        Channel channel = this.createChannel();
        Map<QName, Serializable> props = channel.getProperties();
        ChannelServiceImplIntegratedTest.assertNull((Object)props.get(ContentModel.PROP_TITLE));
        props.put(ContentModel.PROP_TITLE, (Serializable)((Object)newTitle));
        this.personManager.setUser(this.username);
        try {
            this.channelService.updateChannel(channel, props);
            ChannelServiceImplIntegratedTest.fail((String)"Only Admin user can rename Channel.");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.channelService.updateChannel(channel, props);
        Channel updatedChannel = this.channelService.getChannelById(channel.getId());
        Serializable title = updatedChannel.getProperties().get(ContentModel.PROP_TITLE);
        ChannelServiceImplIntegratedTest.assertNotNull((Object)title);
        ChannelServiceImplIntegratedTest.assertEquals((Object)newTitle, (Object)title);
    }

    @Test
    public void testGetChannels() throws Exception {
        int startingSize = this.channelService.getChannels().size();
        int channelCount = 7;
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < channelCount; ++i) {
            Channel newChannel = this.testHelper.createChannel("MockChannelType");
            ids.add(newChannel.getId());
            List<Channel> channels = this.channelService.getChannels();
            ChannelServiceImplIntegratedTest.assertEquals((int)(i + 1 + startingSize), (int)channels.size());
            HashSet idsToCheck = new HashSet(ids);
            for (Channel channel : channels) {
                idsToCheck.remove(channel.getId());
            }
            ChannelServiceImplIntegratedTest.assertTrue((boolean)idsToCheck.isEmpty());
        }
    }

    @Test
    public void testGetChannelsPermissions() throws Exception {
        AbstractChannelType publishType = this.testHelper.mockChannelType(GUID.generate());
        Mockito.when((Object)publishType.canPublish()).thenReturn((Object)true);
        AbstractChannelType statusType = this.testHelper.mockChannelType(GUID.generate());
        Mockito.when((Object)statusType.canPublishStatusUpdates()).thenReturn((Object)true);
        Channel publishChannel = this.testHelper.createChannel(publishType.getId());
        Channel statusChannel = this.testHelper.createChannel(statusType.getId());
        String user1 = GUID.generate();
        this.personManager.createPerson(user1);
        this.personManager.setUser(user1);
        Channel channelById = this.channelService.getChannelById(publishChannel.getId());
        ChannelServiceImplIntegratedTest.assertNotNull((String)"User1 should have access to the channel!", (Object)channelById);
        List<Channel> channels = this.channelService.getChannels();
        ChannelServiceImplIntegratedTest.assertTrue((String)"Result of getChannels() should contain the channel!", (boolean)this.checkContainsChannel(channels, publishChannel.getId(), statusChannel.getId()));
        channels = this.channelService.getPublishingChannels(false);
        ChannelServiceImplIntegratedTest.assertTrue((String)"User1 should have access to unfiltered publishing channels", (boolean)this.checkContainsChannel(channels, publishChannel.getId()));
        channels = this.channelService.getStatusUpdateChannels(false);
        ChannelServiceImplIntegratedTest.assertTrue((String)"User1 should have access to unfiltered status update channels", (boolean)this.checkContainsChannel(channels, statusChannel.getId()));
        channels = this.channelService.getPublishingChannels(true);
        ChannelServiceImplIntegratedTest.assertFalse((String)"User1 should not have access to filtered publishing channels", (boolean)this.checkContainsChannel(channels, publishChannel.getId()));
        channels = this.channelService.getStatusUpdateChannels(true);
        ChannelServiceImplIntegratedTest.assertFalse((String)"User1 should not have access to filtered status update channels", (boolean)this.checkContainsChannel(channels, statusChannel.getId()));
        this.testHelper.setChannelPermission(user1, publishChannel.getId(), "Read");
        this.testHelper.setChannelPermission(user1, statusChannel.getId(), "Read");
        channels = this.channelService.getPublishingChannels(true);
        ChannelServiceImplIntegratedTest.assertFalse((String)"User1 should not have access to filtered publishing channels", (boolean)this.checkContainsChannel(channels, publishChannel.getId()));
        channels = this.channelService.getStatusUpdateChannels(true);
        ChannelServiceImplIntegratedTest.assertFalse((String)"User1 should not have access to filtered status update channels", (boolean)this.checkContainsChannel(channels, statusChannel.getId()));
        this.testHelper.setChannelPermission(user1, publishChannel.getId(), "AddChildren");
        this.testHelper.setChannelPermission(user1, statusChannel.getId(), "AddChildren");
        channels = this.channelService.getPublishingChannels(true);
        ChannelServiceImplIntegratedTest.assertTrue((String)"User1 should have access to filtered publishing channels", (boolean)this.checkContainsChannel(channels, publishChannel.getId()));
        channels = this.channelService.getStatusUpdateChannels(true);
        ChannelServiceImplIntegratedTest.assertTrue((String)"User1 should have access to filtered status update channels", (boolean)this.checkContainsChannel(channels, statusChannel.getId()));
    }

    @Test
    public void testGetChannelByName() throws Exception {
        Channel channel = this.channelService.getChannelById(null);
        ChannelServiceImplIntegratedTest.assertNull((String)"Should return null if unknown channelName", (Object)channel);
        channel = this.channelService.getChannelByName(channelName);
        ChannelServiceImplIntegratedTest.assertNull((String)"Should return null if null channelName", (Object)channel);
        Channel createdChannel = this.createChannel();
        channel = this.channelService.getChannelByName(channelName);
        ChannelServiceImplIntegratedTest.assertNotNull((String)"Should return created channel!", (Object)channel);
        ChannelServiceImplIntegratedTest.assertEquals((String)channelName, (String)channel.getName());
        ChannelServiceImplIntegratedTest.assertEquals((String)createdChannel.getChannelType().getId(), (String)channel.getChannelType().getId());
        ChannelServiceImplIntegratedTest.assertEquals((String)createdChannel.getId(), (String)channel.getId());
    }

    @Test
    public void testGetChannelById() throws Exception {
        Channel channel = this.channelService.getChannelById(null);
        ChannelServiceImplIntegratedTest.assertNull((String)"Should return null if null channelId", (Object)channel);
        channel = this.channelService.getChannelById("test://channel/id");
        ChannelServiceImplIntegratedTest.assertNull((String)"Should return null if unknown channelId", (Object)channel);
        Channel createdChannel = this.createChannel();
        channel = this.channelService.getChannelById(createdChannel.getId());
        ChannelServiceImplIntegratedTest.assertNotNull((String)"Should return created channel!", (Object)channel);
        ChannelServiceImplIntegratedTest.assertEquals((String)createdChannel.getId(), (String)channel.getId());
        ChannelServiceImplIntegratedTest.assertEquals((String)channelName, (String)channel.getName());
        ChannelServiceImplIntegratedTest.assertEquals((String)createdChannel.getChannelType().getId(), (String)channel.getChannelType().getId());
    }

    private boolean checkContainsChannel(List<Channel> channels, String ... ids) {
        ArrayList<String> remainingIds = new ArrayList<String>(Arrays.asList(ids));
        for (Channel channel : channels) {
            remainingIds.remove(channel.getId());
            if (!remainingIds.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Channel createChannel() {
        return this.testHelper.createChannel("MockChannelType", channelName);
    }

    @Override
    @Before
    public void onSetUp() throws Exception {
        super.onSetUp();
        this.channelService = (ChannelService)this.getApplicationContext().getBean("ChannelService");
        this.testHelper.mockChannelType("MockChannelType");
    }
}

