/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.AbstractPublishingIntegrationTest;
import org.alfresco.repo.publishing.ChannelHelper;
import org.alfresco.repo.publishing.PublishEventAction;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishEventActionTest
extends AbstractPublishingIntegrationTest {
    private static final String contentNodeName = "TheName";
    private static final String content = "The quick brown fox jumped over the lazy dog";
    @Resource(name="publishingService")
    private PublishingService publishingService;
    @Resource(name="contentService")
    private ContentService contentService;
    @Autowired
    private ChannelHelper channelHelper;
    @Autowired
    private PublishEventAction action;
    private Channel channel;
    private NodeRef channelNode;
    private AbstractChannelType channelType;

    @Test
    public void testPublishNodes() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        double lattitude = 0.25;
        double longtitude = 0.75;
        this.addGeographicAspect(source, lattitude, longtitude);
        this.nodeService.addAspect(source, ContentModel.ASPECT_TEMPORARY, null);
        NodeRef publishEventNode = this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertNotNull((Object)publishedNode);
        PublishEventActionTest.assertTrue((boolean)this.nodeService.exists(publishedNode));
        PublishEventActionTest.assertEquals((Object)this.channelNode, (Object)this.nodeService.getPrimaryParent(publishedNode).getParentRef());
        PublishEventActionTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(publishedNode));
        Set sourceAspects = this.nodeService.getAspects(source);
        Set publishedAspects = this.nodeService.getAspects(publishedNode);
        PublishEventActionTest.assertTrue((boolean)publishedAspects.containsAll(sourceAspects));
        PublishEventActionTest.assertTrue((boolean)publishedAspects.contains(ContentModel.ASPECT_GEOGRAPHIC));
        PublishEventActionTest.assertTrue((boolean)publishedAspects.contains(ContentModel.ASPECT_TEMPORARY));
        Map publishedProps = this.nodeService.getProperties(publishedNode);
        PublishEventActionTest.assertEquals((Object)lattitude, publishedProps.get(ContentModel.PROP_LATITUDE));
        PublishEventActionTest.assertEquals((Object)longtitude, publishedProps.get(ContentModel.PROP_LONGITUDE));
        PublishEventActionTest.assertEquals((Object)contentNodeName, publishedProps.get(ContentModel.PROP_NAME));
        PublishEventActionTest.assertEquals((String)content, (String)this.readContent(source));
        List assocs = this.nodeService.getTargetAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_LAST_PUBLISHING_EVENT);
        PublishEventActionTest.assertEquals((int)1, (int)assocs.size());
        PublishEventActionTest.assertEquals((Object)publishEventNode, (Object)((AssociationRef)assocs.get(0)).getTargetRef());
    }

    public void testUpdatePublishedNode() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        NodeRef publishEventNode = this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertNotNull((Object)publishedNode);
        PublishEventActionTest.assertTrue((boolean)this.nodeService.exists(publishedNode));
        Map publishedProps = this.nodeService.getProperties(publishedNode);
        PublishEventActionTest.assertFalse((boolean)publishedProps.containsKey(ContentModel.PROP_LATITUDE));
        PublishEventActionTest.assertFalse((boolean)publishedProps.containsKey(ContentModel.PROP_LONGITUDE));
        PublishEventActionTest.assertEquals((Object)contentNodeName, publishedProps.get(ContentModel.PROP_NAME));
        PublishEventActionTest.assertEquals((String)content, (String)this.readContent(source));
        Set aspects = this.nodeService.getAspects(source);
        PublishEventActionTest.assertFalse((boolean)aspects.contains(ContentModel.ASPECT_GEOGRAPHIC));
        List assocs = this.nodeService.getTargetAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_LAST_PUBLISHING_EVENT);
        PublishEventActionTest.assertEquals((int)1, (int)assocs.size());
        PublishEventActionTest.assertEquals((Object)publishEventNode, (Object)((AssociationRef)assocs.get(0)).getTargetRef());
        double lattitude = 0.25;
        double longtitude = 0.75;
        this.addGeographicAspect(source, lattitude, longtitude);
        String newName = "NewName";
        this.nodeService.setProperty(source, ContentModel.PROP_NAME, (Serializable)((Object)newName));
        String newContent = "The new content";
        this.testHelper.writeContent(source, newContent, "text/plain");
        publishEventNode = this.publishNode(source);
        NodeRef newPublishNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertEquals((Object)publishedNode, (Object)newPublishNode);
        PublishEventActionTest.assertNotNull((Object)publishedNode);
        PublishEventActionTest.assertTrue((boolean)this.nodeService.exists(publishedNode));
        aspects = this.nodeService.getAspects(publishedNode);
        PublishEventActionTest.assertTrue((boolean)aspects.contains(ContentModel.ASPECT_GEOGRAPHIC));
        PublishEventActionTest.assertTrue((boolean)aspects.containsAll(this.nodeService.getAspects(source)));
        publishedProps = this.nodeService.getProperties(publishedNode);
        PublishEventActionTest.assertEquals((Object)lattitude, publishedProps.get(ContentModel.PROP_LATITUDE));
        PublishEventActionTest.assertEquals((Object)longtitude, publishedProps.get(ContentModel.PROP_LONGITUDE));
        PublishEventActionTest.assertEquals((Object)newName, publishedProps.get(ContentModel.PROP_NAME));
        PublishEventActionTest.assertEquals((String)newContent, (String)this.readContent(source));
        assocs = this.nodeService.getTargetAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_LAST_PUBLISHING_EVENT);
        PublishEventActionTest.assertEquals((int)1, (int)assocs.size());
        PublishEventActionTest.assertEquals((Object)publishEventNode, (Object)((AssociationRef)assocs.get(0)).getTargetRef());
        this.nodeService.removeAspect(source, ContentModel.ASPECT_GEOGRAPHIC);
        this.publishNode(source);
        newPublishNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertEquals((Object)publishedNode, (Object)newPublishNode);
        aspects = this.nodeService.getAspects(source);
        PublishEventActionTest.assertFalse((boolean)aspects.contains(ContentModel.ASPECT_GEOGRAPHIC));
        publishedProps = this.nodeService.getProperties(publishedNode);
        PublishEventActionTest.assertFalse((boolean)publishedProps.containsKey(ContentModel.PROP_LATITUDE));
        PublishEventActionTest.assertFalse((boolean)publishedProps.containsKey(ContentModel.PROP_LONGITUDE));
    }

    public void testUnpublishNode() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertNotNull((Object)publishedNode);
        PublishEventActionTest.assertTrue((boolean)this.nodeService.exists(publishedNode));
        NodeRef eventNode = this.publishNode(source, null, false);
        PublishEventActionTest.assertFalse((boolean)this.nodeService.exists(publishedNode));
        publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertNull((Object)publishedNode);
        PublishingEvent event = this.publishingService.getPublishingEvent(eventNode.toString());
        PublishingPackage packg = event.getPackage();
        Set<NodeRef> toUnpublish = packg.getNodesToUnpublish();
        PublishEventActionTest.assertEquals((int)1, (int)toUnpublish.size());
        PublishEventActionTest.assertTrue((boolean)toUnpublish.contains(source));
        PublishingPackageEntry entry = packg.getEntryMap().get(source);
        PublishEventActionTest.assertEquals((boolean)false, (boolean)entry.isPublish());
        NodeSnapshot snapshot = entry.getSnapshot();
        PublishEventActionTest.assertEquals((Object)source, (Object)snapshot.getNodeRef());
        PublishEventActionTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)snapshot.getType());
        Serializable name = this.nodeService.getProperty(source, ContentModel.PROP_NAME);
        PublishEventActionTest.assertEquals((Object)name, (Object)snapshot.getProperties().get(ContentModel.PROP_NAME));
    }

    @Test
    public void testChannelTypePublishIsCalledOnPublish() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        Mockito.when((Object)this.channelType.canPublish()).thenReturn((Object)true);
        this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)1))).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
    }

    public void testChannelTypePublishIsCalledOnUpdate() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.never())).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
        Mockito.when((Object)this.channelType.canPublish()).thenReturn((Object)true);
        this.publishNode(source);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)1))).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
        this.publishNode(source, null, false);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.never())).unpublish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
        Mockito.when((Object)this.channelType.canUnpublish()).thenReturn((Object)true);
        this.publishNode(source);
        publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        PublishEventActionTest.assertNotNull((Object)publishedNode);
        this.publishNode(source, null, false);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)1))).unpublish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
    }

    @Test
    public void testSupportedContentTypes() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        Mockito.when((Object)this.channelType.canPublish()).thenReturn((Object)true);
        Set<QName> contentTypes = Collections.singleton(ContentModel.TYPE_FOLDER);
        Mockito.when(this.channelType.getSupportedContentTypes()).thenReturn(contentTypes);
        this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.never())).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
        contentTypes = Collections.singleton(ContentModel.TYPE_CONTENT);
        Mockito.when(this.channelType.getSupportedContentTypes()).thenReturn(contentTypes);
        this.publishNode(source);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)1))).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
        contentTypes = Collections.singleton(ContentModel.TYPE_CMOBJECT);
        Mockito.when(this.channelType.getSupportedContentTypes()).thenReturn(contentTypes);
        this.publishNode(source);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)2))).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
    }

    @Test
    public void testSupportedMimeTypes() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        Mockito.when((Object)this.channelType.canPublish()).thenReturn((Object)true);
        Set<String> mimeTypes = Collections.singleton("text/xml");
        Mockito.when(this.channelType.getSupportedMimeTypes()).thenReturn(mimeTypes);
        this.publishNode(source);
        NodeRef publishedNode = this.channelHelper.mapSourceToEnvironment(source, this.channelNode);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.never())).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
        mimeTypes = Collections.singleton("text/plain");
        Mockito.when(this.channelType.getSupportedMimeTypes()).thenReturn(mimeTypes);
        this.publishNode(source);
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)1))).publish((NodeRef)Matchers.eq((Object)publishedNode), Matchers.anyMap());
    }

    public void testStatusUpdate() throws Exception {
        NodeRef source = this.testHelper.createContentNode(contentNodeName, content, "text/plain");
        String message = "Here is the message ";
        String url = "http://test/url";
        Mockito.when((Object)this.channelType.getNodeUrl((NodeRef)Matchers.any(NodeRef.class))).thenReturn((Object)url);
        Mockito.when((Object)this.channelType.canPublishStatusUpdates()).thenReturn((Object)true);
        this.publishNode(source, message);
        String expMessage = message + " " + url;
        ((AbstractChannelType)Mockito.verify((Object)this.channelType, (VerificationMode)Mockito.times((int)1))).sendStatusUpdate((Channel)Matchers.any(Channel.class), (String)Matchers.eq((Object)expMessage));
    }

    private NodeRef publishNode(NodeRef source) {
        return this.publishNode(source, null);
    }

    private NodeRef publishNode(NodeRef source, String message) {
        return this.publishNode(source, message, true);
    }

    private NodeRef publishNode(NodeRef source, String message, boolean publish) {
        PublishingDetails details = this.publishingService.createPublishingDetails();
        details.setPublishChannelId(this.channel.getId());
        if (publish) {
            details.addNodesToPublish(source);
        } else {
            details.addNodesToUnpublish(source);
        }
        if (message != null) {
            details.setStatusMessage(message).setStatusNodeToLinkTo(source).addStatusUpdateChannels(this.channel.getId());
        }
        String eventId = this.testHelper.scheduleEvent1Year(details);
        PublishEventActionTest.assertNotNull((Object)eventId);
        NodeRef eventNode = new NodeRef(eventId);
        PublishEventActionTest.assertTrue((boolean)this.nodeService.exists(eventNode));
        Serializable eventStatus = this.nodeService.getProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_STATUS);
        PublishEventActionTest.assertEquals((Object)Status.SCHEDULED.name(), (Object)eventStatus);
        this.action.executeImpl(null, eventNode);
        eventStatus = this.nodeService.getProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_STATUS);
        PublishEventActionTest.assertEquals((Object)Status.COMPLETED.name(), (Object)eventStatus);
        return eventNode;
    }

    private void addGeographicAspect(NodeRef source, double lattitude, double longtitude) {
        HashMap<QName, Double> props = new HashMap<QName, Double>();
        props.put(ContentModel.PROP_LATITUDE, lattitude);
        props.put(ContentModel.PROP_LONGITUDE, longtitude);
        this.serviceRegistry.getNodeService().addAspect(source, ContentModel.ASPECT_GEOGRAPHIC, props);
    }

    private String readContent(NodeRef source) {
        ContentReader reader = this.contentService.getReader(source, ContentModel.PROP_CONTENT);
        return reader.getContentString();
    }

    @Override
    public void onSetUp() throws Exception {
        super.onSetUp();
        this.publishingService = (PublishingService)this.getApplicationContext().getBean("publishingService");
        this.contentService = (ContentService)this.getApplicationContext().getBean("ContentService");
        this.channelHelper = (ChannelHelper)this.getApplicationContext().getBean("channelHelper");
        this.action = (PublishEventAction)this.getApplicationContext().getBean("pub_publishEvent");
        this.channelType = this.testHelper.mockChannelType("MockChannelType");
        this.channel = this.testHelper.createChannel("MockChannelType");
        this.channelNode = new NodeRef(this.channel.getId());
    }
}

