/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.publishing.NodeSnapshotSerializer;
import org.alfresco.repo.publishing.NodeSnapshotTransferImpl;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.xml.sax.helpers.DefaultHandler;

public class StandardNodeSnapshotSerializer
implements NodeSnapshotSerializer {
    @Override
    public List<NodeSnapshot> deserialize(InputStream input) throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser parser = saxParserFactory.newSAXParser();
        NodeSnapshotDeserializer processor = new NodeSnapshotDeserializer();
        XMLTransferManifestReader xmlReader = new XMLTransferManifestReader(processor);
        parser.parse(input, (DefaultHandler)xmlReader);
        return processor.getSnapshots();
    }

    @Override
    public void serialize(Collection<NodeSnapshot> snapshots, OutputStream output) throws Exception {
        try {
            TransferManifestHeader header = new TransferManifestHeader();
            header.setCreatedDate(new Date());
            header.setNodeCount(snapshots.size());
            header.setReadOnly(false);
            header.setSync(false);
            OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
            XMLTransferManifestWriter transferManifestWriter = new XMLTransferManifestWriter();
            transferManifestWriter.startTransferManifest(writer);
            transferManifestWriter.writeTransferManifestHeader(header);
            for (NodeSnapshot snapshot : snapshots) {
                if (!(snapshot instanceof NodeSnapshotTransferImpl)) continue;
                NodeSnapshotTransferImpl snapshotImpl = (NodeSnapshotTransferImpl)snapshot;
                transferManifestWriter.writeTransferManifestNode(snapshotImpl.getTransferNode());
            }
            transferManifestWriter.endTransferManifest();
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to serialize node snapshots.", (Throwable)e);
        }
    }

    public static class NodeSnapshotDeserializer
    implements TransferManifestProcessor {
        private List<NodeSnapshot> snapshots = new ArrayList<NodeSnapshot>();

        public List<NodeSnapshot> getSnapshots() {
            return this.snapshots;
        }

        @Override
        public void endTransferManifest() {
        }

        @Override
        public void processTransferManifestNode(TransferManifestNormalNode node) {
            NodeSnapshotTransferImpl snapshot = new NodeSnapshotTransferImpl(node);
            this.snapshots.add(snapshot);
        }

        @Override
        public void processTransferManifestNode(TransferManifestDeletedNode node) {
        }

        @Override
        public void processTransferManifiestHeader(TransferManifestHeader header) {
        }

        @Override
        public void startTransferManifest() {
        }
    }
}

