/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.flickr.springsocial.api.impl;

import java.net.URI;
import java.util.List;
import org.alfresco.repo.publishing.JaxbHttpMessageConverter;
import org.alfresco.repo.publishing.flickr.springsocial.api.Flickr;
import org.alfresco.repo.publishing.flickr.springsocial.api.FlickrHelper;
import org.alfresco.repo.publishing.flickr.springsocial.api.MediaOperations;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.FlickrErrorHandler;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.MediaTemplate;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;

public class FlickrTemplate
extends AbstractOAuth1ApiBinding
implements Flickr,
FlickrHelper {
    private static final String DEFAULT_ENDPOINT = "http://api.flickr.com/services/";
    private static String endpoint = "http://api.flickr.com/services/";
    private String consumerKey;
    private MediaOperations mediaOperations;

    public FlickrTemplate() {
        this.initialize();
    }

    public FlickrTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        super(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.consumerKey = consumerKey;
        this.initialize();
    }

    private void initSubApis() {
        this.mediaOperations = new MediaTemplate(this, this.getRestTemplate(), this.isAuthorized());
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)requestFactory));
    }

    public static void setEndpoint(String endpoint) {
        FlickrTemplate.endpoint = endpoint;
    }

    @Override
    public MediaOperations mediaOperations() {
        return this.mediaOperations;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        List messageConverters = super.getMessageConverters();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add(new JaxbHttpMessageConverter("org.alfresco.repo.publishing.flickr.springsocial.api.impl.xml"));
        return messageConverters;
    }

    private void initialize() {
        this.getRestTemplate().setErrorHandler((ResponseErrorHandler)new FlickrErrorHandler());
        super.setRequestFactory(ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)this.getRestTemplate().getRequestFactory()));
        this.initSubApis();
    }

    @Override
    public boolean test() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"method", (Object)"flickr.test.login");
        this.addStandardParams((MultiValueMap<String, String>)params);
        URI uri = URIBuilder.fromUri((String)this.getRestEndpoint()).queryParams((MultiValueMap)params).build();
        this.getRestTemplate().getForObject(uri, String.class);
        return true;
    }

    @Override
    public void addStandardParams(URIBuilder uriBuilder) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        this.addStandardParams((MultiValueMap<String, String>)params);
        uriBuilder.queryParams((MultiValueMap)params);
    }

    @Override
    public void addStandardParams(MultiValueMap<String, String> params) {
        params.set((Object)"api_key", (Object)this.consumerKey);
    }

    @Override
    public String getRestEndpoint() {
        return endpoint + "rest/";
    }

    @Override
    public String getUploadEndpoint() {
        return endpoint + "upload/";
    }
}

