/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.linkedin.springsocial.api.impl;

import java.util.List;
import org.alfresco.repo.publishing.JaxbHttpMessageConverter;
import org.alfresco.repo.publishing.linkedin.springsocial.api.AlfrescoLinkedIn;
import org.alfresco.repo.publishing.linkedin.springsocial.api.impl.xml.JaxbActivityImpl;
import org.alfresco.repo.publishing.linkedin.springsocial.api.impl.xml.JaxbShareImpl;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.social.linkedin.api.impl.LinkedInTemplate;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.MultiValueMap;

public class AlfrescoLinkedInTemplate
extends LinkedInTemplate
implements AlfrescoLinkedIn {
    private static String JAXB_CONTEXT_PATH = "org.alfresco.repo.publishing.linkedin.springsocial.api.impl.xml:org.alfresco.repo.publishing.linkedin.springsocial.api";

    public AlfrescoLinkedInTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        super(consumerKey, consumerSecret, accessToken, accessTokenSecret);
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        List messageConverters = super.getMessageConverters();
        messageConverters.add(new JaxbHttpMessageConverter(JAXB_CONTEXT_PATH));
        return messageConverters;
    }

    @Override
    public void postNetworkUpdate(String update) {
        if (update == null || update.trim().length() == 0) {
            return;
        }
        URIBuilder uriBuilder = URIBuilder.fromUri((String)"http://api.linkedin.com/v1/people/~/person-activities");
        JaxbActivityImpl activity = new JaxbActivityImpl();
        activity.setBody(update);
        HttpEntity<?> entity = this.buildEntity(activity);
        this.getRestTemplate().postForObject(uriBuilder.build(), entity, String.class);
    }

    @Override
    public void shareComment(String comment) {
        if (comment == null || comment.trim().length() == 0) {
            return;
        }
        URIBuilder uriBuilder = URIBuilder.fromUri((String)"http://api.linkedin.com/v1/people/~/shares");
        JaxbShareImpl share = new JaxbShareImpl();
        share.setComment(comment);
        HttpEntity<?> entity = this.buildEntity(share);
        this.getRestTemplate().postForLocation(uriBuilder.build(), entity);
    }

    private HttpEntity<?> buildEntity(Object body) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_XML);
        return new HttpEntity(body, (MultiValueMap)headers);
    }
}

