/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.service.cmr.remote.AVMRemoteTransport;

public class AVMRemoteOutputStream
extends OutputStream {
    private AVMRemoteTransport fAVMRemote;
    private String fHandle;
    private ClientTicketHolder fTicketHolder;

    public AVMRemoteOutputStream(String handle, AVMRemoteTransport remote, ClientTicketHolder ticketHolder) {
        this.fAVMRemote = remote;
        this.fHandle = handle;
        this.fTicketHolder = ticketHolder;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buff = new byte[]{(byte)b};
        this.write(buff);
    }

    @Override
    public void close() throws IOException {
        try {
            this.fAVMRemote.closeOutputHandle(this.fTicketHolder.getTicket(), this.fHandle);
        }
        catch (Exception e) {
            throw new IOException("IO Error: " + e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (off == 0) {
                this.fAVMRemote.writeOutput(this.fTicketHolder.getTicket(), this.fHandle, b, len);
            } else {
                byte[] buff = new byte[len];
                System.arraycopy(b, off, buff, 0, len);
                this.fAVMRemote.writeOutput(this.fTicketHolder.getTicket(), this.fHandle, buff, len);
            }
        }
        catch (Exception e) {
            throw new IOException("IO Error: " + e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }
}

