/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteconnector;

import java.io.FilterInputStream;
import java.io.IOException;
import org.alfresco.repo.remoteconnector.RemoteConnectorRequestImpl;
import org.alfresco.repo.remoteconnector.RemoteConnectorResponseImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorClientException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorRequest;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorResponse;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorServerException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorService;
import org.alfresco.util.HttpClientHelper;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RemoteConnectorServiceImpl
implements RemoteConnectorService {
    private static Log logger = LogFactory.getLog(RemoteConnectorServiceImpl.class);
    private static final long MAX_BUFFER_RESPONSE_SIZE = 0xA00000L;

    @Override
    public RemoteConnectorRequest buildRequest(String url, String method) {
        return new RemoteConnectorRequestImpl(url, method);
    }

    public RemoteConnectorRequest buildRequest(String url, Class<? extends HttpMethodBase> method) {
        return new RemoteConnectorRequestImpl(url, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteConnectorResponse executeRequest(RemoteConnectorRequest request) throws IOException, AuthenticationException, RemoteConnectorClientException, RemoteConnectorServerException {
        RemoteConnectorRequestImpl reqImpl = (RemoteConnectorRequestImpl)request;
        HttpMethodBase httpRequest = reqImpl.getMethodInstance();
        for (Header hdr : request.getRequestHeaders()) {
            httpRequest.addRequestHeader(hdr);
        }
        if (httpRequest instanceof EntityEnclosingMethod && request.getRequestBody() != null) {
            ((EntityEnclosingMethod)httpRequest).setRequestEntity(reqImpl.getRequestBody());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing " + request.getMethod() + " request to " + request.getURL()));
        }
        HttpClient httpClient = HttpClientHelper.getHttpClient();
        int status = -1;
        String statusText = null;
        RemoteConnectorResponseImpl response = null;
        try {
            String responseContentType;
            status = httpClient.executeMethod((HttpMethod)httpRequest);
            statusText = httpRequest.getStatusText();
            Header[] responseHdrs = httpRequest.getResponseHeaders();
            Header responseContentTypeH = httpRequest.getResponseHeader("Content-Type");
            String responseCharSet = httpRequest.getResponseCharSet();
            String string = responseContentType = responseContentTypeH != null ? responseContentTypeH.getValue() : null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("response url=" + request.getURL() + ", length =" + httpRequest.getResponseContentLength() + ", responceContentType " + responseContentType + ", statusText =" + statusText));
            }
            if (httpRequest.getResponseContentLength() > 0xA00000L || httpRequest.getResponseContentLength() == -1L) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("large response (or don't know length) url=" + request.getURL()));
                }
                HttpClientReleasingInputStream wrappedStream = new HttpClientReleasingInputStream(httpRequest);
                httpRequest = null;
                response = new RemoteConnectorResponseImpl(request, responseContentType, responseCharSet, status, responseHdrs, wrappedStream);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.debug((Object)("small response for url=" + request.getURL()));
                }
                response = new RemoteConnectorResponseImpl(request, responseContentType, responseCharSet, status, responseHdrs, httpRequest.getResponseBody());
                httpRequest.releaseConnection();
                httpRequest = null;
            }
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
                httpRequest = null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Response was " + status + " " + statusText));
        }
        if (status >= 300) {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
            if (status == 403 || status == 401) {
                throw new AuthenticationException(statusText);
            }
            if (status >= 500 && status <= 599) {
                logger.error((Object)("executeRequest: remote connector server exception: [" + status + "] " + statusText));
                throw new RemoteConnectorServerException(status, statusText);
            }
            if (status == 412) {
                logger.error((Object)("executeRequest: remote connector client exception: [" + status + "] " + statusText));
                throw new RemoteConnectorClientException(status, statusText, response);
            }
            if (httpRequest != null) {
                logger.error((Object)("executeRequest: remote connector client exception: [" + status + "] " + statusText));
                throw new RemoteConnectorClientException(status, statusText, response);
            }
            logger.error((Object)("executeRequest: remote connector client exception: [" + status + "] " + statusText));
            throw new RemoteConnectorClientException(status, statusText, null);
        }
        return response;
    }

    @Override
    public JSONObject executeJSONRequest(RemoteConnectorRequest request) throws ParseException, IOException, AuthenticationException {
        return RemoteConnectorServiceImpl.doExecuteJSONRequest(request, this);
    }

    public static JSONObject doExecuteJSONRequest(RemoteConnectorRequest request, RemoteConnectorService service) throws ParseException, IOException, AuthenticationException {
        request.setContentType("application/json");
        RemoteConnectorResponse response = service.executeRequest(request);
        JSONParser parser = new JSONParser();
        String jsonText = response.getResponseBodyAsString();
        Object json = parser.parse(jsonText);
        if (json instanceof JSONObject) {
            return (JSONObject)json;
        }
        throw new ParseException(0, json);
    }

    private static class HttpClientReleasingInputStream
    extends FilterInputStream {
        private HttpMethodBase httpRequest;

        private HttpClientReleasingInputStream(HttpMethodBase httpRequest) throws IOException {
            super(httpRequest.getResponseBodyAsStream());
            this.httpRequest = httpRequest;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.httpRequest != null) {
                this.httpRequest.releaseConnection();
                this.httpRequest = null;
            }
        }

        protected void finalize() throws Throwable {
            if (this.httpRequest != null) {
                logger.warn((Object)"RemoteConnector response InputStream wasn't closed but must be! This can cause issues for other requests in this Thread!");
                this.httpRequest.releaseConnection();
                this.httpRequest = null;
            }
            super.finalize();
        }
    }
}

