/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.rendition.executer.XSLTFunctions;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XSLTRenderingEngineTest
extends BaseAlfrescoSpringTest {
    private static final Log log = LogFactory.getLog(XSLTRenderingEngineTest.class);
    private XSLTFunctions xsltFunctions;
    private SearchService searchService;
    private NodeRef companyHome;
    private FileFolderService fileFolderService;
    private TemplateProcessor xsltProcessor;
    private TemplateService templateService;
    private RenditionService renditionService;
    private String sampleXML = "<?xml version=\"1.0\"?><nutrition><daily-values><total-fat units=\"g\">65</total-fat><saturated-fat units=\"g\">20</saturated-fat><cholesterol units=\"mg\">300</cholesterol><sodium units=\"mg\">2400</sodium><carb units=\"g\">300</carb><fiber units=\"g\">25</fiber><protein units=\"g\">50</protein></daily-values><food><name>Avocado Dip</name><mfr>Sunnydale</mfr><serving units=\"g\">29</serving><calories total=\"110\" fat=\"100\"/><total-fat>11</total-fat><saturated-fat>3</saturated-fat><cholesterol>5</cholesterol><sodium>210</sodium><carb>2</carb><fiber>0</fiber><protein>1</protein><vitamins><a>0</a><c>0</c></vitamins><minerals><ca>0</ca><fe>0</fe></minerals></food><food><name>Bagels, New York Style</name><mfr>Thompson</mfr><serving units=\"g\">104</serving><calories total=\"300\" fat=\"35\"/><total-fat>4</total-fat><saturated-fat>1</saturated-fat><cholesterol>0</cholesterol><sodium>510</sodium><carb>54</carb><fiber>3</fiber><protein>11</protein><vitamins><a>0</a><c>0</c></vitamins><minerals><ca>8</ca><fe>20</fe></minerals></food><food><name>Beef Frankfurter, Quarter Pound</name><mfr>Armitage</mfr><serving units=\"g\">115</serving><calories total=\"370\" fat=\"290\"/><total-fat>32</total-fat><saturated-fat>15</saturated-fat><cholesterol>65</cholesterol><sodium>1100</sodium><carb>8</carb><fiber>0</fiber><protein>13</protein><vitamins><a>0</a><c>2</c></vitamins><minerals><ca>1</ca><fe>6</fe></minerals></food><food><name>Chicken Pot Pie</name><mfr>Lakeson</mfr><serving units=\"g\">198</serving><calories total=\"410\" fat=\"200\"/><total-fat>22</total-fat><saturated-fat>9</saturated-fat><cholesterol>25</cholesterol><sodium>810</sodium><carb>42</carb><fiber>2</fiber><protein>10</protein><vitamins><a>20</a><c>2</c></vitamins><minerals><ca>2</ca><fe>10</fe></minerals></food><food><name>Cole Slaw</name><mfr>Fresh Quick</mfr><serving units=\" cup\">1.5</serving><calories total=\"20\" fat=\"0\"/><total-fat>0</total-fat><saturated-fat>0</saturated-fat><cholesterol>0</cholesterol><sodium>15</sodium><carb>5</carb><fiber>2</fiber><protein>1</protein><vitamins><a>30</a><c>45</c></vitamins><minerals><ca>4</ca><fe>2</fe></minerals></food><food><name>Eggs</name><mfr>Goodpath</mfr><serving units=\"g\">50</serving><calories total=\"70\" fat=\"40\"/><total-fat>4.5</total-fat><saturated-fat>1.5</saturated-fat><cholesterol>215</cholesterol><sodium>65</sodium><carb>1</carb><fiber>0</fiber><protein>6</protein><vitamins><a>6</a><c>0</c></vitamins><minerals><ca>2</ca><fe>4</fe></minerals></food><food><name>Hazelnut Spread</name><mfr>Ferreira</mfr><serving units=\"tbsp\">2</serving><calories total=\"200\" fat=\"90\"/><total-fat>10</total-fat><saturated-fat>2</saturated-fat><cholesterol>0</cholesterol><sodium>20</sodium><carb>23</carb><fiber>2</fiber><protein>3</protein><vitamins><a>0</a><c>0</c></vitamins><minerals><ca>6</ca><fe>4</fe></minerals></food><food><name>Potato Chips</name><mfr>Lees</mfr><serving units=\"g\">28</serving><calories total=\"150\" fat=\"90\"/><total-fat>10</total-fat><saturated-fat>3</saturated-fat><cholesterol>0</cholesterol><sodium>180</sodium><carb>15</carb><fiber>1</fiber><protein>2</protein><vitamins><a>0</a><c>10</c></vitamins><minerals><ca>0</ca><fe>0</fe></minerals></food><food><name>Soy Patties, Grilled</name><mfr>Gardenproducts</mfr><serving units=\"g\">96</serving><calories total=\"160\" fat=\"45\"/><total-fat>5</total-fat><saturated-fat>0</saturated-fat><cholesterol>0</cholesterol><sodium>420</sodium><carb>10</carb><fiber>4</fiber><protein>9</protein><vitamins><a>0</a><c>0</c></vitamins><minerals><ca>0</ca><fe>0</fe></minerals></food><food><name>Truffles, Dark Chocolate</name><mfr>Lyndon's</mfr><serving units=\"g\">39</serving><calories total=\"220\" fat=\"170\"/><total-fat>19</total-fat><saturated-fat>14</saturated-fat><cholesterol>25</cholesterol><sodium>10</sodium><carb>16</carb><fiber>1</fiber><protein>1</protein><vitamins><a>0</a><c>0</c></vitamins><minerals><ca>0</ca><fe>0</fe></minerals></food></nutrition>";
    private String verySimpleXSLT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"> <xsl:output method=\"text\" /><xsl:preserve-space elements=\"*\"/><xsl:template match=\"/\"><xsl:for-each select=\"/nutrition/food\"><xsl:value-of select=\"name\"/></xsl:for-each></xsl:template></xsl:stylesheet>";
    private String callParseXmlDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"> <xsl:output method=\"text\" /><xsl:preserve-space elements=\"*\"/><xsl:variable name=\"cf\" select=\"alf:parseXMLDocument('TestXML.xml')\"/><xsl:template match=\"/\"><xsl:for-each select=\"$cf/food\"><xsl:value-of select=\"name\"/></xsl:for-each></xsl:template></xsl:stylesheet>";
    private String callParseXmlDocuments = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"> <xsl:output method=\"text\" /><xsl:preserve-space elements=\"*\"/><xsl:variable name=\"all_docs\" select=\"alf:parseXMLDocuments('cm:content', 'path/to/xml/files')\"/><xsl:template match=\"/\"><xsl:for-each select=\"$all_docs//food\"><xsl:value-of select=\"name\"/></xsl:for-each></xsl:template></xsl:stylesheet>";

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.xsltFunctions = (XSLTFunctions)this.applicationContext.getBean("xsltFunctions");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("FileFolderService");
        this.xsltProcessor = (TemplateProcessor)this.applicationContext.getBean("xsltProcessor");
        this.templateService = (TemplateService)this.applicationContext.getBean("TemplateService");
        this.renditionService = (RenditionService)this.applicationContext.getBean("RenditionService");
        ResultSet rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", "/app:company_home");
        this.companyHome = rs.getNodeRef(0);
    }

    public void testSimplestStringTemplate() throws Exception {
        try {
            FileInfo file = this.createXmlFile(this.companyHome);
            FileInfo xslFile = this.createXmlFile(this.companyHome, this.verySimpleXSLT);
            RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "xsltRenderingEngine");
            def.setParameterValue("template_node", (Serializable)xslFile.getNodeRef());
            ChildAssociationRef rendition = this.renditionService.render(file.getNodeRef(), def);
            XSLTRenderingEngineTest.assertNotNull((Object)rendition);
            ContentReader reader = this.contentService.getReader(rendition.getChildRef(), ContentModel.PROP_CONTENT);
            XSLTRenderingEngineTest.assertNotNull((Object)reader);
            String output = reader.getContentString();
            log.debug((Object)("XSLT Processor output: " + output));
            XSLTRenderingEngineTest.assertEquals((String)"Avocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark Chocolate", (String)output);
        }
        catch (Exception ex) {
            log.error((Object)"Error!", (Throwable)ex);
            XSLTRenderingEngineTest.fail();
        }
    }

    public void testSimplestTemplateWithTargetPath() throws Exception {
        try {
            FileInfo file = this.createXmlFile(this.companyHome);
            FileInfo xslFile = this.createXmlFile(this.companyHome, this.verySimpleXSLT);
            RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "xsltRenderingEngine");
            def.setParameterValue("template_node", (Serializable)xslFile.getNodeRef());
            def.setParameterValue("destination-path-template", (Serializable)((Object)"output/path/for/rendition/output.txt"));
            ChildAssociationRef rendition = this.renditionService.render(file.getNodeRef(), def);
            XSLTRenderingEngineTest.assertNotNull((Object)rendition);
            XSLTRenderingEngineTest.assertEquals((int)2, (int)this.nodeService.getParentAssocs(rendition.getChildRef()).size());
            ContentReader reader = this.contentService.getReader(rendition.getChildRef(), ContentModel.PROP_CONTENT);
            XSLTRenderingEngineTest.assertNotNull((Object)reader);
            String output = reader.getContentString();
            log.debug((Object)("XSLT Processor output: " + output));
            XSLTRenderingEngineTest.assertEquals((String)"Avocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark Chocolate", (String)output);
        }
        catch (Exception ex) {
            log.error((Object)"Error!", (Throwable)ex);
            XSLTRenderingEngineTest.fail();
        }
    }

    public void testParseXMLDocument() throws Exception {
        try {
            FileInfo file = this.createXmlFile(this.companyHome);
            this.createXmlFile(this.companyHome, "TestXML.xml", this.sampleXML);
            FileInfo xslFile = this.createXmlFile(this.companyHome, this.callParseXmlDocument);
            RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "xsltRenderingEngine");
            def.setParameterValue("template_node", (Serializable)xslFile.getNodeRef());
            ChildAssociationRef rendition = this.renditionService.render(file.getNodeRef(), def);
            XSLTRenderingEngineTest.assertNotNull((Object)rendition);
            ContentReader reader = this.contentService.getReader(rendition.getChildRef(), ContentModel.PROP_CONTENT);
            XSLTRenderingEngineTest.assertNotNull((Object)reader);
            String output = reader.getContentString();
            log.debug((Object)("XSLT Processor output: " + output));
            XSLTRenderingEngineTest.assertEquals((String)"Avocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark Chocolate", (String)output);
        }
        catch (Exception ex) {
            log.error((Object)"Error!", (Throwable)ex);
            XSLTRenderingEngineTest.fail();
        }
    }

    public void testParseXMLDocuments() throws Exception {
        try {
            FileInfo file = this.createXmlFile(this.companyHome);
            String path = "path/to/xml/files";
            List<String> pathElements = Arrays.asList(path.split("/"));
            FileInfo folder = FileFolderServiceImpl.makeFolders(this.fileFolderService, this.companyHome, pathElements, ContentModel.TYPE_FOLDER);
            this.createXmlFile(folder.getNodeRef());
            this.createXmlFile(folder.getNodeRef());
            this.createXmlFile(folder.getNodeRef());
            this.createXmlFile(folder.getNodeRef());
            this.createXmlFile(folder.getNodeRef());
            FileInfo xslFile = this.createXmlFile(this.companyHome, this.callParseXmlDocuments);
            RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "xsltRenderingEngine");
            def.setParameterValue("template_node", (Serializable)xslFile.getNodeRef());
            ChildAssociationRef rendition = this.renditionService.render(file.getNodeRef(), def);
            XSLTRenderingEngineTest.assertNotNull((Object)rendition);
            ContentReader reader = this.contentService.getReader(rendition.getChildRef(), ContentModel.PROP_CONTENT);
            XSLTRenderingEngineTest.assertNotNull((Object)reader);
            String output = reader.getContentString();
            log.debug((Object)("XSLT Processor output: " + output));
            XSLTRenderingEngineTest.assertEquals((String)"Avocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark ChocolateAvocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark ChocolateAvocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark ChocolateAvocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark ChocolateAvocado DipBagels, New York StyleBeef Frankfurter, Quarter PoundChicken Pot PieCole SlawEggsHazelnut SpreadPotato ChipsSoy Patties, GrilledTruffles, Dark Chocolate", (String)output);
        }
        catch (Exception ex) {
            log.error((Object)"Error!", (Throwable)ex);
            XSLTRenderingEngineTest.fail();
        }
    }

    private FileInfo createXmlFile(NodeRef folder) {
        return this.createXmlFile(folder, this.sampleXML);
    }

    private FileInfo createXmlFile(NodeRef folder, String content) {
        String name = GUID.generate() + ".xml";
        return this.createXmlFile(folder, name, content);
    }

    private FileInfo createXmlFile(NodeRef folder, String filename, String content) {
        FileInfo testXmlFile = this.fileFolderService.create(folder, filename, ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.contentService.getWriter(testXmlFile.getNodeRef(), ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/xml");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        return testXmlFile;
    }
}

