/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.RuleTypeImpl;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.BaseSpringTest;

public class RuleTypeImplTest
extends BaseSpringTest {
    private static final String NAME = "name";
    private NodeService nodeService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
    }

    public void testConstructor() {
        this.create();
    }

    private RuleTypeImpl create() {
        RuleTypeImpl temp = new RuleTypeImpl(null);
        temp.setBeanName(NAME);
        RuleTypeImplTest.assertNotNull((Object)temp);
        return temp;
    }

    public void testGetName() {
        RuleTypeImpl temp = this.create();
        RuleTypeImplTest.assertEquals((String)NAME, (String)temp.getName());
    }

    public void testMockInboundRuleType() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        ArrayList<RuleTrigger> triggers = new ArrayList<RuleTrigger>(2);
        triggers.add((RuleTrigger)this.applicationContext.getBean("on-content-create-trigger"));
        triggers.add((RuleTrigger)this.applicationContext.getBean("on-content-update-trigger"));
        triggers.add((RuleTrigger)this.applicationContext.getBean("on-create-child-association-trigger"));
        ExtendedRuleType ruleType = new ExtendedRuleType(triggers);
        RuleTypeImplTest.assertFalse((boolean)ruleType.rulesTriggered);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.putContent("any old content");
        RuleTypeImplTest.assertTrue((boolean)ruleType.rulesTriggered);
        ruleType.rulesTriggered = false;
        RuleTypeImplTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.addChild(nodeRef2, nodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN);
        RuleTypeImplTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    private class ExtendedRuleType
    extends RuleTypeImpl {
        public boolean rulesTriggered;

        public ExtendedRuleType(List<RuleTrigger> ruleTriggers) {
            super(ruleTriggers);
            this.rulesTriggered = false;
        }

        @Override
        public void triggerRuleType(NodeRef nodeRef, NodeRef actionedUponNodeRef, boolean executeRuleImmediately) {
            this.rulesTriggered = true;
        }
    }
}

