/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnContentUpdateRuleTrigger
extends RuleTriggerAbstractBase
implements ContentServicePolicies.OnContentPropertyUpdatePolicy {
    private static Log logger = LogFactory.getLog(OnContentUpdateRuleTrigger.class);
    private boolean onNewContent = false;
    private boolean triggerParentRules = true;

    public void setOnNewContent(boolean onNewContent) {
        this.onNewContent = onNewContent;
    }

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    @Override
    public void registerRuleTrigger() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentPropertyUpdatePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onContentPropertyUpdate"));
    }

    @Override
    public void onContentPropertyUpdate(NodeRef nodeRef, QName propertyQName, ContentData beforeValue, ContentData afterValue) {
        boolean newContent;
        if (!this.areRulesEnabled()) {
            return;
        }
        if (propertyQName.equals((Object)ContentModel.PROP_PREFERENCE_VALUES)) {
            return;
        }
        boolean bl = newContent = beforeValue == null && afterValue != null;
        if (newContent) {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
                return;
            }
            if (!ContentData.hasContent((ContentData)afterValue)) {
                return;
            }
        } else {
            Set newNodeRefSet = TransactionalResourceHelper.getSet("RuleTrigger.NewNodes");
            if (newNodeRefSet.contains(nodeRef)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Receiving content property update for node created in transaction: " + nodeRef));
                }
                return;
            }
        }
        if (newContent == this.onNewContent) {
            if (this.triggerParentRules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OnContentUpdate rule triggered fired for content; nodeId=" + nodeRef.getId() + "; newContent=" + newContent));
                }
                List parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                    this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                }
            } else {
                this.triggerRules(nodeRef, nodeRef);
            }
        }
    }
}

