/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.namespace.QName;

public abstract class RuleTriggerAbstractBase
implements RuleTrigger {
    private static final Set<QName> IGNORE_TYPES = new HashSet<QName>(13);
    private static final Set<QName> IGNORE_ASPECTS;
    private Set<RuleType> ruleTypes = new HashSet<RuleType>();
    protected PolicyComponent policyComponent;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected AuthenticationComponent authenticationComponent;
    protected DictionaryService dictionaryService;
    protected RuleService ruleService;
    protected boolean executeRuleImmediately = false;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setExecuteRuleImmediately(boolean executeRuleImmediately) {
        this.executeRuleImmediately = executeRuleImmediately;
    }

    @Override
    public void registerRuleType(RuleType ruleType) {
        this.ruleTypes.add(ruleType);
    }

    protected void triggerRules(NodeRef nodeRef, NodeRef actionedUponNodeRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        if (!this.ignoreTrigger(actionedUponNodeRef)) {
            for (RuleType ruleType : this.ruleTypes) {
                ruleType.triggerRuleType(nodeRef, actionedUponNodeRef, this.executeRuleImmediately);
            }
        }
    }

    protected boolean areRulesEnabled() {
        return this.ruleService.isEnabled();
    }

    private boolean ignoreTrigger(NodeRef actionedUponNodeRef) {
        boolean result = false;
        QName typeQName = this.nodeService.getType(actionedUponNodeRef);
        if (IGNORE_TYPES.contains(typeQName)) {
            result = true;
        }
        for (QName aspectToIgnore : IGNORE_ASPECTS) {
            if (!this.nodeService.hasAspect(actionedUponNodeRef, aspectToIgnore)) continue;
            return true;
        }
        return result;
    }

    static {
        IGNORE_TYPES.add(RuleModel.TYPE_RULE);
        IGNORE_TYPES.add(ActionModel.TYPE_ACTION);
        IGNORE_TYPES.add(ContentModel.TYPE_THUMBNAIL);
        IGNORE_TYPES.add(ContentModel.TYPE_RATING);
        IGNORE_ASPECTS = new HashSet<QName>(13);
        IGNORE_ASPECTS.add(ContentModel.ASPECT_TEMPORARY);
    }
}

