/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.Locale;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.repo.search.impl.lucene.LuceneUtils;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.results.SortedResultSet;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class LuceneAlfrescoLuceneQueryLanguage
extends AbstractLuceneQueryLanguage {
    static Log s_logger = LogFactory.getLog(LuceneAlfrescoLuceneQueryLanguage.class);

    public LuceneAlfrescoLuceneQueryLanguage() {
        this.setName("lucene");
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        try {
            Object answer;
            QueryParser.Operator defaultOperator = searchParameters.getDefaultOperator() == SearchParameters.AND ? LuceneQueryParser.AND_OPERATOR : LuceneQueryParser.OR_OPERATOR;
            ClosingIndexSearcher searcher = admLuceneSearcher.getClosingIndexSearcher();
            if (searcher == null) {
                return new EmptyResultSet();
            }
            Query query = LuceneQueryParser.parse((String)searchParameters.getQuery(), (String)searchParameters.getDefaultFieldName(), (Analyzer)new LuceneAnalyser(admLuceneSearcher.getDictionaryService(), searchParameters.getMlAnalaysisMode() == null ? admLuceneSearcher.getLuceneConfig().getDefaultMLSearchAnalysisMode() : searchParameters.getMlAnalaysisMode()), (NamespacePrefixResolver)admLuceneSearcher.getNamespacePrefixResolver(), (DictionaryService)admLuceneSearcher.getDictionaryService(), (TenantService)admLuceneSearcher.getTenantService(), (QueryParser.Operator)defaultOperator, (SearchParameters)searchParameters, (MLAnalysisMode)admLuceneSearcher.getLuceneConfig().getDefaultMLSearchAnalysisMode(), (IndexReader)searcher.getIndexReader());
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Query is " + query.toString()));
            }
            boolean requiresDateTimePostSort = false;
            SortField[] fields = new SortField[searchParameters.getSortDefinitions().size()];
            if (searchParameters.getSortDefinitions().size() > 0) {
                int index = 0;
                for (SearchParameters.SortDefinition sd : searchParameters.getSortDefinitions()) {
                    switch (sd.getSortType()) {
                        case FIELD: {
                            Locale sortLocale = searchParameters.getSortLocale();
                            String field = sd.getField();
                            if (field.startsWith("@")) {
                                field = admLuceneSearcher.expandAttributeFieldName(field);
                                PropertyDefinition propertyDef = admLuceneSearcher.getDictionaryService().getProperty(QName.createQName((String)field.substring(1)));
                                if (propertyDef == null) {
                                    if (field.endsWith(".size")) {
                                        propertyDef = admLuceneSearcher.getDictionaryService().getProperty(QName.createQName((String)field.substring(1, field.length() - 5)));
                                        if (!propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                                            throw new SearcherException("Order for .size only supported on content properties");
                                        }
                                    } else if (field.endsWith(".mimetype") && !(propertyDef = admLuceneSearcher.getDictionaryService().getProperty(QName.createQName((String)field.substring(1, field.length() - 9)))).getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                                        throw new SearcherException("Order for .mimetype only supported on content properties");
                                    }
                                } else {
                                    if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                                        throw new SearcherException("Order on content properties is not curently supported");
                                    }
                                    if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                                        if (propertyDef.getIndexTokenisationMode() != IndexTokenisationMode.FALSE) {
                                            String noLocalField = field + ".no_locale";
                                            for (Object current : searcher.getIndexReader().getFieldNames(IndexReader.FieldOption.INDEXED)) {
                                                String currentString = (String)current;
                                                if (!currentString.equals(noLocalField)) continue;
                                                field = noLocalField;
                                            }
                                            if (!field.endsWith(".no_locale")) {
                                                field = admLuceneSearcher.findSortField(searchParameters, searcher, field, sortLocale);
                                            }
                                        }
                                    } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                                        field = admLuceneSearcher.findSortField(searchParameters, searcher, field, sortLocale);
                                    } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                                        DataTypeDefinition dataType = propertyDef.getDataType();
                                        String analyserClassName = propertyDef.resolveAnalyserClassName();
                                        if (analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName())) {
                                            switch (propertyDef.getIndexTokenisationMode()) {
                                                case TRUE: {
                                                    requiresDateTimePostSort = true;
                                                    break;
                                                }
                                                case BOTH: {
                                                    field = field + ".sort";
                                                    break;
                                                }
                                            }
                                        } else {
                                            requiresDateTimePostSort = true;
                                        }
                                    }
                                }
                            }
                            if (LuceneUtils.fieldHasTerm((IndexReader)searcher.getReader(), (String)field)) {
                                fields[index++] = new SortField(field, sortLocale, !sd.isAscending());
                                break;
                            }
                            fields[index++] = new SortField(null, 1, !sd.isAscending());
                            break;
                        }
                        case DOCUMENT: {
                            fields[index++] = new SortField(null, 1, !sd.isAscending());
                            break;
                        }
                        case SCORE: {
                            fields[index++] = new SortField(null, 0, sd.isAscending());
                        }
                    }
                }
            }
            Hits hits = searcher.search(query);
            boolean postSort = false;
            if (fields.length > 0 && !(postSort = searchParameters.usePostSort(hits.length(), admLuceneSearcher.getLuceneConfig().getUseInMemorySort(), admLuceneSearcher.getLuceneConfig().getMaxRawResultSetSizeForInMemorySort()))) {
                hits = searcher.search(query, new Sort(fields));
            }
            LuceneResultSet result = new LuceneResultSet(hits, (Searcher)searcher, admLuceneSearcher.getNodeService(), admLuceneSearcher.getTenantService(), searchParameters, admLuceneSearcher.getLuceneConfig());
            if (postSort || admLuceneSearcher.getLuceneConfig().getPostSortDateTime() && requiresDateTimePostSort) {
                SortedResultSet sorted = new SortedResultSet((ResultSet)result, admLuceneSearcher.getNodeService(), searchParameters.getSortDefinitions(), admLuceneSearcher.getNamespacePrefixResolver(), admLuceneSearcher.getDictionaryService(), searchParameters.getSortLocale());
                answer = sorted;
            } else {
                answer = result;
            }
            PagingLuceneResultSet rs = new PagingLuceneResultSet((ResultSet)answer, searchParameters, admLuceneSearcher.getNodeService());
            return rs;
        }
        catch (ParseException e) {
            throw new SearcherException("Failed to parse query: " + searchParameters.getQuery(), e);
        }
        catch (IOException e) {
            throw new SearcherException("IO exception during search", e);
        }
    }
}

