/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

public enum TransactionStatus {
    ACTIVE{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == null || previous == ACTIVE;
        }

        @Override
        public int getStatus() {
            return 0;
        }
    }
    ,
    MARKED_ROLLBACK{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous.allowsRollbackOrMark(previous) || previous == MARKED_ROLLBACK;
        }

        @Override
        public int getStatus() {
            return 1;
        }
    }
    ,
    PREPARED{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == PREPARING || previous == PREPARED;
        }

        @Override
        public int getStatus() {
            return 2;
        }
    }
    ,
    COMMITTED{

        @Override
        public boolean isCommitted() {
            return true;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == COMMITTING || previous == COMMITTED;
        }

        @Override
        public int getStatus() {
            return 3;
        }
    }
    ,
    ROLLEDBACK{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == ROLLINGBACK || previous == ROLLEDBACK;
        }

        @Override
        public int getStatus() {
            return 4;
        }
    }
    ,
    UNKNOWN{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == UNKNOWN;
        }

        @Override
        public int getStatus() {
            return 5;
        }
    }
    ,
    NO_TRANSACTION{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == NO_TRANSACTION;
        }

        @Override
        public int getStatus() {
            return 6;
        }
    }
    ,
    PREPARING{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == ACTIVE || previous == PREPARING;
        }

        @Override
        public int getStatus() {
            return 7;
        }
    }
    ,
    COMMITTING{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == PREPARED || previous == COMMITTING;
        }

        @Override
        public int getStatus() {
            return 8;
        }
    }
    ,
    ROLLINGBACK{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean canBeReordered() {
            return true;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous.allowsRollbackOrMark(previous) || previous == ROLLINGBACK;
        }

        @Override
        public int getStatus() {
            return 9;
        }
    }
    ,
    MERGE{

        @Override
        public boolean isCommitted() {
            return true;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == MERGE;
        }

        @Override
        public int getStatus() {
            return 3;
        }
    }
    ,
    MERGE_TARGET{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == MERGE_TARGET;
        }

        @Override
        public int getStatus() {
            return 0;
        }
    }
    ,
    COMMITTED_DELETING{

        @Override
        public boolean isCommitted() {
            return true;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return previous == COMMITTED_DELETING;
        }

        @Override
        public int getStatus() {
            return 3;
        }
    }
    ,
    DELETABLE{

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean canBeReordered() {
            return false;
        }

        @Override
        public boolean follows(TransactionStatus previous) {
            return true;
        }

        @Override
        public int getStatus() {
            return 5;
        }
    };


    public abstract boolean isCommitted();

    public abstract boolean isTransient();

    public abstract boolean canBeReordered();

    public abstract boolean follows(TransactionStatus var1);

    public abstract int getStatus();

    private boolean allowsRollbackOrMark(TransactionStatus previous) {
        switch (previous) {
            case ACTIVE: 
            case MARKED_ROLLBACK: 
            case PREPARED: 
            case PREPARING: 
            case COMMITTING: {
                return true;
            }
        }
        return false;
    }
}

