/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.security.authentication.AbstractAuthenticationService;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractChainingAuthenticationService
extends AbstractAuthenticationService
implements MutableAuthenticationService {
    private static final Log logger = LogFactory.getLog(AbstractChainingAuthenticationService.class);

    public abstract MutableAuthenticationService getMutableAuthenticationService();

    protected abstract List<AuthenticationService> getUsableAuthenticationServices();

    @Override
    public void createAuthentication(String userName, char[] password) throws AuthenticationException {
        if (this.getMutableAuthenticationService() == null) {
            throw new AuthenticationException("Unable to create authentication as there is no suitable authentication service.");
        }
        this.getMutableAuthenticationService().createAuthentication(userName, password);
    }

    @Override
    public void updateAuthentication(String userName, char[] oldPassword, char[] newPassword) throws AuthenticationException {
        if (this.getMutableAuthenticationService() == null) {
            throw new AuthenticationException("Unable to update authentication as there is no suitable authentication service.");
        }
        this.getMutableAuthenticationService().updateAuthentication(userName, oldPassword, newPassword);
    }

    @Override
    public void setAuthentication(String userName, char[] newPassword) throws AuthenticationException {
        if (this.getMutableAuthenticationService() == null) {
            throw new AuthenticationException("Unable to set authentication as there is no suitable authentication service.");
        }
        this.getMutableAuthenticationService().setAuthentication(userName, newPassword);
    }

    @Override
    public void deleteAuthentication(String userName) throws AuthenticationException {
        if (this.getMutableAuthenticationService() == null) {
            throw new AuthenticationException("Unable to delete authentication as there is no suitable authentication service.");
        }
        this.getMutableAuthenticationService().deleteAuthentication(userName);
    }

    @Override
    public void setAuthenticationEnabled(String userName, boolean enabled) throws AuthenticationException {
        if (this.getMutableAuthenticationService() == null) {
            throw new AuthenticationException("Unable to set authentication enabled as there is no suitable authentication service.");
        }
        this.getMutableAuthenticationService().setAuthenticationEnabled(userName, enabled);
    }

    @Override
    public boolean isAuthenticationMutable(String userName) {
        MutableAuthenticationService mutableAuthenticationService = this.getMutableAuthenticationService();
        return mutableAuthenticationService == null ? false : mutableAuthenticationService.isAuthenticationMutable(userName);
    }

    @Override
    public boolean isAuthenticationCreationAllowed() {
        MutableAuthenticationService mutableAuthenticationService = this.getMutableAuthenticationService();
        return mutableAuthenticationService == null ? false : mutableAuthenticationService.isAuthenticationCreationAllowed();
    }

    @Override
    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        MutableAuthenticationService mutableAuthenticationService;
        if (this.isAuthenticationMutable(userName) && (mutableAuthenticationService = this.getMutableAuthenticationService()) != null) {
            return mutableAuthenticationService.getAuthenticationEnabled(userName);
        }
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                if (!authService.getAuthenticationEnabled(userName)) continue;
                return true;
            }
            catch (AuthenticationException e) {
            }
        }
        return false;
    }

    @Override
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        this.preAuthenticationCheck(userName);
        List<AuthenticationService> usableAuthenticationServices = this.getUsableAuthenticationServices();
        int counter = usableAuthenticationServices.size();
        for (AuthenticationService authService : usableAuthenticationServices) {
            try {
                --counter;
                authService.authenticate(userName, password);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("authenticate " + userName + " with " + this.getId(authService) + " SUCCEEDED"));
                }
                return;
            }
            catch (AuthenticationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("authenticate " + userName + " with " + this.getId(authService) + (counter == 0 ? " FAILED (end of chain)" : " failed (try next in chain)")));
            }
        }
        throw new AuthenticationException("Failed to authenticate");
    }

    protected String getId(AuthenticationService authService) {
        return authService.getClass().getSimpleName();
    }

    @Override
    public void authenticateAsGuest() throws AuthenticationException {
        String defaultGuestName = AuthenticationUtil.getGuestUserName();
        if (defaultGuestName != null && defaultGuestName.length() > 0) {
            this.preAuthenticationCheck(defaultGuestName);
        }
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.authenticateAsGuest();
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Guest authentication not supported");
    }

    @Override
    public boolean guestUserAuthenticationAllowed() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            if (!authService.guestUserAuthenticationAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean authenticationExists(String userName) {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            if (!authService.authenticationExists(userName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.getCurrentUserName();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        return null;
    }

    @Override
    public void invalidateUserSession(String userName) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.invalidateUserSession(userName);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Unable to invalidate user session");
    }

    @Override
    public void invalidateTicket(String ticket) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.invalidateTicket(ticket);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Unable to invalidate ticket");
    }

    @Override
    public void validate(String ticket) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.validate(ticket);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Unable to validate ticket");
    }

    @Override
    public String getCurrentTicket() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.getCurrentTicket();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        throw new AuthenticationException("Unable to issue ticket");
    }

    @Override
    public String getNewTicket() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.getNewTicket();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        throw new AuthenticationException("Unable to issue ticket");
    }

    @Override
    public void clearCurrentSecurityContext() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.clearCurrentSecurityContext();
                return;
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        throw new AuthenticationException("Failed to clear security context");
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.isCurrentUserTheSystemUser();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        return false;
    }

    @Override
    public Set<String> getDomains() {
        HashSet<String> domains = new HashSet<String>();
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            domains.addAll(authService.getDomains());
        }
        return domains;
    }

    @Override
    public Set<String> getDomainsThatAllowUserCreation() {
        HashSet<String> domains = new HashSet<String>();
        if (this.getMutableAuthenticationService() != null) {
            domains.addAll(this.getMutableAuthenticationService().getDomainsThatAllowUserCreation());
        }
        return domains;
    }

    @Override
    public Set<String> getDomainsThatAllowUserDeletion() {
        HashSet<String> domains = new HashSet<String>();
        if (this.getMutableAuthenticationService() != null) {
            domains.addAll(this.getMutableAuthenticationService().getDomainsThatAllowUserDeletion());
        }
        return domains;
    }

    @Override
    public Set<String> getDomiansThatAllowUserPasswordChanges() {
        HashSet<String> domains = new HashSet<String>();
        if (this.getMutableAuthenticationService() != null) {
            domains.addAll(this.getMutableAuthenticationService().getDomiansThatAllowUserPasswordChanges());
        }
        return domains;
    }

    @Override
    public Set<String> getUsersWithTickets(boolean nonExpiredOnly) {
        HashSet<String> users = new HashSet<String>();
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            if (!(authService instanceof AbstractAuthenticationService)) continue;
            users.addAll(((AbstractAuthenticationService)authService).getUsersWithTickets(nonExpiredOnly));
        }
        return users;
    }

    @Override
    public int countTickets(boolean nonExpiredOnly) {
        int count = 0;
        for (TicketComponent tc : this.getTicketComponents()) {
            count += tc.countTickets(nonExpiredOnly);
        }
        return count;
    }

    @Override
    public int invalidateTickets(boolean nonExpiredOnly) {
        int count = 0;
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            if (!(authService instanceof AbstractAuthenticationService)) continue;
            count += ((AbstractAuthenticationService)authService).invalidateTickets(nonExpiredOnly);
        }
        return count;
    }

    @Override
    public Set<TicketComponent> getTicketComponents() {
        HashSet<TicketComponent> tcs = new HashSet<TicketComponent>();
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            if (!(authService instanceof AbstractAuthenticationService)) continue;
            tcs.addAll(((AbstractAuthenticationService)authService).getTicketComponents());
        }
        return tcs;
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        TreeSet<String> defaultAdministratorUserNames = new TreeSet<String>();
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            defaultAdministratorUserNames.addAll(authService.getDefaultAdministratorUserNames());
        }
        return defaultAdministratorUserNames;
    }

    @Override
    public Set<String> getDefaultGuestUserNames() {
        TreeSet<String> defaultGuestUserNames = new TreeSet<String>();
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            defaultGuestUserNames.addAll(authService.getDefaultGuestUserNames());
        }
        return defaultGuestUserNames;
    }
}

