/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.transaction.RetryingTransactionHelper;

public class AuthenticationComponentImpl
extends AbstractAuthenticationComponent
implements NLTMAuthenticator {
    private MutableAuthenticationDao authenticationDao;
    AuthenticationManager authenticationManager;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    @Override
    protected void authenticateImpl(final String userName, final char[] password) throws AuthenticationException {
        try {
            String normalized = this.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                        public String doWork() throws Exception {
                            String normalized = AuthenticationComponentImpl.this.getPersonService().getUserIdentifier(userName);
                            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)(normalized == null ? userName : normalized), (Object)new String(password));
                            AuthenticationComponentImpl.this.authenticationManager.authenticate((Authentication)authentication);
                            return normalized;
                        }
                    }, (String)AuthenticationComponentImpl.this.getSystemUserName(AuthenticationComponentImpl.this.getUserDomain(userName)));
                }
            }, true);
            if (normalized == null) {
                this.setCurrentUser(userName, AuthenticationComponent.UserNameValidationMode.CHECK_AND_FIX);
            } else {
                this.setCurrentUser(normalized, AuthenticationComponent.UserNameValidationMode.NONE);
            }
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println(ae.toString());
            ae.printStackTrace(out);
            out.close();
            throw new AuthenticationException(sw.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UserDetails getUserDetails(String userName) {
        if (AuthenticationUtil.isMtEnabled()) {
            Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
            try {
                if (originalFullAuthentication == null) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)this.getSystemUserName(this.getUserDomain(userName)));
                }
                UserDetails userDetails = this.authenticationDao.loadUserByUsername(userName);
                return userDetails;
            }
            finally {
                if (originalFullAuthentication == null) {
                    ContextHolder.setContext(null);
                }
            }
        }
        return this.authenticationDao.loadUserByUsername(userName);
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        return this.authenticationDao.getMD4HashedPassword(userName);
    }

    @Override
    public Authentication authenticate(Authentication token) throws AuthenticationException {
        throw new AlfrescoRuntimeException("Authentication via token not supported");
    }

    @Override
    public NTLMMode getNTLMMode() {
        return NTLMMode.MD4_PROVIDER;
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return true;
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        return Collections.singleton(AuthenticationUtil.getAdminUserName());
    }
}

