/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;

public class DuplicateAuthorityTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private NodeRef rootNodeRef;
    private NodeRef workingRootNodeRef;
    private AuthorityService authorityService;
    private PersonService personService;
    private static ThreadGroup threadGroup = new ThreadGroup("DuplicateAuthorityTest");
    private static int threadNumber = -1;

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        this.retryingTransactionHelper.setMaxRetryWaitMs(10);
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.personService = (PersonService)ctx.getBean("personService");
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                DuplicateAuthorityTest.this.authenticationComponent.setCurrentUser(DuplicateAuthorityTest.this.authenticationComponent.getSystemUserName());
                StoreRef storeRef = DuplicateAuthorityTest.this.nodeService.createStore("workspace", DuplicateAuthorityTest.this.getName() + System.currentTimeMillis());
                DuplicateAuthorityTest.this.rootNodeRef = DuplicateAuthorityTest.this.nodeService.getRootNode(storeRef);
                NodeRef nodeRef = DuplicateAuthorityTest.this.nodeService.createNode(DuplicateAuthorityTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
                return nodeRef;
            }
        };
        this.workingRootNodeRef = this.retryingTransactionHelper.doInTransaction(callback, false, true);
    }

    public void tearDown() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback1 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() {
                for (int i = 0; i <= 11; ++i) {
                    if (!DuplicateAuthorityTest.this.authorityService.authorityExists("GROUP_" + i)) continue;
                    DuplicateAuthorityTest.this.authorityService.deleteAuthority("GROUP_" + i);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(callback1, false, true);
    }

    public void testDuplicateGroupDetection() throws Exception {
    }

    public void testDuplicatePersonDetection() throws Exception {
    }

    private class PersonThread
    extends Thread {
        private CountDownLatch endLatch;
        private Throwable error;
        private String success;

        public PersonThread(CountDownLatch endLatch) {
            super(threadGroup, "Worker " + ++threadNumber);
            this.endLatch = endLatch;
        }

        @Override
        public void run() {
            String result = null;
            int number = 0;
            while (true) {
                CreatePersonCallback callback = new CreatePersonCallback(number);
                try {
                    System.out.println("Thread " + this.getName() + " attempting file: " + number);
                    System.out.flush();
                    this.success = result = DuplicateAuthorityTest.this.retryingTransactionHelper.doInTransaction(callback, false, true);
                }
                catch (DataIntegrityViolationException e) {
                    ++number;
                    continue;
                }
                catch (Throwable e) {
                    this.error = e;
                }
                break;
            }
            if (this.error != null) {
                System.err.println("Thread " + this.getName() + " failed to create file " + number + ":");
                System.err.flush();
                this.error.printStackTrace();
            } else {
                System.out.println("\t\t\tThread " + this.getName() + " created auth: " + this.success);
                System.out.flush();
            }
            this.endLatch.countDown();
        }

        static /* synthetic */ Throwable access$700(PersonThread x0) {
            return x0.error;
        }

        static /* synthetic */ String access$800(PersonThread x0) {
            return x0.success;
        }
    }

    private class AuthThread
    extends Thread {
        private CountDownLatch endLatch;
        private Throwable error;
        private String success;

        public AuthThread(CountDownLatch endLatch) {
            super(threadGroup, "Worker " + ++threadNumber);
            this.endLatch = endLatch;
        }

        @Override
        public void run() {
            String result = null;
            int number = 0;
            while (true) {
                CreateAuthorityCallback callback = new CreateAuthorityCallback(number);
                try {
                    System.out.println("Thread " + this.getName() + " attempting file: " + number);
                    System.out.flush();
                    this.success = result = DuplicateAuthorityTest.this.retryingTransactionHelper.doInTransaction(callback, false, true);
                }
                catch (DataIntegrityViolationException e) {
                    ++number;
                    continue;
                }
                catch (Throwable e) {
                    this.error = e;
                }
                break;
            }
            if (this.error != null) {
                System.err.println("Thread " + this.getName() + " failed to create file " + number + ":");
                System.err.flush();
                this.error.printStackTrace();
            } else {
                System.out.println("\t\t\tThread " + this.getName() + " created auth: " + this.success);
                System.out.flush();
            }
            this.endLatch.countDown();
        }

        static /* synthetic */ Throwable access$400(AuthThread x0) {
            return x0.error;
        }

        static /* synthetic */ String access$500(AuthThread x0) {
            return x0.success;
        }
    }

    private class CreatePersonCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private final int number;

        public CreatePersonCallback(int number) {
            this.number = number;
        }

        @Override
        public String execute() throws Throwable {
            DuplicateAuthorityTest.this.authenticationComponent.setCurrentUser(DuplicateAuthorityTest.this.authenticationComponent.getSystemUserName());
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)("Person_" + this.number)));
            properties.put(ContentModel.PROP_HOMEFOLDER, (Serializable)DuplicateAuthorityTest.this.rootNodeRef);
            properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)("Person_" + this.number)));
            properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)("Person_" + this.number)));
            properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)("Person_" + this.number)));
            properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)("Person_" + this.number)));
            DuplicateAuthorityTest.this.personService.createPerson(properties);
            return "Person_" + this.number;
        }
    }

    private class CreateAuthorityCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private final int number;

        public CreateAuthorityCallback(int number) {
            this.number = number;
        }

        @Override
        public String execute() throws Throwable {
            DuplicateAuthorityTest.this.authenticationComponent.setCurrentUser(DuplicateAuthorityTest.this.authenticationComponent.getSystemUserName());
            return DuplicateAuthorityTest.this.authorityService.createAuthority(AuthorityType.GROUP, "" + this.number);
        }
    }
}

