/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.ArrayList;
import org.alfresco.model.ContentModel;
import org.alfresco.query.AbstractCannedQueryFactory;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.GetAuthoritiesCannedQuery;
import org.alfresco.repo.security.authority.GetAuthoritiesCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;

public class GetAuthoritiesCannedQueryFactory
extends AbstractCannedQueryFactory<AuthorityInfo> {
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private CannedQueryDAO cannedQueryDAO;
    private TenantService tenantService;
    private MethodSecurityBean<AuthorityInfo> methodSecurity;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setCannedQueryDAO(CannedQueryDAO cannedQueryDAO) {
        this.cannedQueryDAO = cannedQueryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMethodSecurity(MethodSecurityBean<AuthorityInfo> methodSecurity) {
        this.methodSecurity = methodSecurity;
    }

    public CannedQuery<AuthorityInfo> getCannedQuery(CannedQueryParameters parameters) {
        return new GetAuthoritiesCannedQuery(this.cannedQueryDAO, this.tenantService, this.methodSecurity, parameters);
    }

    public CannedQuery<AuthorityInfo> getCannedQuery(AuthorityType type, NodeRef containerRef, String displayNameFilter, boolean sortByDisplayName, boolean sortAscending, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"containerRef", (Object)containerRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        int requestTotalCountMax = pagingRequest.getRequestTotalCountMax();
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(this.tenantService.getName(containerRef));
        if (nodePair == null) {
            throw new InvalidNodeRefException("Container ref does not exist: " + containerRef, containerRef);
        }
        Long containerNodeId = (Long)nodePair.getFirst();
        Long qnameAuthDisplayNameId = Long.MIN_VALUE;
        Pair<Long, QName> qnameAuthDisplayNamePair = this.qnameDAO.getQName(ContentModel.PROP_AUTHORITY_DISPLAY_NAME);
        if (qnameAuthDisplayNamePair != null) {
            qnameAuthDisplayNameId = (Long)qnameAuthDisplayNamePair.getFirst();
        }
        GetAuthoritiesCannedQueryParams paramBean = new GetAuthoritiesCannedQueryParams(type, containerNodeId, qnameAuthDisplayNameId, displayNameFilter);
        CannedQueryPageDetails cqpd = new CannedQueryPageDetails(pagingRequest.getSkipCount(), pagingRequest.getMaxItems(), 1, 1);
        CannedQuerySortDetails cqsd = null;
        if (sortByDisplayName) {
            ArrayList<Pair> sortPairs = new ArrayList<Pair>(1);
            sortPairs.add(new Pair((Object)"sortByName", (Object)(sortAscending ? CannedQuerySortDetails.SortOrder.ASCENDING : CannedQuerySortDetails.SortOrder.DESCENDING)));
            cqsd = new CannedQuerySortDetails(sortPairs);
        }
        CannedQueryParameters params = new CannedQueryParameters((Object)paramBean, cqpd, cqsd, requestTotalCountMax, pagingRequest.getQueryExecutionId());
        return this.getCannedQuery(params);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)((Object)this), (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"cannedQueryDAO", (Object)this.cannedQueryDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"methodSecurity", this.methodSecurity);
    }
}

