/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryFactory;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteDoesNotExistException;
import org.alfresco.repo.site.SiteInfoImpl;
import org.alfresco.repo.site.SiteMemberInfoImpl;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.site.SiteServiceInternal;
import org.alfresco.repo.site.SitesPermissionCleaner;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.security.PublicServiceAccessService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteMemberInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public class SiteServiceImpl
extends AbstractLifecycleBean
implements SiteServiceInternal,
SiteModel,
NodeServicePolicies.OnRestoreNodePolicy {
    private static Log logger = LogFactory.getLog(SiteServiceImpl.class);
    public static final StoreRef SITE_STORE = new StoreRef("workspace://SpacesStore");
    private static final String ACTIVITY_TOOL = "siteService";
    private static final String SITE_PREFIX = "site_";
    private static final String GROUP_SITE_PREFIX = "GROUP_site_";
    private static final int GROUP_PREFIX_LENGTH = "GROUP_".length();
    private static final int GROUP_SITE_PREFIX_LENGTH = "GROUP_site_".length();
    private Map<String, NodeRef> siteHomeRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private Map<String, NodeRef> siteNodeRefs = new ConcurrentHashMap<String, NodeRef>(256);
    private String sitesXPath;
    private static final String MSG_UNABLE_TO_CREATE = "site_service.unable_to_create";
    private static final String MSG_SITE_SHORT_NAME_TOO_LONG = "site_service.short_name_too_long";
    private static final String MSG_VISIBILITY_GROUP_MISSING = "site_service.visibility_group_missing";
    private static final String MSG_CAN_NOT_UPDATE = "site_service.can_not_update";
    private static final String MSG_CAN_NOT_DELETE = "site_service.can_not_delete";
    private static final String MSG_CAN_NOT_REMOVE_MSHIP = "site_service.can_not_remove_membership";
    private static final String MSG_DO_NOT_CHANGE_MGR = "site_service.do_not_change_manager";
    private static final String MSG_CAN_NOT_CHANGE_MSHIP = "site_service.can_not_change_membership";
    private static final String MSG_SITE_CONTAINER_NOT_FOLDER = "site_service.site_container_not_folder";
    private static final String MSG_INVALID_SITE_TYPE = "site_service.invalid_site_type";
    private NodeService nodeService;
    private NodeService directNodeService;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private PermissionService permissionService;
    private ActivityService activityService;
    private PersonService personService;
    private AuthenticationContext authenticationContext;
    private TaggingService taggingService;
    private AuthorityService authorityService;
    private DictionaryService dictionaryService;
    private TenantService tenantService;
    private TenantAdminService tenantAdminService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private Comparator<String> roleComparator;
    private SysAdminParams sysAdminParams;
    private BehaviourFilter behaviourFilter;
    private SitesPermissionCleaner sitesPermissionsCleaner;
    private PolicyComponent policyComponent;
    private PublicServiceAccessService publicServiceAccessService;
    private NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry;

    public void setSitesXPath(String sitesXPath) {
        this.sitesXPath = sitesXPath;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDirectNodeService(NodeService directNodeService) {
        this.directNodeService = directNodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRoleComparator(Comparator<String> roleComparator) {
        this.roleComparator = roleComparator;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setSitesPermissionsCleaner(SitesPermissionCleaner sitesPermissionsCleaner) {
        this.sitesPermissionsCleaner = sitesPermissionsCleaner;
    }

    public void setPublicServiceAccessService(PublicServiceAccessService publicServiceAccessService) {
        this.publicServiceAccessService = publicServiceAccessService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public Comparator<String> getRoleComparator() {
        return this.roleComparator;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"directNodeService", (Object)this.directNodeService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationContext", (Object)this.authenticationContext);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"activityService", (Object)this.activityService);
        PropertyCheck.mandatory((Object)this, (String)"taggingService", (Object)this.taggingService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"sitesXPath", (Object)this.sitesXPath);
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRestoreNodePolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "onRestoreNode"));
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    @Override
    public boolean hasCreateSitePermissions() {
        return this.publicServiceAccessService.hasAccess("SiteService", "createSite", "", "", "", "", true) == AccessStatus.ALLOWED;
    }

    @Override
    public SiteInfo createSite(String sitePreset, String passedShortName, String title, String description, boolean isPublic) {
        SiteVisibility visibility = SiteVisibility.PRIVATE;
        if (isPublic) {
            visibility = SiteVisibility.PUBLIC;
        }
        return this.createSite(sitePreset, passedShortName, title, description, visibility);
    }

    @Override
    public SiteInfo createSite(String sitePreset, String passedShortName, String title, String description, SiteVisibility visibility) {
        return this.createSite(sitePreset, passedShortName, title, description, visibility, SiteModel.TYPE_SITE);
    }

    @Override
    public SiteInfo createSite(String sitePreset, String passedShortName, String title, String description, SiteVisibility visibility, final QName siteType) {
        if (!SiteModel.TYPE_SITE.equals((Object)siteType) && !this.dictionaryService.isSubClass(siteType, TYPE_SITE)) {
            throw new SiteServiceException(MSG_INVALID_SITE_TYPE, new Object[]{siteType});
        }
        final String shortName = passedShortName.replaceAll(" ", "");
        NodeRef existingSite = this.getSiteNodeRef(shortName, false);
        if (existingSite != null) {
            throw new SiteServiceException(MSG_UNABLE_TO_CREATE, new Object[]{shortName});
        }
        int longestPermissionLength = 0;
        for (String permission : this.permissionService.getSettablePermissions(siteType)) {
            if (permission.length() <= longestPermissionLength) continue;
            longestPermissionLength = permission.length();
        }
        int maximumPermisionGroupLength = 99 - longestPermissionLength;
        if (this.getSiteGroup(shortName, true).length() > maximumPermisionGroupLength) {
            throw new SiteServiceException(MSG_SITE_SHORT_NAME_TOO_LONG, new Object[]{shortName, maximumPermisionGroupLength - this.getSiteGroup("", true).length()});
        }
        final NodeRef siteParent = this.getSiteParent(shortName);
        if (siteParent == null) {
            throw new SiteServiceException("No root sites folder exists");
        }
        final PropertyMap properties = new PropertyMap(4);
        properties.put(ContentModel.PROP_NAME, shortName);
        properties.put(SiteModel.PROP_SITE_PRESET, sitePreset);
        properties.put(SiteModel.PROP_SITE_VISIBILITY, visibility.toString());
        properties.put(ContentModel.PROP_TITLE, title);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        NodeRef siteNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImpl.this.nodeService.createNode(siteParent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)shortName), siteType, (Map)properties).getChildRef();
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.taggingService.addTagScope(siteNodeRef);
        this.permissionService.setInheritParentPermissions(siteNodeRef, false);
        this.setupSitePermissions(siteNodeRef, shortName, visibility, null);
        Map<QName, Serializable> customProperties = this.getSiteCustomProperties(siteNodeRef);
        SiteInfoImpl siteInfo = new SiteInfoImpl(sitePreset, shortName, title, description, visibility, customProperties, siteNodeRef);
        return siteInfo;
    }

    private void setupSitePermissions(final NodeRef siteNodeRef, final String shortName, final SiteVisibility visibility, final Map<String, Set<String>> memberships) {
        final String currentUser = this.authenticationContext.getCurrentUserName();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public String doWork() throws Exception {
                HashSet<String> shareZones = new HashSet<String>(2, 1.0f);
                shareZones.add("APP.SHARE");
                shareZones.add("AUTH.ALF");
                String sitePublicGroup = SiteServiceImpl.this.sysAdminParams.getSitePublicGroup();
                boolean publicGroupExists = SiteServiceImpl.this.authorityService.authorityExists(sitePublicGroup);
                if (!("GROUP_EVERYONE".equals(sitePublicGroup) || publicGroupExists || SiteVisibility.PRIVATE.equals((Object)visibility))) {
                    throw new SiteServiceException(SiteServiceImpl.MSG_VISIBILITY_GROUP_MISSING, new Object[]{sitePublicGroup});
                }
                String siteGroupShortName = SiteServiceImpl.this.getSiteGroup(shortName, false);
                String siteGroup = SiteServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, siteGroupShortName, siteGroupShortName, shareZones);
                QName siteType = SiteServiceImpl.this.directNodeService.getType(siteNodeRef);
                Set permissions = SiteServiceImpl.this.permissionService.getSettablePermissions(siteType);
                for (String permission : permissions) {
                    String permissionGroupShortName = SiteServiceImpl.this.getSiteRoleGroup(shortName, permission, false);
                    String permissionGroup = SiteServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, permissionGroupShortName, permissionGroupShortName, shareZones);
                    SiteServiceImpl.this.authorityService.addAuthority(siteGroup, permissionGroup);
                    String siteRoleGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, permission, true);
                    if (memberships != null && memberships.containsKey(siteRoleGroup)) {
                        for (String authority : (Set)memberships.get(siteRoleGroup)) {
                            SiteServiceImpl.this.authorityService.addAuthority(siteRoleGroup, authority);
                        }
                    }
                    SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, permissionGroup, permission, true);
                }
                if (SiteVisibility.PUBLIC.equals((Object)visibility) && permissions.contains("SiteConsumer")) {
                    SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, sitePublicGroup, "SiteConsumer", true);
                } else if (SiteVisibility.MODERATED.equals((Object)visibility) && permissions.contains("SiteConsumer")) {
                    SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, sitePublicGroup, "SiteConsumer", true);
                }
                SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, "GROUP_EVERYONE", "ReadPermissions", true);
                if (memberships == null) {
                    SiteServiceImpl.this.authorityService.addAuthority(SiteServiceImpl.this.getSiteRoleGroup(shortName, "SiteManager", true), currentUser);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private Map<QName, Serializable> getSiteCustomProperties(Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> customProperties = new HashMap<QName, Serializable>(4);
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            if (!entry.getKey().getNamespaceURI().equals("http://www.alfresco.org/model/sitecustomproperty/1.0")) continue;
            customProperties.put(entry.getKey(), entry.getValue());
        }
        return customProperties;
    }

    private Map<QName, Serializable> getSiteCustomProperties(NodeRef siteNodeRef) {
        HashMap<QName, Serializable> customProperties = new HashMap<QName, Serializable>(4);
        Map properties = this.directNodeService.getProperties(siteNodeRef);
        for (Map.Entry entry : properties.entrySet()) {
            if (!((QName)entry.getKey()).getNamespaceURI().equals("http://www.alfresco.org/model/sitecustomproperty/1.0")) continue;
            customProperties.put((QName)entry.getKey(), (Serializable)entry.getValue());
        }
        return customProperties;
    }

    @Override
    public String getSiteGroup(String shortName) {
        return this.getSiteGroup(shortName, true);
    }

    @Override
    public String getSiteRoleGroup(String shortName, String role) {
        return this.getSiteRoleGroup(shortName, role, true);
    }

    public String getSiteGroup(String shortName, boolean withGroupPrefix) {
        StringBuffer sb = new StringBuffer(64);
        if (withGroupPrefix) {
            sb.append("GROUP_");
        }
        sb.append(SITE_PREFIX);
        sb.append(shortName);
        return sb.toString();
    }

    public String getSiteRoleGroup(String shortName, String permission, boolean withGroupPrefix) {
        return this.getSiteGroup(shortName, withGroupPrefix) + '_' + permission;
    }

    private NodeRef getSiteParent(String shortName) {
        return this.getSiteRoot();
    }

    @Override
    public NodeRef getSiteRoot() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        NodeRef siteHomeRef = this.siteHomeRefs.get(tenantDomain);
        if (siteHomeRef == null && (siteHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() throws Exception {
                        NodeRef result = null;
                        NodeRef rootNodeRef = SiteServiceImpl.this.directNodeService.getRootNode(SITE_STORE);
                        List results = SiteServiceImpl.this.searchService.selectNodes(rootNodeRef, SiteServiceImpl.this.sitesXPath, null, (NamespacePrefixResolver)SiteServiceImpl.this.namespaceService, false, "xpath");
                        if (results.size() != 0) {
                            result = (NodeRef)results.get(0);
                        }
                        return result;
                    }
                }, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName())) != null) {
            this.siteHomeRefs.put(tenantDomain, siteHomeRef);
        }
        return siteHomeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SiteInfo> findSites(String filter, String sitePresetFilter, int size) {
        List<SiteInfo> result;
        NodeRef siteRoot = this.getSiteRoot();
        if (siteRoot == null) {
            result = Collections.emptyList();
        } else {
            boolean sitePresetFilterIsPresent;
            StringBuilder query = new StringBuilder(128);
            query.append("+PARENT:\"").append(siteRoot.toString()).append('\"');
            boolean filterIsPresent = filter != null && filter.length() > 0;
            boolean filterIsPresentAndNecessary = filterIsPresent && !filter.equals("*");
            boolean bl = sitePresetFilterIsPresent = sitePresetFilter != null && sitePresetFilter.length() > 0;
            if (filterIsPresentAndNecessary || sitePresetFilterIsPresent) {
                query.append(" +(");
                if (filterIsPresentAndNecessary) {
                    String escNameFilter = AbstractLuceneQueryParser.escape((String)filter.replace('\"', ' '));
                    query.append(" @cm\\:name:\"*" + escNameFilter + "*\"").append(" @cm\\:title:\"" + escNameFilter + "\"").append(" @cm\\:description:\"" + escNameFilter + "\"");
                }
                if (sitePresetFilterIsPresent) {
                    String escPresetFilter = AbstractLuceneQueryParser.escape((String)sitePresetFilter.replace('\"', ' '));
                    query.append(" @st\\:sitePreset:\"" + escPresetFilter + "\"");
                }
                query.append(")");
            }
            SearchParameters sp = new SearchParameters();
            sp.addStore(siteRoot.getStoreRef());
            sp.setLanguage("lucene");
            sp.setQuery(query.toString());
            if (size > 0) {
                sp.setLimit(size);
                sp.setLimitBy(LimitBy.FINAL_SIZE);
            }
            ResultSet results = this.searchService.query(sp);
            try {
                result = new ArrayList<SiteInfo>(results.length());
                for (NodeRef site : results.getNodeRefs()) {
                    QName siteClassName = this.nodeService.getType(site);
                    if (!this.dictionaryService.isSubClass(siteClassName, SiteModel.TYPE_SITE)) continue;
                    result.add(this.createSiteInfo(site));
                }
            }
            finally {
                results.close();
            }
        }
        return result;
    }

    @Override
    public List<SiteInfo> listSites(String nameFilter, String sitePresetFilter) {
        return this.listSites(nameFilter, sitePresetFilter, -1);
    }

    @Override
    public List<SiteInfo> listSites(String filter, String sitePresetFilter, int size) {
        List result = Collections.emptyList();
        NodeRef siteRoot = this.getSiteRoot();
        if (siteRoot != null) {
            boolean filterHasValue = filter != null && filter.length() != 0;
            boolean sitePresetFilterHasValue = sitePresetFilter != null && sitePresetFilter.length() > 0;
            List<Pair<QName, Boolean>> sortProps = null;
            PagingRequest pagingRequest = new PagingRequest(size <= 0 ? Integer.MAX_VALUE : size);
            ArrayList<FilterProp> filterProps = new ArrayList<FilterProp>();
            if (filterHasValue) {
                filterProps.add(new FilterPropString(ContentModel.PROP_NAME, filter, FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
                filterProps.add(new FilterPropString(ContentModel.PROP_TITLE, filter, FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
                filterProps.add(new FilterPropString(ContentModel.PROP_DESCRIPTION, filter, FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
            }
            if (sitePresetFilterHasValue) {
                filterProps.add(new FilterPropString(SiteModel.PROP_SITE_PRESET, sitePresetFilter, FilterPropString.FilterTypeString.EQUALS));
            }
            PagingResults<SiteInfo> allSites = this.listSites(filterProps, sortProps, pagingRequest);
            result = allSites.getPage();
        }
        return result;
    }

    @Override
    public List<SiteInfo> listSites(String userName) {
        return this.listSites(userName, 0);
    }

    @Override
    public List<SiteInfo> listSites(final String userName, final int size) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantUser(userName)) {
            String tenantDomain = this.tenantService.getUserDomain(userName);
            return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<SiteInfo>>(){

                public List<SiteInfo> doWork() throws Exception {
                    return SiteServiceImpl.this.listSitesImpl(userName, size);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.listSitesImpl(userName, size);
    }

    @Override
    public PagingResults<SiteInfo> listSites(List<FilterProp> filterProps, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        HashSet<QName> searchTypeQNames = new HashSet<QName>(1);
        searchTypeQNames.add(SiteModel.TYPE_SITE);
        searchTypeQNames.addAll(this.dictionaryService.getSubTypes(SiteModel.TYPE_SITE, true));
        String cQBeanName = "siteGetChildrenCannedQueryFactory";
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject("siteGetChildrenCannedQueryFactory"));
        GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(this.getSiteRoot(), null, null, searchTypeQNames, filterProps, sortProps, pagingRequest);
        final CannedQueryResults results = cq.execute();
        List nodeRefs = Collections.emptyList();
        if (results.getPageCount() > 0) {
            nodeRefs = (List)results.getPages().get(0);
        }
        final Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
        final ArrayList<SiteInfo> siteInfos = new ArrayList<SiteInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            siteInfos.add(this.createSiteInfo(nodeRef));
        }
        return new PagingResults<SiteInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<SiteInfo> getPage() {
                return siteInfos;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    private String resolveSite(String group) {
        if (group.startsWith(GROUP_SITE_PREFIX)) {
            int roleIndex = group.lastIndexOf(95);
            if (roleIndex + 1 <= GROUP_SITE_PREFIX_LENGTH) {
                return group.substring(GROUP_SITE_PREFIX_LENGTH);
            }
            return group.substring(GROUP_SITE_PREFIX_LENGTH, roleIndex);
        }
        return null;
    }

    private List<SiteInfo> listSitesImpl(String userName, int size) {
        final int maxResults = size > 0 ? size : 1000;
        final TreeSet siteNames = new TreeSet();
        this.authorityService.getContainingAuthoritiesInZone(AuthorityType.GROUP, userName, "APP.SHARE", new AuthorityService.AuthorityFilter(){

            @Override
            public boolean includeAuthority(String authority) {
                if (siteNames.size() < maxResults) {
                    String siteName = SiteServiceImpl.this.resolveSite(authority);
                    if (siteName == null) {
                        return false;
                    }
                    return siteNames.add(siteName);
                }
                return false;
            }
        }, maxResults);
        if (siteNames.isEmpty()) {
            return Collections.emptyList();
        }
        List assocs = this.nodeService.getChildrenByName(this.getSiteRoot(), ContentModel.ASSOC_CONTAINS, siteNames);
        ArrayList<SiteInfo> result = new ArrayList<SiteInfo>(assocs.size());
        for (ChildAssociationRef assoc : assocs) {
            NodeRef site = assoc.getChildRef();
            QName siteClassName = this.directNodeService.getType(site);
            if (!this.dictionaryService.isSubClass(siteClassName, SiteModel.TYPE_SITE)) continue;
            result.add(this.createSiteInfo(site));
        }
        return result;
    }

    private SiteInfo createSiteInfo(NodeRef siteNodeRef) {
        SiteInfoImpl siteInfo = null;
        Map properties = this.directNodeService.getProperties(siteNodeRef);
        String shortName = (String)properties.get(ContentModel.PROP_NAME);
        String sitePreset = (String)properties.get(PROP_SITE_PRESET);
        String title = (String)properties.get(ContentModel.PROP_TITLE);
        String description = (String)properties.get(ContentModel.PROP_DESCRIPTION);
        SiteVisibility visibility = this.getSiteVisibility(siteNodeRef);
        Map<QName, Serializable> customProperties = this.getSiteCustomProperties(properties);
        siteInfo = new SiteInfoImpl(sitePreset, shortName, title, description, visibility, customProperties, siteNodeRef);
        return siteInfo;
    }

    private SiteVisibility getSiteVisibility(NodeRef siteNodeRef) {
        SiteVisibility visibility = SiteVisibility.PRIVATE;
        String visibilityValue = (String)((Object)this.directNodeService.getProperty(siteNodeRef, SiteModel.PROP_SITE_VISIBILITY));
        if (visibilityValue == null) {
            Set permissions;
            try {
                permissions = this.permissionService.getAllSetPermissions(siteNodeRef);
            }
            catch (AccessDeniedException ae) {
                return visibility;
            }
            for (AccessPermission permission : permissions) {
                if (!permission.getAuthority().equals("GROUP_EVERYONE") || !permission.getPermission().equals("SiteConsumer")) continue;
                visibility = SiteVisibility.PUBLIC;
                break;
            }
        } else {
            visibility = SiteVisibility.valueOf(visibilityValue);
        }
        return visibility;
    }

    @Override
    public SiteInfo getSite(final String shortName) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantName(shortName)) {
            String tenantDomain = this.tenantService.getDomain(shortName);
            final String sName = this.tenantService.getBaseName(shortName, true);
            return (SiteInfo)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteInfo>(){

                public SiteInfo doWork() throws Exception {
                    SiteInfo site = SiteServiceImpl.this.getSiteImpl(sName);
                    return new SiteInfoImpl(site.getSitePreset(), shortName, site.getTitle(), site.getDescription(), site.getVisibility(), site.getCustomProperties(), site.getNodeRef());
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.getSiteImpl(shortName);
    }

    private SiteInfo getSiteImpl(String shortName) {
        SiteInfo result = null;
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef != null) {
            result = this.createSiteInfo(siteNodeRef);
        }
        return result;
    }

    @Override
    public SiteInfo getSite(NodeRef nodeRef) {
        SiteInfo siteInfo = null;
        NodeRef siteNodeRef = this.getSiteNodeRef(nodeRef);
        if (siteNodeRef != null) {
            siteInfo = this.createSiteInfo(siteNodeRef);
        }
        return siteInfo;
    }

    private NodeRef getSiteNodeRef(NodeRef nodeRef) {
        NodeRef siteNodeRef = null;
        QName nodeRefType = this.directNodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(nodeRefType, TYPE_SITE)) {
            siteNodeRef = nodeRef;
        } else {
            ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(nodeRef);
            if (primaryParent != null && primaryParent.getParentRef() != null) {
                siteNodeRef = this.getSiteNodeRef(primaryParent.getParentRef());
            }
        }
        return siteNodeRef;
    }

    private NodeRef getSiteNodeRef(String shortName) {
        return this.getSiteNodeRef(shortName, true);
    }

    private NodeRef getSiteNodeRef(final String shortName, boolean enforcePermissions) {
        final String cacheKey = this.tenantAdminService.getCurrentUserDomain() + '_' + shortName;
        NodeRef siteNodeRef = this.siteNodeRefs.get(cacheKey);
        if (siteNodeRef != null) {
            if (!this.directNodeService.exists(siteNodeRef)) {
                this.siteNodeRefs.remove(cacheKey);
                siteNodeRef = null;
            }
        } else {
            final NodeRef siteRoot = this.getSiteParent(shortName);
            siteNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef siteNode = SiteServiceImpl.this.directNodeService.getChildByName(siteRoot, ContentModel.ASSOC_CONTAINS, shortName);
                    if (siteNode != null) {
                        SiteServiceImpl.this.siteNodeRefs.put(cacheKey, siteNode);
                    }
                    return siteNode;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
        if (enforcePermissions) {
            return siteNodeRef == null || !this.permissionService.hasPermission(siteNodeRef, "ReadProperties").equals((Object)AccessStatus.ALLOWED) ? null : siteNodeRef;
        }
        return siteNodeRef;
    }

    @Override
    public void updateSite(SiteInfo siteInfo) {
        String shortName = siteInfo.getShortName();
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_CAN_NOT_UPDATE, new Object[]{siteInfo.getShortName()});
        }
        Map properties = this.directNodeService.getProperties(siteNodeRef);
        properties.put(ContentModel.PROP_TITLE, siteInfo.getTitle());
        properties.put(ContentModel.PROP_DESCRIPTION, siteInfo.getDescription());
        SiteVisibility currentVisibility = this.getSiteVisibility(siteNodeRef);
        SiteVisibility updatedVisibility = siteInfo.getVisibility();
        if (!currentVisibility.equals((Object)updatedVisibility)) {
            NodeRef containerNodeRef;
            List<FileInfo> folders;
            logger.debug((Object)("site:" + shortName + " visibility has changed from: " + (Object)((Object)currentVisibility) + "to: " + (Object)((Object)updatedVisibility)));
            String sitePublicGroup = this.sysAdminParams.getSitePublicGroup();
            boolean publicGroupExists = this.authorityService.authorityExists(sitePublicGroup);
            if (!"GROUP_EVERYONE".equals(sitePublicGroup) && !publicGroupExists) {
                throw new SiteServiceException(MSG_VISIBILITY_GROUP_MISSING, new Object[]{sitePublicGroup});
            }
            if (SiteVisibility.PUBLIC.equals((Object)currentVisibility) || SiteVisibility.MODERATED.equals((Object)currentVisibility)) {
                this.permissionService.deletePermission(siteNodeRef, sitePublicGroup, "SiteConsumer");
                if (sitePublicGroup.equals("GROUP_EVERYONE")) {
                    this.permissionService.deletePermission(siteNodeRef, "GROUP_EVERYONE", "SiteConsumer");
                }
            }
            if (SiteVisibility.MODERATED.equals((Object)currentVisibility)) {
                folders = this.fileFolderService.listFolders(siteNodeRef);
                for (FileInfo folder : folders) {
                    containerNodeRef = folder.getNodeRef();
                    this.permissionService.setInheritParentPermissions(containerNodeRef, true);
                }
            }
            if (SiteVisibility.PUBLIC.equals((Object)updatedVisibility)) {
                this.permissionService.setPermission(siteNodeRef, sitePublicGroup, "SiteConsumer", true);
            } else if (SiteVisibility.MODERATED.equals((Object)updatedVisibility)) {
                this.permissionService.setPermission(siteNodeRef, sitePublicGroup, "SiteConsumer", true);
                folders = this.fileFolderService.listFolders(siteNodeRef);
                for (FileInfo folder : folders) {
                    containerNodeRef = folder.getNodeRef();
                    this.setModeratedPermissions(shortName, containerNodeRef);
                }
            } else if (SiteVisibility.PRIVATE.equals((Object)updatedVisibility)) {
                // empty if block
            }
            properties.put(SiteModel.PROP_SITE_VISIBILITY, siteInfo.getVisibility().toString());
        }
        this.nodeService.setProperties(siteNodeRef, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSite(final String shortName) {
        logger.debug((Object)("delete site :" + shortName));
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_CAN_NOT_DELETE, new Object[]{shortName});
        }
        final QName siteType = this.directNodeService.getType(siteNodeRef);
        String cacheKey = this.tenantAdminService.getCurrentUserDomain() + '_' + shortName;
        this.siteNodeRefs.remove(cacheKey);
        final HashMap groupsMemberships = new HashMap();
        this.nodeService.setProperty(siteNodeRef, QName.createQName(null, (String)"memberships"), (Serializable)groupsMemberships);
        this.behaviourFilter.disableBehaviour(siteNodeRef, ContentModel.ASPECT_UNDELETABLE);
        try {
            this.nodeService.deleteNode(siteNodeRef);
        }
        finally {
            this.behaviourFilter.enableBehaviour(siteNodeRef, ContentModel.ASPECT_UNDELETABLE);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String siteGroup = SiteServiceImpl.this.getSiteGroup(shortName, true);
                if (SiteServiceImpl.this.authorityService.authorityExists(siteGroup)) {
                    SiteServiceImpl.this.authorityService.deleteAuthority(siteGroup, false);
                    Set permissions = SiteServiceImpl.this.permissionService.getSettablePermissions(siteType);
                    for (String permission : permissions) {
                        String siteRoleGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, permission, true);
                        Set<String> groupUsers = SiteServiceImpl.this.authorityService.getContainedAuthorities(null, siteRoleGroup, true);
                        groupsMemberships.put(siteRoleGroup, groupUsers);
                        SiteServiceImpl.this.authorityService.deleteAuthority(siteRoleGroup);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        logger.debug((Object)("site deleted :" + shortName));
    }

    @Override
    public void onRestoreNode(ChildAssociationRef childAssocRef) {
        NodeRef siteRef = childAssocRef.getChildRef();
        this.setupSitePermissions(siteRef, (String)((Object)this.directNodeService.getProperty(siteRef, ContentModel.PROP_NAME)), this.getSiteVisibility(siteRef), (Map)((Object)this.directNodeService.getProperty(siteRef, QName.createQName(null, (String)"memberships"))));
    }

    @Override
    public Map<String, String> listMembers(String shortName, String nameFilter, String roleFilter, int size) {
        return this.listMembers(shortName, nameFilter, roleFilter, size, false);
    }

    @Override
    public Map<String, String> listMembers(String shortName, final String nameFilter, final String roleFilter, final int size, final boolean collapseGroups) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantName(shortName)) {
            String tenantDomain = this.tenantService.getDomain(shortName);
            final String sName = this.tenantService.getBaseName(shortName, true);
            return (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, String>>(){

                public Map<String, String> doWork() throws Exception {
                    return SiteServiceImpl.this.listMembersImpl(sName, nameFilter, roleFilter, size, collapseGroups);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.listMembersImpl(shortName, nameFilter, roleFilter, size, collapseGroups);
    }

    @Override
    public List<SiteMemberInfo> listMembersInfo(String shortName, final String nameFilter, final String roleFilter, final int size, final boolean collapseGroups) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantName(shortName)) {
            String tenantDomain = this.tenantService.getDomain(shortName);
            final String sName = this.tenantService.getBaseName(shortName, true);
            return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<SiteMemberInfo>>(){

                public List<SiteMemberInfo> doWork() throws Exception {
                    return SiteServiceImpl.this.listMembersInfoImpl(sName, nameFilter, roleFilter, size, collapseGroups);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.listMembersInfoImpl(shortName, nameFilter, roleFilter, size, collapseGroups);
    }

    private Map<String, String> listMembersImpl(String shortName, String nameFilter, String roleFilter, int size, boolean collapseGroups) {
        HashMap<String, String> members = new HashMap<String, String>(32);
        List<SiteMemberInfo> list = this.listMembersInfoImpl(shortName, nameFilter, roleFilter, size, collapseGroups);
        for (SiteMemberInfo info : list) {
            members.put(info.getMemberName(), info.getMemberRole());
        }
        return members;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private List<SiteMemberInfo> listMembersInfoImpl(String shortName, String nameFilter, String roleFilter, int size, boolean collapseGroups) {
        siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        nameFilterLower = null;
        nameFilters = new String[]{};
        if (nameFilter != null && nameFilter.length() != 0) {
            t = new StringTokenizer(nameFilter, " ");
            nameFilters = new String[t.countTokens()];
            i = 0;
            while (t.hasMoreTokens()) {
                nameFilters[i] = t.nextToken().toLowerCase();
                ++i;
            }
            nameFilterLower = nameFilter.toLowerCase();
        }
        members = new ArrayList<SiteMemberInfo>(32);
        siteType = this.directNodeService.getType(siteNodeRef);
        permissions = this.permissionService.getSettablePermissions(siteType);
        groupsToExpand = new HashMap<String, String>(32);
        block5: for (String permission : permissions) {
            if (roleFilter != null && roleFilter.length() != 0 && !roleFilter.equals(permission)) continue;
            groupName = this.getSiteRoleGroup(shortName, permission, true);
            authorities = this.authorityService.getContainedAuthorities(null, groupName, true);
lbl23:
            // 4 sources

            for (String authority : authorities) {
                switch (17.$SwitchMap$org$alfresco$service$cmr$security$AuthorityType[AuthorityType.getAuthorityType((String)authority).ordinal()]) {
                    case 1: {
                        addUser = true;
                        if (nameFilter != null && nameFilter.length() != 0 && !nameFilter.equals(authority)) {
                            addUser = this.matchPerson(nameFilters, authority);
                        }
                        if (addUser) {
                            members.add(new SiteMemberInfoImpl(authority, permission, false));
                            if (members.size() == size) {
                                break block5;
                            }
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        if (collapseGroups) {
                            if (!groupsToExpand.containsKey(authority)) {
                                groupsToExpand.put(authority, permission);
                                break;
                            }
                        } else {
                            if (nameFilter != null && nameFilter.length() != 0) {
                                if (this.matchByFilter(authority.substring(SiteServiceImpl.GROUP_PREFIX_LENGTH).toLowerCase(), nameFilterLower)) {
                                    members.add(new SiteMemberInfoImpl(authority, permission, false));
                                } else {
                                    displayName = this.authorityService.getAuthorityDisplayName(authority);
                                    if (displayName != null && this.matchByFilter(displayName.toLowerCase(), nameFilterLower)) {
                                        members.add(new SiteMemberInfoImpl(authority, permission, false));
                                    }
                                }
                            } else {
                                members.add(new SiteMemberInfoImpl(authority, permission, false));
                            }
                            if (members.size() == size) break block5;
                        }
                    }
                }
            }
        }
        if (collapseGroups) {
            block7: for (Map.Entry entry : groupsToExpand.entrySet()) {
                subUsers = this.authorityService.getContainedAuthorities(AuthorityType.USER, (String)entry.getKey(), false);
                for (String subUser : subUsers) {
                    addUser = true;
                    if (nameFilter != null && nameFilter.length() != 0 && !nameFilter.equals(subUser)) {
                        addUser = this.matchPerson(nameFilters, subUser);
                    }
                    if (!addUser) continue;
                    memberInfo = new SiteMemberInfoImpl(subUser, (String)entry.getValue(), true);
                    if (!members.contains(memberInfo)) {
                        members.add(memberInfo);
                    }
                    if (members.size() != size) continue;
                    continue block7;
                }
            }
        }
        return members;
    }

    private boolean matchPerson(String[] nameFilters, String username) {
        boolean addUser = false;
        try {
            NodeRef person = this.personService.getPerson(username, false);
            String firstName = (String)((Object)this.directNodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
            String lastName = (String)((Object)this.directNodeService.getProperty(person, ContentModel.PROP_LASTNAME));
            String userName = (String)((Object)this.directNodeService.getProperty(person, ContentModel.PROP_USERNAME));
            String lowFirstName = firstName != null ? firstName.toLowerCase() : "";
            String lowLastName = lastName != null ? lastName.toLowerCase() : "";
            String lowUserName = userName != null ? userName.toLowerCase() : "";
            for (int i = 0; i < nameFilters.length; ++i) {
                if (!this.matchByFilter(lowUserName, nameFilters[i]) && !this.matchByFilter(lowFirstName, nameFilters[i]) && !this.matchByFilter(lowLastName, nameFilters[i])) continue;
                addUser = true;
                break;
            }
        }
        catch (NoSuchPersonException e) {
            // empty catch block
        }
        return addUser;
    }

    private boolean matchByFilter(String compareString, String patternString) {
        if (compareString == null || compareString.isEmpty()) {
            return false;
        }
        if (patternString == null || patternString.isEmpty()) {
            return true;
        }
        StringBuilder paternStr = new StringBuilder();
        for (char c : patternString.toCharArray()) {
            if (c == '*') {
                paternStr.append(".*");
                continue;
            }
            if (c == '(' || c == ')') {
                paternStr.append("\\" + c);
                continue;
            }
            if (Character.isLetterOrDigit(c) || c == '*') {
                paternStr.append(c);
                continue;
            }
            paternStr.append("\\" + c);
        }
        Pattern p = Pattern.compile(paternStr.toString(), 2);
        Matcher matcher = p.matcher(compareString);
        return matcher.matches();
    }

    @Override
    public String getMembersRole(String shortName, String authorityName) {
        String result = null;
        List<String> roles = this.getMembersRoles(shortName, authorityName);
        if (roles.size() != 0) {
            if (roles.size() > 1 && this.roleComparator != null) {
                TreeSet<String> sortedRoles = new TreeSet<String>(this.roleComparator);
                for (String role : roles) {
                    sortedRoles.add(role);
                }
                result = (String)sortedRoles.first();
            } else {
                result = roles.get(0);
            }
        }
        return result;
    }

    public List<String> getMembersRoles(String shortName, String authorityName) {
        ArrayList<String> result = new ArrayList<String>(5);
        List<String> groups = this.getPermissionGroups(shortName, authorityName);
        for (String group : groups) {
            int index = group.lastIndexOf(95);
            if (index == -1) continue;
            result.add(group.substring(index + 1));
        }
        return result;
    }

    private List<String> getPermissionGroups(String siteShortName, String authorityName) {
        NodeRef siteNodeRef = this.getSiteNodeRef(siteShortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(siteShortName);
        }
        ArrayList<String> fullResult = new ArrayList<String>(5);
        QName siteType = this.directNodeService.getType(siteNodeRef);
        Set roles = this.permissionService.getSettablePermissions(siteType);
        Set<String> authorities = this.authorityService.getAuthoritiesForUser(authorityName);
        for (String role : roles) {
            String roleGroup = this.getSiteRoleGroup(siteShortName, role, true);
            if (!authorities.contains(roleGroup)) continue;
            fullResult.add(roleGroup);
        }
        if (fullResult.size() <= 1) {
            return fullResult;
        }
        ArrayList<String> result = new ArrayList<String>(5);
        Set<String> authorityGroups = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, authorityName, true);
        for (String role : roles) {
            String roleGroup = this.getSiteRoleGroup(siteShortName, role, true);
            if (!authorityGroups.contains(roleGroup)) continue;
            result.add(roleGroup);
        }
        return result.size() > 0 ? result : fullResult;
    }

    @Override
    public List<String> getSiteRoles() {
        return this.getSiteRoles(SiteModel.TYPE_SITE);
    }

    @Override
    public List<String> getSiteRoles(String shortName) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        QName siteType = this.directNodeService.getType(siteNodeRef);
        return this.getSiteRoles(siteType);
    }

    public List<String> getSiteRoles(QName type) {
        Set permissions = this.permissionService.getSettablePermissions(type);
        return new ArrayList<String>(permissions);
    }

    @Override
    public boolean isMember(String shortName, String authorityName) {
        return !this.getPermissionGroups(shortName, authorityName).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeMembership(final String shortName, final String authorityName) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        final String role = this.getMembersRole(shortName, authorityName);
        if (role == null) throw new SiteServiceException(MSG_CAN_NOT_REMOVE_MSHIP, new Object[]{shortName});
        this.checkLastManagerRemoval(shortName, authorityName, role);
        if (!currentUserName.equals(authorityName) && this.permissionService.hasPermission(siteNodeRef, "ChangePermissions") != AccessStatus.ALLOWED) throw new SiteServiceException(MSG_CAN_NOT_REMOVE_MSHIP, new Object[]{shortName});
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String currentGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, role, true);
                SiteServiceImpl.this.authorityService.removeAuthority(currentGroup, authorityName);
                return null;
            }
        }, (String)"System");
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
        if (authorityType == AuthorityType.USER) {
            this.activityService.postActivity("org.alfresco.site.user-left", shortName, ACTIVITY_TOOL, this.getActivityUserData(authorityName, ""));
            return;
        } else {
            if (authorityType != AuthorityType.GROUP) return;
            this.activityService.postActivity("org.alfresco.site.group-removed", shortName, ACTIVITY_TOOL, this.getActivityGroupData(authorityName, ""));
        }
    }

    @Override
    public void setMembership(final String shortName, final String authorityName, final String role) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        final String currentRole = this.getMembersRole(shortName, authorityName);
        if (currentRole == null || !role.equals(currentRole)) {
            SiteVisibility visibility = this.getSiteVisibility(siteNodeRef);
            String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
            if (this.permissionService.hasPermission(siteNodeRef, "ChangePermissions") == AccessStatus.ALLOWED || SiteVisibility.PUBLIC.equals((Object)visibility) && role.equals("SiteConsumer") && authorityName.equals(currentUserName) && currentRole == null) {
                this.checkLastManagerRemoval(shortName, authorityName, currentRole);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        if (currentRole != null) {
                            String currentGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, currentRole, true);
                            SiteServiceImpl.this.authorityService.removeAuthority(currentGroup, authorityName);
                        }
                        String newGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, role, true);
                        SiteServiceImpl.this.authorityService.addAuthority(newGroup, authorityName);
                        return null;
                    }
                }, (String)"System");
                if (currentRole == null) {
                    AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
                    if (authorityType == AuthorityType.USER) {
                        this.activityService.postActivity("org.alfresco.site.user-joined", shortName, ACTIVITY_TOOL, this.getActivityUserData(authorityName, role), authorityName);
                    } else if (authorityType == AuthorityType.GROUP) {
                        this.activityService.postActivity("org.alfresco.site.group-added", shortName, ACTIVITY_TOOL, this.getActivityGroupData(authorityName, role));
                    }
                } else {
                    AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
                    if (authorityType == AuthorityType.USER) {
                        this.activityService.postActivity("org.alfresco.site.user-role-changed", shortName, ACTIVITY_TOOL, this.getActivityUserData(authorityName, role));
                    } else if (authorityType == AuthorityType.GROUP) {
                        this.activityService.postActivity("org.alfresco.site.group-role-changed", shortName, ACTIVITY_TOOL, this.getActivityGroupData(authorityName, role));
                    }
                }
            } else {
                throw new SiteServiceException(MSG_CAN_NOT_CHANGE_MSHIP, new Object[]{shortName});
            }
        }
    }

    @Override
    public NodeRef createContainer(String shortName, String componentId, QName containerType, Map<QName, Serializable> containerProperties) {
        ParameterCheck.mandatoryString((String)"componentId", (String)componentId);
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        SiteVisibility siteVisibility = this.getSiteVisibility(siteNodeRef);
        NodeRef containerNodeRef = null;
        try {
            containerNodeRef = this.findContainer(siteNodeRef, componentId);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (containerNodeRef == null) {
            if (containerType == null) {
                containerType = ContentModel.TYPE_FOLDER;
            }
            FileInfo fileInfo = this.fileFolderService.create(siteNodeRef, componentId, containerType);
            containerNodeRef = fileInfo.getNodeRef();
            if (containerProperties != null) {
                Map props = this.directNodeService.getProperties(containerNodeRef);
                props.putAll(containerProperties);
                this.nodeService.setProperties(containerNodeRef, props);
            }
            HashMap<QName, String> aspectProps = new HashMap<QName, String>(1, 1.0f);
            aspectProps.put(SiteModel.PROP_COMPONENT_ID, componentId);
            this.nodeService.addAspect(containerNodeRef, ASPECT_SITE_CONTAINER, aspectProps);
            if (SiteVisibility.MODERATED.equals((Object)siteVisibility)) {
                this.setModeratedPermissions(shortName, containerNodeRef);
            }
            this.taggingService.addTagScope(containerNodeRef);
        }
        return containerNodeRef;
    }

    @Override
    public void cleanSitePermissions(NodeRef targetNode, SiteInfo containingSite) {
        this.sitesPermissionsCleaner.cleanSitePermissions(targetNode, containingSite);
    }

    private void setModeratedPermissions(String shortName, NodeRef containerNodeRef) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        QName siteType = this.directNodeService.getType(siteNodeRef);
        Set permissions = this.permissionService.getSettablePermissions(siteType);
        for (String permission : permissions) {
            String permissionGroup = this.getSiteRoleGroup(shortName, permission, true);
            this.permissionService.setPermission(containerNodeRef, permissionGroup, permission, true);
        }
        this.permissionService.setPermission(containerNodeRef, "GROUP_EVERYONE", "ReadPermissions", true);
        this.permissionService.setInheritParentPermissions(containerNodeRef, false);
    }

    @Override
    public NodeRef getContainer(String shortName, String componentId) {
        ParameterCheck.mandatoryString((String)"componentId", (String)componentId);
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        NodeRef containerNodeRef = null;
        try {
            containerNodeRef = this.findContainer(siteNodeRef, componentId);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return containerNodeRef;
    }

    @Override
    public boolean hasContainer(String shortName, final String componentId) {
        ParameterCheck.mandatoryString((String)"componentId", (String)componentId);
        final NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteDoesNotExistException(shortName);
        }
        boolean hasContainer = false;
        NodeRef containerRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() throws Exception {
                        try {
                            return SiteServiceImpl.this.findContainer(siteNodeRef, componentId);
                        }
                        catch (FileNotFoundException e) {
                            return null;
                        }
                    }
                }, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (containerRef != null) {
            hasContainer = true;
        }
        return hasContainer;
    }

    private NodeRef findContainer(NodeRef siteNodeRef, String componentId) throws FileNotFoundException {
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(componentId);
        FileInfo fileInfo = this.fileFolderService.resolveNamePath(siteNodeRef, paths);
        if (!fileInfo.isFolder()) {
            throw new SiteServiceException(MSG_SITE_CONTAINER_NOT_FOLDER, new Object[]{fileInfo.getName()});
        }
        return fileInfo.getNodeRef();
    }

    public static NodeRef getSiteContainer(final String siteShortName, final String componentName, boolean create, final SiteService siteService, final TransactionService transactionService, final TaggingService taggingService) {
        if (siteService.getSite(siteShortName) == null) {
            if (!create) {
                return null;
            }
            throw new AlfrescoRuntimeException("Unable to create the " + componentName + " container from a hidden or non-existant site");
        }
        if (!siteService.hasContainer(siteShortName, componentName)) {
            if (create) {
                if (transactionService.isReadOnly()) {
                    throw new AlfrescoRuntimeException("Unable to create the " + componentName + " container from a read only transaction");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating " + componentName + " container in site " + siteShortName));
                }
                NodeRef container = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        NodeRef container = siteService.createContainer(siteShortName, componentName, null, null);
                        return container;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created " + componentName + " as " + container + " for " + siteShortName));
                }
                return container;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No " + componentName + " component in " + siteShortName + " and not creating"));
            }
            return null;
        }
        NodeRef containerTmp = null;
        try {
            containerTmp = siteService.getContainer(siteShortName, componentName);
        }
        catch (AccessDeniedException e) {
            if (!create) {
                return null;
            }
            throw e;
        }
        final NodeRef container = containerTmp;
        if (!taggingService.isTagScope(container)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attaching tag scope to " + componentName + " " + container.toString() + " for " + siteShortName));
            }
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            taggingService.addTagScope(container);
                            return null;
                        }
                    }, false, true);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
        return container;
    }

    private String getActivityUserData(String userName, String role) {
        String memberFN = "";
        String memberLN = "";
        NodeRef person = this.personService.getPerson(userName);
        if (person != null) {
            memberFN = (String)((Object)this.directNodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
            memberLN = (String)((Object)this.directNodeService.getProperty(person, ContentModel.PROP_LASTNAME));
        }
        try {
            JSONObject activityData = new JSONObject();
            activityData.put("role", (Object)role);
            activityData.put("memberUserName", (Object)userName);
            activityData.put("memberFirstName", (Object)memberFN);
            activityData.put("memberLastName", (Object)memberLN);
            activityData.put("title", (Object)(memberFN + " " + memberLN + " (" + userName + ")").trim());
            return activityData.toString();
        }
        catch (JSONException je) {
            logger.error((Object)("Failed to get activity data: " + (Object)((Object)je)));
            return "";
        }
    }

    private String getActivityGroupData(String groupName, String role) {
        try {
            JSONObject activityData = new JSONObject();
            activityData.put("role", (Object)role);
            activityData.put("groupName", (Object)groupName);
            return activityData.toString();
        }
        catch (JSONException je) {
            logger.error((Object)("Failed to get activity data: " + (Object)((Object)je)));
            return "";
        }
    }

    private void checkLastManagerRemoval(String shortName, String authorityName, String role) {
        String mgrGroup;
        Set<String> siteUserMangers;
        if ("SiteManager".equals(role) && (siteUserMangers = this.authorityService.getContainedAuthorities(AuthorityType.USER, mgrGroup = this.getSiteRoleGroup(shortName, "SiteManager", true), true)).size() <= 1) {
            Set<String> siteGroupManagers = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, mgrGroup, true);
            if (siteUserMangers.size() + siteGroupManagers.size() == 1) {
                throw new SiteServiceException(MSG_DO_NOT_CHANGE_MGR, new Object[]{authorityName});
            }
        }
    }

    static class 17 {
        static final /* synthetic */ int[] $SwitchMap$org$alfresco$service$cmr$security$AuthorityType;

        static {
            $SwitchMap$org$alfresco$service$cmr$security$AuthorityType = new int[AuthorityType.values().length];
            try {
                17.$SwitchMap$org$alfresco$service$cmr$security$AuthorityType[AuthorityType.USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                17.$SwitchMap$org$alfresco$service$cmr$security$AuthorityType[AuthorityType.GROUP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

