/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.List;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PublicServiceAccessService;
import org.alfresco.service.cmr.site.SiteInfo;

public class SitesPermissionCleaner {
    private NodeService nodeService;
    private PermissionService permissionService;
    private PublicServiceAccessService publicServiceAccessService;
    private SiteServiceImpl siteServiceImpl;
    private AclDAO aclDAO;
    private NodeDAO nodeDAO;
    private TenantService tenantService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setSiteServiceImpl(SiteServiceImpl siteServiceImpl) {
        this.siteServiceImpl = siteServiceImpl;
    }

    public void setPublicServiceAccessService(PublicServiceAccessService publicServiceAccessService) {
        this.publicServiceAccessService = publicServiceAccessService;
    }

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void cleanSitePermissions(NodeRef targetNode, SiteInfo containingSite) {
        if (this.nodeService.exists(targetNode)) {
            if (containingSite == null) {
                containingSite = this.siteServiceImpl.getSite(targetNode);
            }
            if (containingSite != null) {
                Long targetNodeID = (Long)this.nodeDAO.getNodePair(this.tenantService.getName(targetNode)).getFirst();
                Long targetNodeAclID = this.nodeDAO.getNodeAclId(targetNodeID);
                Acl targetNodeAcl = this.aclDAO.getAcl(targetNodeAclID);
                if (targetNodeAcl.getAclType() == ACLType.DEFINING) {
                    AccessControlList targetNodeAccessControlList = this.aclDAO.getAccessControlList(targetNodeAclID);
                    List<AccessControlEntry> targetNodeAclEntries = targetNodeAccessControlList.getEntries();
                    for (AccessControlEntry entry : targetNodeAclEntries) {
                        String authority = entry.getAuthority();
                        String thisSiteGroupPrefix = this.siteServiceImpl.getSiteGroup(containingSite.getShortName(), true);
                        if (!authority.startsWith("GROUP_") || authority.startsWith("GROUP_EVERYONE") || authority.startsWith(thisSiteGroupPrefix)) continue;
                        if (this.publicServiceAccessService.hasAccess("PermissionService", "clearPermission", targetNode, authority) == AccessStatus.ALLOWED) {
                            this.permissionService.clearPermission(targetNode, authority);
                        }
                        if (this.publicServiceAccessService.hasAccess("PermissionService", "setInheritParentPermissions", targetNode, true) != AccessStatus.ALLOWED) continue;
                        this.permissionService.setInheritParentPermissions(targetNode, true);
                    }
                }
                List<NodeIdAndAclId> childNodeIds = this.nodeDAO.getPrimaryChildrenAcls(targetNodeID);
                for (NodeIdAndAclId nextChild : childNodeIds) {
                    this.cleanSitePermissions((NodeRef)this.nodeDAO.getNodePair(nextChild.getId()).getSecond(), containingSite);
                }
            }
        }
    }
}

