/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.TagDetailsImpl;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateTagScopesActionExecuter
extends ActionExecuterAbstractBase {
    private static final Log logger = LogFactory.getLog(UpdateTagScopesActionExecuter.class);
    private NodeService nodeService;
    private ContentService contentService;
    private TaggingService taggingService;
    private AuditService auditService;
    private JobLockService jobLockService;
    private TransactionService transactionService;
    private BehaviourFilter behaviourFilter;
    public static final String NAME = "update-tagscope";
    public static final String PARAM_TAG_SCOPES = "tag_scopes";
    private static final int tagUpdateBatchSize = 100;
    private static final int tagScopeLockTime = 2500;
    private static final String noderefPath = "/tagging/node/value";
    private static final String tagsPath = "/tagging/tags/value";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        try {
            List tagScopeNodes = (List)((Object)action.getParameterValue(PARAM_TAG_SCOPES));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to process tag scope updates for scopes " + tagScopeNodes));
            }
            Iterator i$ = tagScopeNodes.iterator();
            while (i$.hasNext()) {
                NodeRef tmpTagScope;
                final NodeRef tagScope = tmpTagScope = (NodeRef)i$.next();
                try {
                    String lock = this.lockTagScope(tagScope);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Locked tag scope " + tagScope + " for updates"));
                    }
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            final MutableInt updatesRemain = new MutableInt(1);
                            while (updatesRemain.intValue() > 0) {
                                UpdateTagScopesActionExecuter.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                                    @Override
                                    public Void execute() throws Throwable {
                                        HashMap updates = new HashMap();
                                        List entryIds = UpdateTagScopesActionExecuter.this.searchForUpdates(tagScope, updates);
                                        if (logger.isDebugEnabled()) {
                                            if (updates.size() > 0) {
                                                logger.debug((Object)("Found updates for tag scope " + tagScope + " : " + updates));
                                            } else if (updatesRemain.intValue() > 1) {
                                                logger.debug((Object)("All updates now processed for tag scope " + tagScope));
                                            } else {
                                                logger.debug((Object)("No updates needed for tag scope " + tagScope));
                                            }
                                        }
                                        if (updates.size() == 0) {
                                            updatesRemain.setValue(0);
                                            return null;
                                        }
                                        updatesRemain.setValue(updatesRemain.intValue() + 1);
                                        UpdateTagScopesActionExecuter.this.performUpdates(tagScope, updates);
                                        UpdateTagScopesActionExecuter.this.markUpdatesPerformed(entryIds);
                                        return null;
                                    }
                                }, false, true);
                            }
                            return null;
                        }
                    }, (String)AuthenticationUtil.getSystemUserName());
                    this.unlockTagScope(tagScope, lock);
                }
                catch (LockAcquisitionException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Tag scope " + tagScope + " is already being processed by another action, skipping"));
                }
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to update the tag scopes.", exception);
        }
    }

    private List<Long> searchForUpdates(NodeRef tagScopeNode, final Map<String, Integer> updates) {
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName("Alfresco Tagging Service");
        params.addSearchKey(noderefPath, (Serializable)((Object)tagScopeNode.toString()));
        final ArrayList<Long> ids = new ArrayList<Long>();
        this.auditService.auditQuery(new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return true;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                logger.warn((Object)("Error fetching tagging update entry - " + errorMsg), error);
                return true;
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                ids.add(entryId);
                if (values.containsKey(UpdateTagScopesActionExecuter.tagsPath)) {
                    HashMap changes = (HashMap)values.get(UpdateTagScopesActionExecuter.tagsPath);
                    for (String tagName : changes.keySet()) {
                        int count = 0;
                        if (updates.containsKey(tagName)) {
                            count = (Integer)updates.get(tagName);
                        }
                        updates.put(tagName, count += ((Integer)changes.get(tagName)).intValue());
                    }
                } else {
                    logger.warn((Object)("Unexpected Tag Scope update entry of " + values));
                }
                return true;
            }
        }, params, 100);
        return ids;
    }

    private void markUpdatesPerformed(List<Long> ids) {
        this.auditService.clearAudit(ids);
    }

    private void performUpdates(NodeRef tagScopeNode, Map<String, Integer> updates) {
        if (this.nodeService.exists(tagScopeNode)) {
            List<TagDetails> tags = null;
            this.behaviourFilter.disableBehaviour();
            ContentReader contentReader = this.contentService.getReader(tagScopeNode, ContentModel.PROP_TAGSCOPE_CACHE);
            tags = contentReader == null ? new ArrayList<TagDetails>(1) : TaggingServiceImpl.readTagDetails(contentReader.getContentInputStream());
            String previousTagState = tags.toString();
            for (String tagName : updates.keySet()) {
                int change = updates.get(tagName);
                if (change == 0) continue;
                TagDetailsImpl currentTag = null;
                for (TagDetails tag : tags) {
                    if (!tag.getName().equals(tagName)) continue;
                    currentTag = (TagDetailsImpl)tag;
                    break;
                }
                if (change > 0) {
                    if (currentTag == null) {
                        currentTag = new TagDetailsImpl(tagName, 0);
                        tags.add(currentTag);
                    }
                    for (int i = 0; i < change; ++i) {
                        currentTag.incrementCount();
                    }
                    continue;
                }
                if (currentTag == null) continue;
                for (int i = change; i < 0; ++i) {
                    currentTag.decrementCount();
                }
                if (currentTag.getCount() > 0) continue;
                tags.remove(currentTag);
            }
            Collections.sort(tags);
            String tagContent = TaggingServiceImpl.tagDetailsToString(tags);
            ContentWriter contentWriter = this.contentService.getWriter(tagScopeNode, ContentModel.PROP_TAGSCOPE_CACHE, true);
            contentWriter.setEncoding("UTF-8");
            contentWriter.setMimetype("text/plain");
            contentWriter.putContent(tagContent);
            this.behaviourFilter.enableBehaviour();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updated tag scope " + tagScopeNode + " with " + updates + ", " + "new contents are { " + tagContent.replace("\n", " : ") + " } " + "from old contents of " + previousTagState));
            }
        }
    }

    public List<NodeRef> searchForTagScopesPendingUpdates() {
        final HashSet tagNodesStrs = new HashSet();
        final AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName("Alfresco Tagging Service");
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                UpdateTagScopesActionExecuter.this.auditService.auditQuery(new AuditService.AuditQueryCallback(){

                    @Override
                    public boolean valuesRequired() {
                        return true;
                    }

                    @Override
                    public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                        logger.warn((Object)("Error fetching tagging update entry - " + errorMsg), error);
                        return true;
                    }

                    @Override
                    public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                        if (values.containsKey(UpdateTagScopesActionExecuter.noderefPath)) {
                            String nodeRefStr = (String)((Object)values.get(UpdateTagScopesActionExecuter.noderefPath));
                            if (!tagNodesStrs.contains(nodeRefStr)) {
                                tagNodesStrs.add(nodeRefStr);
                            }
                        } else {
                            logger.warn((Object)("Unexpected Tag Scope update entry of " + values));
                        }
                        return true;
                    }
                }, params, 400);
                return null;
            }
        }, false, true);
        ArrayList<NodeRef> tagNodes = new ArrayList<NodeRef>();
        for (String nodeRefStr : tagNodesStrs) {
            tagNodes.add(new NodeRef(nodeRefStr));
        }
        return tagNodes;
    }

    private QName tagScopeToLockQName(NodeRef tagScope) {
        QName lockQName = QName.createQName((String)("TagScope_" + tagScope.toString()));
        return lockQName;
    }

    protected String lockTagScope(NodeRef tagScope) {
        String lock = this.jobLockService.getLock(this.tagScopeToLockQName(tagScope), 2500L, 0L, 0);
        return lock;
    }

    protected void updateTagScopeLock(NodeRef tagScope, String lockToken) {
        this.jobLockService.refreshLock(lockToken, this.tagScopeToLockQName(tagScope), 2500L);
    }

    protected void unlockTagScope(NodeRef tagScope, String lockToken) {
        this.jobLockService.releaseLock(lockToken, this.tagScopeToLockQName(tagScope));
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TAG_SCOPES, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_TAG_SCOPES)));
    }
}

