/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionHistoryImpl
implements VersionHistory {
    private static Log logger = LogFactory.getLog(VersionHistoryImpl.class);
    private static final long serialVersionUID = 3257001051558326840L;
    private static final String ERR_MSG = "The root version must be specified when creating a version history object.";
    private transient List<Version> versions;
    private HashMap<String, String> versionHistory = null;
    private HashMap<String, Version> versionsByLabel = null;
    private static Comparator<Version> versionComparatorDesc = new VersionComparatorDesc();
    private Version rootVersion;

    public VersionHistoryImpl(Version rootVersion) {
        if (rootVersion == null) {
            throw new VersionServiceException(ERR_MSG);
        }
        this.versionHistory = new HashMap();
        this.versionsByLabel = new HashMap();
        this.rootVersion = rootVersion;
        this.addVersion(rootVersion, null);
    }

    @Override
    public Version getRootVersion() {
        return this.rootVersion;
    }

    @Override
    public Version getHeadVersion() {
        Collection<Version> versions = this.versionsByLabel.values();
        ArrayList<Version> sortedVersions = new ArrayList<Version>(versions);
        Collections.sort(sortedVersions, versionComparatorDesc);
        return (Version)sortedVersions.get(0);
    }

    @Override
    public Collection<Version> getAllVersions() {
        Collection<Version> versions = this.versionsByLabel.values();
        ArrayList<Version> sortedVersions = new ArrayList<Version>(versions);
        Collections.sort(sortedVersions, versionComparatorDesc);
        return sortedVersions;
    }

    @Override
    public Version getPredecessor(Version version) {
        Version result = null;
        if (version != null) {
            result = this.getVersion(this.versionHistory.get(version.getVersionLabel()));
        }
        return result;
    }

    @Override
    public Collection<Version> getSuccessors(Version version) {
        String versionLabel;
        ArrayList<Version> result = new ArrayList<Version>();
        if (version != null && this.versionHistory.containsValue(versionLabel = version.getVersionLabel())) {
            for (String key : this.versionHistory.keySet()) {
                if (!EqualsHelper.nullSafeEquals((Object)this.versionHistory.get(key), (Object)versionLabel)) continue;
                result.add(this.getVersion(key));
            }
        }
        return result;
    }

    @Override
    public Version getVersion(String versionLabel) {
        Version result = null;
        if (versionLabel != null && (result = this.versionsByLabel.get(versionLabel)) == null) {
            throw new VersionDoesNotExistException(versionLabel);
        }
        return result;
    }

    public void addVersion(Version version, Version predecessor) {
        this.versionsByLabel.put(version.getVersionLabel(), version);
        if (predecessor != null) {
            this.versionHistory.put(version.getVersionLabel(), predecessor.getVersionLabel());
        }
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = is.readFields();
        if (fields.defaulted("versionsByLabel")) {
            this.rootVersion = (Version)fields.get("rootVersion", null);
            this.versionsByLabel = (HashMap)fields.get("versions", new HashMap());
            this.versionHistory = (HashMap)fields.get("versionHistory", new HashMap());
        } else {
            this.rootVersion = (Version)fields.get("rootVersion", null);
            this.versionsByLabel = (HashMap)fields.get("versionsByLabel", new HashMap());
            this.versionHistory = (HashMap)fields.get("versionHistory", new HashMap());
        }
    }

    public static class VersionComparatorAsc
    implements Comparator<Version>,
    Serializable {
        private static final long serialVersionUID = 6227528170880231770L;

        @Override
        public int compare(Version v1, Version v2) {
            int result = 0;
            if (null != v1 && null != v2) {
                Serializable dbIdV2;
                Serializable dbIdV1 = null != v1.getVersionProperties() ? v1.getVersionProperties().get(ContentModel.PROP_NODE_DBID.getLocalName()) : null;
                Serializable serializable = dbIdV2 = null != v2.getVersionProperties() ? v2.getVersionProperties().get(ContentModel.PROP_NODE_DBID.getLocalName()) : null;
                if (null != dbIdV1 && null != dbIdV2) {
                    Long id1 = dbIdV1 instanceof Integer ? (long)((Integer)dbIdV1).intValue() : (Long)dbIdV1;
                    Long id2 = dbIdV2 instanceof Integer ? (long)((Integer)dbIdV2).intValue() : (Long)dbIdV2;
                    result = id1.compareTo(id2);
                } else {
                    logger.warn((Object)"DB Id of versioned node is missing!");
                }
            }
            return result;
        }
    }

    public static class VersionComparatorDesc
    implements Comparator<Version>,
    Serializable {
        private static final long serialVersionUID = 6227528170880231770L;

        @Override
        public int compare(Version v1, Version v2) {
            int result = 0;
            if (null != v1 && null != v2) {
                Serializable dbIdV2;
                Serializable dbIdV1 = null != v1.getVersionProperties() ? v1.getVersionProperties().get(ContentModel.PROP_NODE_DBID.getLocalName()) : null;
                Serializable serializable = dbIdV2 = null != v2.getVersionProperties() ? v2.getVersionProperties().get(ContentModel.PROP_NODE_DBID.getLocalName()) : null;
                if (null != dbIdV1 && null != dbIdV2) {
                    Long id1 = dbIdV1 instanceof Integer ? (long)((Integer)dbIdV1).intValue() : (Long)dbIdV1;
                    Long id2 = dbIdV2 instanceof Integer ? (long)((Integer)dbIdV2).intValue() : (Long)dbIdV2;
                    result = id2.compareTo(id1);
                } else {
                    logger.warn((Object)"DB Id of versioned node is missing!");
                }
            }
            return result;
        }
    }
}

