/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.AbstractActivitiComponentTest;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.QName;
import org.junit.Test;

public class ActivitiWorkflowComponentTest
extends AbstractActivitiComponentTest {
    @Test
    public void testDeployDefinition() throws Exception {
        ProcessDefinition defInDB = (ProcessDefinition)this.repo.createProcessDefinitionQuery().processDefinitionKey("testTask").singleResult();
        Assert.assertNull((String)"The definition is already deployed!", (Object)defInDB);
        WorkflowDefinition definition = this.deployTestTaskDefinition();
        String localDefId = BPMEngineRegistry.getLocalId(definition.getId());
        ProcessDefinition processDef = (ProcessDefinition)this.repo.createProcessDefinitionQuery().processDefinitionId(localDefId).singleResult();
        Assert.assertNotNull((String)"Process Definition should have been deployed!", (Object)processDef);
        ProcessDefinition def2InDB = (ProcessDefinition)this.repo.createProcessDefinitionQuery().processDefinitionKey("testAdhoc").singleResult();
        Assert.assertNull((String)"The definition is already deployed!", (Object)def2InDB);
        WorkflowDefinition definition2 = this.deployTestTaskDefinition();
        String localDef2Id = BPMEngineRegistry.getLocalId(definition2.getId());
        ProcessDefinition processDef2 = (ProcessDefinition)this.repo.createProcessDefinitionQuery().processDefinitionId(localDef2Id).singleResult();
        Assert.assertNotNull((String)"Process Definition should have been deployed!", (Object)processDef2);
    }

    @Test
    public void testIsDefinitionDeployed() throws Exception {
        InputStream input = this.getInputStream("activiti/testTransaction.bpmn20.xml");
        boolean result = this.workflowEngine.isDefinitionDeployed(input, "text/xml");
        Assert.assertFalse((String)"Should return false before process def deployed.", (boolean)result);
        this.deployTestTaskDefinition();
        input = this.getInputStream("activiti/testTransaction.bpmn20.xml");
        result = this.workflowEngine.isDefinitionDeployed(input, "text/xml");
        Assert.assertTrue((String)"Should return true after process def deployed.", (boolean)result);
        input = this.getInputStream("activiti/testAdhoc.bpmn20.xml");
        result = this.workflowEngine.isDefinitionDeployed(input, "text/xml");
        Assert.assertFalse((String)"Should not find Adhoc definition.", (boolean)result);
    }

    @Test
    public void testUndeployDefinition() throws Exception {
        WorkflowDefinition definition = this.deployTestTaskDefinition();
        String localId = BPMEngineRegistry.getLocalId(definition.getId());
        long defCount = this.repo.createProcessDefinitionQuery().processDefinitionId(localId).count();
        Assert.assertEquals((String)"The deployed process definition should exist!", (long)1L, (long)defCount);
        this.workflowEngine.undeployDefinition(definition.getId());
        defCount = this.repo.createProcessDefinitionQuery().processDefinitionId(localId).count();
        Assert.assertEquals((String)"The undeployed process definition should not exist!", (long)0L, (long)defCount);
    }

    @Test
    public void testGetDefinitionById() throws Exception {
        WorkflowDefinition definition = this.deployTestTaskDefinition();
        WorkflowDefinition result = this.workflowEngine.getDefinitionById(definition.getId());
        Assert.assertNotNull((String)"The workflow definition was not found!", (Object)result);
        Assert.assertEquals((String)definition.getId(), (String)result.getId());
        Assert.assertEquals((String)definition.getDescription(), (String)result.getDescription());
        Assert.assertEquals((String)definition.getName(), (String)result.getName());
        Assert.assertEquals((String)definition.getTitle(), (String)result.getTitle());
        Assert.assertEquals((String)definition.getVersion(), (String)result.getVersion());
        WorkflowTaskDefinition resultStartDef = result.getStartTaskDefinition();
        Assert.assertNotNull((String)"Start task is null!", (Object)resultStartDef);
        WorkflowTaskDefinition originalStartDef = definition.getStartTaskDefinition();
        Assert.assertEquals((String)"Start task Id does not match!", (String)originalStartDef.getId(), (String)resultStartDef.getId());
        WorkflowNode resultNode = resultStartDef.getNode();
        Assert.assertNotNull((String)"Start Task Node is null!", (Object)resultNode);
        Assert.assertEquals((String)"Start Task Node Name does not match!", (String)originalStartDef.getNode().getName(), (String)resultNode.getName());
        TypeDefinition metaData = resultStartDef.getMetadata();
        Assert.assertNotNull((String)"Start Task Metadata is null!", (Object)metaData);
        Assert.assertEquals((String)"Start Task Metadata name does not match!", (Object)originalStartDef.getMetadata().getName(), (Object)metaData.getName());
        this.workflowEngine.undeployDefinition(definition.getId());
        WorkflowDefinition nullResult = this.workflowEngine.getDefinitionById(definition.getId());
        Assert.assertNull((String)"The workflow definition was found but should be null!", (Object)nullResult);
    }

    @Test
    public void testGetDefinitionByName() throws Exception {
        WorkflowDefinition definition = this.deployTestTaskDefinition();
        WorkflowDefinition result = this.workflowEngine.getDefinitionByName(definition.getName());
        Assert.assertNotNull((String)"The workflow definition was not found!", (Object)result);
        Assert.assertEquals((String)definition.getId(), (String)result.getId());
        Assert.assertEquals((String)definition.getDescription(), (String)result.getDescription());
        Assert.assertEquals((String)definition.getName(), (String)result.getName());
        Assert.assertEquals((String)definition.getTitle(), (String)result.getTitle());
        Assert.assertEquals((String)definition.getVersion(), (String)result.getVersion());
        this.workflowEngine.undeployDefinition(definition.getId());
        WorkflowDefinition nullResult = this.workflowEngine.getDefinitionByName(definition.getName());
        Assert.assertNull((String)"The workflow definition was found but should be null!", (Object)nullResult);
    }

    @Test
    public void testGetDefinitions() throws Exception {
        List<WorkflowDefinition> startDefs = this.workflowEngine.getDefinitions();
        WorkflowDefinition defV1 = this.deployTestTaskDefinition();
        List<WorkflowDefinition> definitions = this.workflowEngine.getDefinitions();
        this.checkDefinitions(definitions, startDefs, defV1);
        WorkflowDefinition defV2 = this.deployTestTaskDefinition();
        definitions = this.workflowEngine.getDefinitions();
        this.checkDefinitions(definitions, startDefs, defV2);
        WorkflowDefinition adhocDef = this.deployTestAdhocDefinition();
        definitions = this.workflowEngine.getDefinitions();
        this.checkDefinitions(definitions, startDefs, defV2, adhocDef);
    }

    @Test
    public void testGetAllDefinitions() throws Exception {
        List<WorkflowDefinition> startDefs = this.workflowEngine.getAllDefinitions();
        WorkflowDefinition defV1 = this.deployTestTaskDefinition();
        List<WorkflowDefinition> definitions = this.workflowEngine.getAllDefinitions();
        this.checkDefinitions(definitions, startDefs, defV1);
        WorkflowDefinition defV2 = this.deployTestTaskDefinition();
        definitions = this.workflowEngine.getAllDefinitions();
        this.checkDefinitions(definitions, startDefs, defV1, defV2);
        WorkflowDefinition adhocDef = this.deployTestAdhocDefinition();
        definitions = this.workflowEngine.getAllDefinitions();
        this.checkDefinitions(definitions, startDefs, defV1, defV2, adhocDef);
    }

    @Test
    public void testStartWorkflow() throws Exception {
        WorkflowDefinition def = this.deployTestTaskDefinition();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        Date dueDate = Calendar.getInstance().getTime();
        properties.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)"description123"));
        properties.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        properties.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(2));
        WorkflowPath path = this.workflowEngine.startWorkflow(def.getId(), properties);
        Assert.assertNotNull((String)"The workflow path is null!", (Object)path);
        String executionId = BPMEngineRegistry.getLocalId(path.getId());
        Execution execution = (Execution)this.runtime.createExecutionQuery().executionId(executionId).singleResult();
        Assert.assertNotNull((String)"No execution was created int he DB!", (Object)execution);
        WorkflowInstance instance = path.getInstance();
        Assert.assertNotNull((String)"The workflow instance is null!", (Object)instance);
        String procInstanceId = BPMEngineRegistry.getLocalId(instance.getId());
        ProcessInstance procInstance = (ProcessInstance)this.runtime.createProcessInstanceQuery().processInstanceId(procInstanceId).singleResult();
        Assert.assertNotNull((String)"No process instance was created!", (Object)procInstance);
        WorkflowNode node = path.getNode();
        Assert.assertNotNull((String)"The workflow node is null!", (Object)node);
        String nodeName = node.getName();
        Assert.assertEquals((String)"task", (String)nodeName);
        ScriptNode companyHome = (ScriptNode)this.runtime.getVariable(procInstanceId, "companyhome");
        Assert.assertNotNull((Object)companyHome);
        Assert.assertEquals((String)"companyHome", (String)companyHome.getNodeRef().getStoreRef().getIdentifier());
        ScriptNode initiator = (ScriptNode)this.runtime.getVariable(procInstanceId, "initiator");
        Assert.assertNotNull((Object)initiator);
        Assert.assertEquals((String)"admin", (String)initiator.getNodeRef().getStoreRef().getIdentifier());
        ScriptNode initiatorHome = (ScriptNode)this.runtime.getVariable(procInstanceId, "initiatorhome");
        Assert.assertNotNull((Object)initiatorHome);
        Assert.assertEquals((String)"admin-home", (String)initiatorHome.getNodeRef().getStoreRef().getIdentifier());
        Assert.assertNotNull((Object)path.getInstance().getStartDate());
        Assert.assertNull((Object)path.getInstance().getEndDate());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(procInstanceId).singleResult();
        Assert.assertNotNull((String)"Task should have been created", (Object)task);
        Assert.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        String defaultSetVariable = (String)this.taskService.getVariableLocal(task.getId(), "test_myProp");
        Assert.assertEquals((String)"Default value", (String)defaultSetVariable);
        Assert.assertEquals((String)"description123", (String)task.getDescription());
    }

    @Test
    public void testSignal() throws Exception {
        WorkflowDefinition def = this.deployTestSignallingDefinition();
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()));
        String procId = processInstance.getId();
        List nodeIds = this.runtime.getActiveActivityIds(procId);
        Assert.assertEquals((int)1, (int)nodeIds.size());
        Assert.assertEquals((String)"task1", (String)((String)nodeIds.get(0)));
        String pathId = BPMEngineRegistry.createGlobalId("activiti", procId);
        WorkflowPath path = this.workflowEngine.signal(pathId, null);
        Assert.assertEquals((String)pathId, (String)path.getId());
        Assert.assertEquals((String)"task2", (String)path.getNode().getName());
        Assert.assertEquals((String)pathId, (String)path.getInstance().getId());
        Assert.assertTrue((boolean)path.isActive());
        nodeIds = this.runtime.getActiveActivityIds(procId);
        Assert.assertEquals((int)1, (int)nodeIds.size());
        Assert.assertEquals((String)"task2", (String)((String)nodeIds.get(0)));
        path = this.workflowEngine.signal(pathId, null);
        Assert.assertEquals((String)pathId, (String)path.getId());
        Assert.assertNull((Object)path.getNode());
        Assert.assertEquals((String)pathId, (String)path.getInstance().getId());
        Assert.assertFalse((boolean)path.isActive());
    }

    @Test
    public void testCancelWorkflow() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()));
        List<WorkflowInstance> instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)1, (int)instances.size());
        Assert.assertEquals((String)processInstance.getId(), (String)BPMEngineRegistry.getLocalId(instances.get(0).getId()));
        WorkflowInstance cancelledWorkflow = this.workflowEngine.cancelWorkflow(instances.get(0).getId());
        Assert.assertFalse((boolean)cancelledWorkflow.isActive());
        instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)0, (int)instances.size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testCancelUnexistingWorkflow() throws Exception {
        try {
            String globalId = this.workflowEngine.createGlobalId("unexistingWorkflowId");
            this.workflowEngine.cancelWorkflow(globalId);
            Assert.fail((String)"Exception expected");
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteWorkflow() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()));
        List<WorkflowInstance> instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)1, (int)instances.size());
        Assert.assertEquals((String)processInstance.getId(), (String)BPMEngineRegistry.getLocalId(instances.get(0).getId()));
        this.workflowEngine.deleteWorkflow(instances.get(0).getId());
        instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)0, (int)instances.size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testDeleteFinishedWorkflow() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()));
        List<WorkflowInstance> instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)1, (int)instances.size());
        Assert.assertEquals((String)processInstance.getId(), (String)BPMEngineRegistry.getLocalId(instances.get(0).getId()));
        WorkflowInstance instance = instances.get(0);
        WorkflowTask startTask = this.workflowEngine.getStartTask(instance.getId());
        this.workflowEngine.endTask(startTask.getId(), null);
        WorkflowTask adhocTask = this.workflowEngine.getTasksForWorkflowPath(instance.getId()).get(0);
        this.workflowEngine.endTask(adhocTask.getId(), null);
        instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)0, (int)instances.size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        this.workflowEngine.deleteWorkflow(instance.getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testDeleteUnexistingWorkflow() throws Exception {
        try {
            String globalId = this.workflowEngine.createGlobalId("unexistingWorkflowId");
            this.workflowEngine.deleteWorkflow(globalId);
            Assert.fail((String)"Exception expected");
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
    }

    @Test
    public void testGetActiveWorkflows() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        String activitiProcessDefinitionId = BPMEngineRegistry.getLocalId(def.getId());
        ProcessInstance activeInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance completedInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance cancelledInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance deletedInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        String completedId = completedInstance.getId();
        boolean isActive = true;
        while (isActive) {
            Execution execution = (Execution)this.runtime.createExecutionQuery().processInstanceId(completedId).singleResult();
            this.runtime.signal(execution.getId());
            ProcessInstance instance = (ProcessInstance)this.runtime.createProcessInstanceQuery().processInstanceId(completedId).singleResult();
            isActive = instance != null;
        }
        this.workflowEngine.cancelWorkflow(this.workflowEngine.createGlobalId(cancelledInstance.getId()));
        this.workflowEngine.deleteWorkflow(this.workflowEngine.createGlobalId(deletedInstance.getId()));
        List<WorkflowInstance> instances = this.workflowEngine.getActiveWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)1, (int)instances.size());
        String instanceId = instances.get(0).getId();
        Assert.assertEquals((String)activeInstance.getId(), (String)BPMEngineRegistry.getLocalId(instanceId));
    }

    @Test
    public void testGetCompletedWorkflows() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        String activitiProcessDefinitionId = BPMEngineRegistry.getLocalId(def.getId());
        this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance completedInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance cancelledInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance deletedInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        String completedId = completedInstance.getId();
        boolean isActive = true;
        while (isActive) {
            Execution execution = (Execution)this.runtime.createExecutionQuery().processInstanceId(completedId).singleResult();
            this.runtime.signal(execution.getId());
            ProcessInstance instance = (ProcessInstance)this.runtime.createProcessInstanceQuery().processInstanceId(completedId).singleResult();
            isActive = instance != null;
        }
        this.workflowEngine.cancelWorkflow(this.workflowEngine.createGlobalId(cancelledInstance.getId()));
        this.workflowEngine.deleteWorkflow(this.workflowEngine.createGlobalId(deletedInstance.getId()));
        List<WorkflowInstance> instances = this.workflowEngine.getCompletedWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)1, (int)instances.size());
        String instanceId = instances.get(0).getId();
        Assert.assertEquals((String)completedId, (String)BPMEngineRegistry.getLocalId(instanceId));
    }

    @Test
    public void testGetWorkflows() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        String activitiProcessDefinitionId = BPMEngineRegistry.getLocalId(def.getId());
        ProcessInstance activeInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance completedInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance cancelledInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        ProcessInstance deletedInstance = this.runtime.startProcessInstanceById(activitiProcessDefinitionId);
        String completedId = completedInstance.getId();
        boolean isActive = true;
        while (isActive) {
            Execution execution = (Execution)this.runtime.createExecutionQuery().processInstanceId(completedId).singleResult();
            this.runtime.signal(execution.getId());
            ProcessInstance instance = (ProcessInstance)this.runtime.createProcessInstanceQuery().processInstanceId(completedId).singleResult();
            isActive = instance != null;
        }
        this.workflowEngine.cancelWorkflow(this.workflowEngine.createGlobalId(cancelledInstance.getId()));
        this.workflowEngine.deleteWorkflow(this.workflowEngine.createGlobalId(deletedInstance.getId()));
        List<WorkflowInstance> instances = this.workflowEngine.getWorkflows(def.getId());
        Assert.assertNotNull(instances);
        Assert.assertEquals((int)2, (int)instances.size());
        String instanceId = instances.get(0).getId();
        Assert.assertEquals((String)activeInstance.getId(), (String)BPMEngineRegistry.getLocalId(instanceId));
        instanceId = instances.get(1).getId();
        Assert.assertEquals((String)completedId, (String)BPMEngineRegistry.getLocalId(instanceId));
    }

    @Test
    public void testGetWorkflowById() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        Date startTime = new SimpleDateFormat("dd-MM-yyy hh:mm:ss").parse("01-01-2011 12:11:10");
        ClockUtil.setCurrentTime((Date)startTime);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Date dueDate = Calendar.getInstance().getTime();
        this.putVariable(variables, WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        this.putVariable(variables, WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "I'm the description");
        this.putVariable(variables, WorkflowModel.PROP_CONTEXT, new ActivitiScriptNode(testWorkflowContext, this.serviceRegistry));
        this.putVariable(variables, WorkflowModel.ASSOC_PACKAGE, new ActivitiScriptNode(testWorkflowPackage, this.serviceRegistry));
        this.putVariable(variables, WorkflowModel.PROP_WORKFLOW_PRIORITY, 3);
        variables.put("initiator", new ActivitiScriptNode(adminHomeNode, this.serviceRegistry));
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()), variables);
        String globalProcessInstanceId = BPMEngineRegistry.createGlobalId("activiti", processInstance.getProcessInstanceId());
        WorkflowInstance workflowInstance = this.workflowEngine.getWorkflowById(globalProcessInstanceId);
        Assert.assertNotNull((Object)workflowInstance);
        Assert.assertEquals((String)globalProcessInstanceId, (String)workflowInstance.getId());
        Assert.assertNull((Object)workflowInstance.getEndDate());
        Assert.assertTrue((boolean)workflowInstance.isActive());
        Assert.assertEquals((String)"I'm the description", (String)workflowInstance.getDescription());
        Assert.assertEquals((Object)dueDate, (Object)workflowInstance.getDueDate());
        Assert.assertEquals((String)def.getId(), (String)workflowInstance.getDefinition().getId());
        Assert.assertEquals((Object)adminHomeNode, (Object)workflowInstance.getInitiator());
        Assert.assertEquals((Object)testWorkflowContext, (Object)workflowInstance.getContext());
        Assert.assertEquals((Object)testWorkflowPackage, (Object)workflowInstance.getWorkflowPackage());
        Assert.assertNotNull((Object)workflowInstance.getPriority());
        Assert.assertEquals((int)3, (int)workflowInstance.getPriority());
        Assert.assertEquals((Object)startTime, (Object)workflowInstance.getStartDate());
        ClockUtil.setCurrentTime(null);
    }

    @Test
    public void testGetCompletedWorkflowById() throws Exception {
        WorkflowDefinition def = this.deployTestAdhocDefinition();
        Date startTime = new SimpleDateFormat("dd-MM-yyy hh:mm:ss").parse("01-01-2011 01:02:03");
        ClockUtil.setCurrentTime((Date)startTime);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Date dueDate = Calendar.getInstance().getTime();
        this.putVariable(variables, WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        this.putVariable(variables, WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "I'm the description");
        this.putVariable(variables, WorkflowModel.PROP_CONTEXT, new ActivitiScriptNode(testWorkflowContext, this.serviceRegistry));
        this.putVariable(variables, WorkflowModel.ASSOC_PACKAGE, new ActivitiScriptNode(testWorkflowPackage, this.serviceRegistry));
        this.putVariable(variables, WorkflowModel.PROP_WORKFLOW_PRIORITY, 3);
        variables.put("initiator", new ActivitiScriptNode(adminHomeNode, this.serviceRegistry));
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()), variables);
        String globalProcessInstanceId = BPMEngineRegistry.createGlobalId("activiti", processInstance.getProcessInstanceId());
        Date endTime = new SimpleDateFormat("dd-MM-yyy hh:mm:ss").parse("01-01-2011 02:03:04");
        ClockUtil.setCurrentTime((Date)endTime);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(task.getId());
        WorkflowInstance workflowInstance = this.workflowEngine.getWorkflowById(globalProcessInstanceId);
        Assert.assertNotNull((Object)workflowInstance);
        Assert.assertEquals((String)globalProcessInstanceId, (String)workflowInstance.getId());
        Assert.assertEquals((Object)endTime, (Object)workflowInstance.getEndDate());
        Assert.assertFalse((boolean)workflowInstance.isActive());
        Assert.assertEquals((String)"I'm the description", (String)workflowInstance.getDescription());
        Assert.assertEquals((Object)dueDate, (Object)workflowInstance.getDueDate());
        Assert.assertEquals((String)def.getId(), (String)workflowInstance.getDefinition().getId());
        Assert.assertEquals((Object)adminHomeNode, (Object)workflowInstance.getInitiator());
        Assert.assertEquals((Object)testWorkflowContext, (Object)workflowInstance.getContext());
        Assert.assertEquals((Object)testWorkflowPackage, (Object)workflowInstance.getWorkflowPackage());
        Assert.assertNotNull((Object)workflowInstance.getPriority());
        Assert.assertEquals((int)3, (int)workflowInstance.getPriority());
        Assert.assertEquals((Object)startTime, (Object)workflowInstance.getStartDate());
        ClockUtil.setCurrentTime(null);
    }

    @Test
    public void testGetTimers() throws Exception {
        WorkflowDefinition def = this.deployTestJobDefinition();
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(def.getId()));
        String workflowInstanceId = BPMEngineRegistry.createGlobalId("activiti", processInstance.getProcessInstanceId());
        Job timerJob = (Job)this.managementService.createJobQuery().timers().processInstanceId(processInstance.getId()).singleResult();
        String globalJobId = BPMEngineRegistry.createGlobalId("activiti", timerJob.getId());
        List<WorkflowTimer> timers = this.workflowEngine.getTimers(workflowInstanceId);
        Assert.assertNotNull(timers);
        Assert.assertEquals((int)1, (int)timers.size());
        WorkflowTimer timer = timers.get(0);
        Assert.assertEquals((String)globalJobId, (String)timer.getId());
        Assert.assertEquals((Object)timerJob.getDuedate(), (Object)timer.getDueDate());
        String expectedTimerPathId = BPMEngineRegistry.createGlobalId("activiti", timerJob.getExecutionId());
        Assert.assertNotNull((Object)timer.getPath());
        Assert.assertEquals((String)expectedTimerPathId, (String)timer.getPath().getId());
        Assert.assertEquals((String)workflowInstanceId, (String)timer.getPath().getInstance().getId());
        Task waitingTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)timer.getTask());
        Assert.assertEquals((String)BPMEngineRegistry.createGlobalId("activiti", waitingTask.getId()), (String)timer.getTask().getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(task.getId());
        timers = this.workflowEngine.getTimers(workflowInstanceId);
        Assert.assertNotNull(timers);
        Assert.assertEquals((int)0, (int)timers.size());
    }

    @Test
    public void testGetWorkflowImage() {
        WorkflowDefinition definitionWithoutImage = this.deployTestAdhocDefinition();
        WorkflowDefinition definitionWithImage = this.deployTestDiagramDefinition();
        ProcessInstance processInstance = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(definitionWithoutImage.getId()));
        String worklfowId = BPMEngineRegistry.createGlobalId("activiti", processInstance.getId());
        Assert.assertFalse((boolean)this.workflowEngine.hasWorkflowImage(worklfowId));
        Assert.assertNull((Object)this.workflowEngine.getWorkflowImage(worklfowId));
        ProcessInstance processInstanceWithImage = this.runtime.startProcessInstanceById(BPMEngineRegistry.getLocalId(definitionWithImage.getId()));
        String worklfowWithImageId = BPMEngineRegistry.createGlobalId("activiti", processInstanceWithImage.getId());
        Assert.assertTrue((boolean)this.workflowEngine.hasWorkflowImage(worklfowWithImageId));
        Assert.assertNotNull((Object)this.workflowEngine.getWorkflowImage(worklfowWithImageId));
    }

    private void putVariable(Map<String, Object> variables, QName varName, Object value) {
        String variableName = this.mapQNameToName(varName);
        variables.put(variableName, value);
    }

    private void checkDefinitions(List<WorkflowDefinition> actual, List<WorkflowDefinition> startDefs, WorkflowDefinition ... expected) {
        Assert.assertEquals((String)"The number of process definitions expected does not match the actual number!", (int)(startDefs.size() + expected.length), (int)actual.size());
        ArrayList<String> ids = new ArrayList<String>(actual.size());
        for (WorkflowDefinition def : actual) {
            ids.add(def.getId());
        }
        for (WorkflowDefinition exp : expected) {
            Assert.assertTrue((String)("Results did not contain expected definition: " + exp), (boolean)ids.contains(exp.getId()));
        }
        ArrayList<String> startIds = new ArrayList<String>(startDefs.size());
        for (WorkflowDefinition def : startDefs) {
            startIds.add(def.getId());
        }
        for (WorkflowDefinition exp : expected) {
            Assert.assertFalse((String)("Starting Definitions should not contain expected definition: " + exp), (boolean)startIds.contains(exp.getId()));
        }
    }
}

