/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.tasklistener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

public class TaskCompleteListener
implements TaskListener {
    private ActivitiPropertyConverter propertyConverter;
    private WorkflowQNameConverter qNameConverter;

    public void notify(DelegateTask task) {
        this.propertyConverter.checkMandatoryProperties(task);
        HashMap<String, Object> endTaskVariables = new HashMap<String, Object>();
        String statusKey = this.qNameConverter.mapQNameToName(WorkflowModel.PROP_STATUS);
        endTaskVariables.put(statusKey, "Completed");
        this.addPooledActorsAsVariable(task, endTaskVariables);
        task.setVariablesLocal(endTaskVariables);
    }

    private void addPooledActorsAsVariable(DelegateTask task, Map<String, Object> variables) {
        List links = ((TaskEntity)task).getIdentityLinks();
        if (links.size() > 0) {
            ArrayList<IdentityLink> identityLinks = new ArrayList<IdentityLink>();
            identityLinks.addAll(links);
            List<NodeRef> pooledActorRefs = this.propertyConverter.getPooledActorsReference(identityLinks);
            ArrayList<String> nodeIds = new ArrayList<String>();
            for (NodeRef ref : pooledActorRefs) {
                nodeIds.add(ref.toString());
            }
            variables.put("pooledActorsHistory", nodeIds);
        }
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)namespaceService);
    }

    public void setPropertyConverter(ActivitiPropertyConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }
}

